/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.service.serialization.mapper.loan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.fineract.accounting.glaccount.data.GLAccountData;
import org.apache.fineract.avro.generic.v1.CodeValueDataV1;
import org.apache.fineract.avro.generic.v1.CurrencyDataV1;
import org.apache.fineract.avro.generic.v1.EnumOptionDataV1;
import org.apache.fineract.avro.generic.v1.StringEnumOptionDataV1;
import org.apache.fineract.avro.gl.v1.GLAccountDataV1;
import org.apache.fineract.avro.loan.v1.DelinquencyBucketDataV1;
import org.apache.fineract.avro.loan.v1.DelinquencyRangeDataV1;
import org.apache.fineract.avro.loan.v1.LoanProductBorrowerCycleVariationDataV1;
import org.apache.fineract.avro.loan.v1.LoanProductDataV1;
import org.apache.fineract.avro.loan.v1.LoanProductGuaranteeDataV1;
import org.apache.fineract.avro.loan.v1.LoanProductInterestRecalculationDataV1;
import org.apache.fineract.avro.payment.v1.PaymentTypeDataV1;
import org.apache.fineract.avro.portfolio.v1.ChargeDataV1;
import org.apache.fineract.avro.portfolio.v1.RateDataV1;
import org.apache.fineract.infrastructure.codes.data.CodeValueData;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.data.StringEnumOptionData;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.loan.LoanProductDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.support.AvroDateTimeMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.support.AvroMonthDayMapper;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.delinquency.data.DelinquencyBucketData;
import org.apache.fineract.portfolio.delinquency.data.DelinquencyRangeData;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductBorrowerCycleVariationData;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductData;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductGuaranteeData;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductInterestRecalculationData;
import org.apache.fineract.portfolio.paymenttype.data.PaymentTypeData;
import org.apache.fineract.portfolio.rate.data.RateData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoanProductDataMapperImpl
implements LoanProductDataMapper {
    private final AvroDateTimeMapper avroDateTimeMapper;
    private final AvroMonthDayMapper avroMonthDayMapper;

    @Autowired
    public LoanProductDataMapperImpl(AvroDateTimeMapper avroDateTimeMapper, AvroMonthDayMapper avroMonthDayMapper) {
        this.avroDateTimeMapper = avroDateTimeMapper;
        this.avroMonthDayMapper = avroMonthDayMapper;
    }

    public LoanProductDataV1 map(LoanProductData source) {
        if (source == null) {
            return null;
        }
        LoanProductDataV1 loanProductDataV1 = new LoanProductDataV1();
        loanProductDataV1.setId(source.getId());
        loanProductDataV1.setName(source.getName());
        loanProductDataV1.setShortName(source.getShortName());
        loanProductDataV1.setDescription(source.getDescription());
        loanProductDataV1.setFundId(source.getFundId());
        loanProductDataV1.setFundName(source.getFundName());
        loanProductDataV1.setIncludeInBorrowerCycle(Boolean.valueOf(source.isIncludeInBorrowerCycle()));
        loanProductDataV1.setUseBorrowerCycle(Boolean.valueOf(source.isUseBorrowerCycle()));
        loanProductDataV1.setStartDate(this.avroDateTimeMapper.mapLocalDate(source.getStartDate()));
        loanProductDataV1.setCloseDate(this.avroDateTimeMapper.mapLocalDate(source.getCloseDate()));
        loanProductDataV1.setStatus(source.getStatus());
        loanProductDataV1.setExternalId(source.getExternalId());
        loanProductDataV1.setCurrency(this.currencyDataToCurrencyDataV1(source.getCurrency()));
        loanProductDataV1.setPrincipal(source.getPrincipal());
        loanProductDataV1.setMinPrincipal(source.getMinPrincipal());
        loanProductDataV1.setMaxPrincipal(source.getMaxPrincipal());
        loanProductDataV1.setNumberOfRepayments(source.getNumberOfRepayments());
        loanProductDataV1.setMinNumberOfRepayments(source.getMinNumberOfRepayments());
        loanProductDataV1.setMaxNumberOfRepayments(source.getMaxNumberOfRepayments());
        loanProductDataV1.setRepaymentEvery(source.getRepaymentEvery());
        loanProductDataV1.setRepaymentFrequencyType(this.enumOptionDataToEnumOptionDataV1(source.getRepaymentFrequencyType()));
        loanProductDataV1.setInterestRatePerPeriod(source.getInterestRatePerPeriod());
        loanProductDataV1.setMinInterestRatePerPeriod(source.getMinInterestRatePerPeriod());
        loanProductDataV1.setMaxInterestRatePerPeriod(source.getMaxInterestRatePerPeriod());
        loanProductDataV1.setInterestRateFrequencyType(this.enumOptionDataToEnumOptionDataV1(source.getInterestRateFrequencyType()));
        loanProductDataV1.setAnnualInterestRate(source.getAnnualInterestRate());
        loanProductDataV1.setIsLinkedToFloatingInterestRates(Boolean.valueOf(source.isIsLinkedToFloatingInterestRates()));
        if (source.getFloatingRateId() != null) {
            loanProductDataV1.setFloatingRateId(Long.valueOf(source.getFloatingRateId().longValue()));
        }
        loanProductDataV1.setFloatingRateName(source.getFloatingRateName());
        loanProductDataV1.setInterestRateDifferential(source.getInterestRateDifferential());
        loanProductDataV1.setMinDifferentialLendingRate(source.getMinDifferentialLendingRate());
        loanProductDataV1.setDefaultDifferentialLendingRate(source.getDefaultDifferentialLendingRate());
        loanProductDataV1.setMaxDifferentialLendingRate(source.getMaxDifferentialLendingRate());
        loanProductDataV1.setIsFloatingInterestRateCalculationAllowed(Boolean.valueOf(source.isIsFloatingInterestRateCalculationAllowed()));
        loanProductDataV1.setAllowVariableInstallments(Boolean.valueOf(source.isAllowVariableInstallments()));
        loanProductDataV1.setMinimumGap(source.getMinimumGap());
        loanProductDataV1.setMaximumGap(source.getMaximumGap());
        loanProductDataV1.setAmortizationType(this.enumOptionDataToEnumOptionDataV1(source.getAmortizationType()));
        loanProductDataV1.setInterestType(this.enumOptionDataToEnumOptionDataV1(source.getInterestType()));
        loanProductDataV1.setInterestCalculationPeriodType(this.enumOptionDataToEnumOptionDataV1(source.getInterestCalculationPeriodType()));
        loanProductDataV1.setAllowPartialPeriodInterestCalculation(source.getAllowPartialPeriodInterestCalculation());
        loanProductDataV1.setInArrearsTolerance(source.getInArrearsTolerance());
        loanProductDataV1.setTransactionProcessingStrategyCode(source.getTransactionProcessingStrategyCode());
        loanProductDataV1.setTransactionProcessingStrategyName(source.getTransactionProcessingStrategyName());
        loanProductDataV1.setGraceOnPrincipalPayment(source.getGraceOnPrincipalPayment());
        loanProductDataV1.setRecurringMoratoriumOnPrincipalPeriods(source.getRecurringMoratoriumOnPrincipalPeriods());
        loanProductDataV1.setGraceOnInterestPayment(source.getGraceOnInterestPayment());
        loanProductDataV1.setGraceOnInterestCharged(source.getGraceOnInterestCharged());
        loanProductDataV1.setGraceOnArrearsAgeing(source.getGraceOnArrearsAgeing());
        loanProductDataV1.setOverdueDaysForNPA(source.getOverdueDaysForNPA());
        loanProductDataV1.setDaysInMonthType(this.enumOptionDataToEnumOptionDataV1(source.getDaysInMonthType()));
        loanProductDataV1.setDaysInYearType(this.enumOptionDataToEnumOptionDataV1(source.getDaysInYearType()));
        loanProductDataV1.setDaysInYearCustomStrategy(this.stringEnumOptionDataToStringEnumOptionDataV1(source.getDaysInYearCustomStrategy()));
        loanProductDataV1.setIsInterestRecalculationEnabled(Boolean.valueOf(source.isIsInterestRecalculationEnabled()));
        loanProductDataV1.setInterestRecalculationData(this.loanProductInterestRecalculationDataToLoanProductInterestRecalculationDataV1(source.getInterestRecalculationData()));
        loanProductDataV1.setMinimumDaysBetweenDisbursalAndFirstRepayment(source.getMinimumDaysBetweenDisbursalAndFirstRepayment());
        loanProductDataV1.setCanDefineInstallmentAmount(Boolean.valueOf(source.isCanDefineInstallmentAmount()));
        loanProductDataV1.setInstallmentAmountInMultiplesOf(source.getInstallmentAmountInMultiplesOf());
        loanProductDataV1.setCharges(this.chargeDataCollectionToChargeDataV1List(source.getCharges()));
        loanProductDataV1.setPrincipalVariationsForBorrowerCycle(this.loanProductBorrowerCycleVariationDataCollectionToLoanProductBorrowerCycleVariationDataV1List(source.getPrincipalVariationsForBorrowerCycle()));
        loanProductDataV1.setInterestRateVariationsForBorrowerCycle(this.loanProductBorrowerCycleVariationDataCollectionToLoanProductBorrowerCycleVariationDataV1List(source.getInterestRateVariationsForBorrowerCycle()));
        loanProductDataV1.setNumberOfRepaymentVariationsForBorrowerCycle(this.loanProductBorrowerCycleVariationDataCollectionToLoanProductBorrowerCycleVariationDataV1List(source.getNumberOfRepaymentVariationsForBorrowerCycle()));
        loanProductDataV1.setIsRatesEnabled(Boolean.valueOf(source.isIsRatesEnabled()));
        loanProductDataV1.setRates(this.rateDataCollectionToRateDataV1List(source.getRates()));
        loanProductDataV1.setMultiDisburseLoan(source.getMultiDisburseLoan());
        loanProductDataV1.setMaxTrancheCount(source.getMaxTrancheCount());
        loanProductDataV1.setOutstandingLoanBalance(source.getOutstandingLoanBalance());
        loanProductDataV1.setDisallowExpectedDisbursements(source.getDisallowExpectedDisbursements());
        loanProductDataV1.setAllowApprovedDisbursedAmountsOverApplied(source.getAllowApprovedDisbursedAmountsOverApplied());
        loanProductDataV1.setOverAppliedCalculationType(source.getOverAppliedCalculationType());
        loanProductDataV1.setOverAppliedNumber(source.getOverAppliedNumber());
        loanProductDataV1.setPrincipalThresholdForLastInstallment(source.getPrincipalThresholdForLastInstallment());
        loanProductDataV1.setHoldGuaranteeFunds(source.getHoldGuaranteeFunds());
        loanProductDataV1.setProductGuaranteeData(this.loanProductGuaranteeDataToLoanProductGuaranteeDataV1(source.getProductGuaranteeData()));
        loanProductDataV1.setAccountMovesOutOfNPAOnlyOnArrearsCompletion(source.getAccountMovesOutOfNPAOnlyOnArrearsCompletion());
        loanProductDataV1.setSyncExpectedWithDisbursementDate(Boolean.valueOf(source.isSyncExpectedWithDisbursementDate()));
        loanProductDataV1.setIsEqualAmortization(Boolean.valueOf(source.isIsEqualAmortization()));
        loanProductDataV1.setFixedPrincipalPercentagePerInstallment(source.getFixedPrincipalPercentagePerInstallment());
        loanProductDataV1.setDelinquencyBucket(this.delinquencyBucketDataToDelinquencyBucketDataV1(source.getDelinquencyBucket()));
        loanProductDataV1.setInterestRecognitionOnDisbursementDate(Boolean.valueOf(source.isInterestRecognitionOnDisbursementDate()));
        return loanProductDataV1;
    }

    protected CurrencyDataV1 currencyDataToCurrencyDataV1(CurrencyData currencyData) {
        if (currencyData == null) {
            return null;
        }
        CurrencyDataV1 currencyDataV1 = new CurrencyDataV1();
        currencyDataV1.setCode(currencyData.getCode());
        currencyDataV1.setName(currencyData.getName());
        currencyDataV1.setDecimalPlaces(Integer.valueOf(currencyData.getDecimalPlaces()));
        currencyDataV1.setInMultiplesOf(currencyData.getInMultiplesOf());
        currencyDataV1.setDisplaySymbol(currencyData.getDisplaySymbol());
        currencyDataV1.setNameCode(currencyData.getNameCode());
        currencyDataV1.setDisplayLabel(currencyData.getDisplayLabel());
        return currencyDataV1;
    }

    protected EnumOptionDataV1 enumOptionDataToEnumOptionDataV1(EnumOptionData enumOptionData) {
        if (enumOptionData == null) {
            return null;
        }
        EnumOptionDataV1 enumOptionDataV1 = new EnumOptionDataV1();
        if (enumOptionData.getId() != null) {
            enumOptionDataV1.setId(Integer.valueOf(((Long)enumOptionData.getId()).intValue()));
        }
        enumOptionDataV1.setCode(enumOptionData.getCode());
        enumOptionDataV1.setValue(enumOptionData.getValue());
        return enumOptionDataV1;
    }

    protected StringEnumOptionDataV1 stringEnumOptionDataToStringEnumOptionDataV1(StringEnumOptionData stringEnumOptionData) {
        if (stringEnumOptionData == null) {
            return null;
        }
        StringEnumOptionDataV1 stringEnumOptionDataV1 = new StringEnumOptionDataV1();
        stringEnumOptionDataV1.setId((String)stringEnumOptionData.getId());
        stringEnumOptionDataV1.setCode(stringEnumOptionData.getCode());
        stringEnumOptionDataV1.setValue(stringEnumOptionData.getValue());
        return stringEnumOptionDataV1;
    }

    protected LoanProductInterestRecalculationDataV1 loanProductInterestRecalculationDataToLoanProductInterestRecalculationDataV1(LoanProductInterestRecalculationData loanProductInterestRecalculationData) {
        if (loanProductInterestRecalculationData == null) {
            return null;
        }
        LoanProductInterestRecalculationDataV1 loanProductInterestRecalculationDataV1 = new LoanProductInterestRecalculationDataV1();
        loanProductInterestRecalculationDataV1.setId(loanProductInterestRecalculationData.getId());
        loanProductInterestRecalculationDataV1.setProductId(loanProductInterestRecalculationData.getProductId());
        loanProductInterestRecalculationDataV1.setInterestRecalculationCompoundingType(this.enumOptionDataToEnumOptionDataV1(loanProductInterestRecalculationData.getInterestRecalculationCompoundingType()));
        loanProductInterestRecalculationDataV1.setRescheduleStrategyType(this.enumOptionDataToEnumOptionDataV1(loanProductInterestRecalculationData.getRescheduleStrategyType()));
        loanProductInterestRecalculationDataV1.setRecalculationRestFrequencyType(this.enumOptionDataToEnumOptionDataV1(loanProductInterestRecalculationData.getRecalculationRestFrequencyType()));
        loanProductInterestRecalculationDataV1.setRecalculationRestFrequencyInterval(loanProductInterestRecalculationData.getRecalculationRestFrequencyInterval());
        loanProductInterestRecalculationDataV1.setRecalculationRestFrequencyNthDay(this.enumOptionDataToEnumOptionDataV1(loanProductInterestRecalculationData.getRecalculationRestFrequencyNthDay()));
        loanProductInterestRecalculationDataV1.setRecalculationRestFrequencyWeekday(this.enumOptionDataToEnumOptionDataV1(loanProductInterestRecalculationData.getRecalculationRestFrequencyWeekday()));
        loanProductInterestRecalculationDataV1.setRecalculationRestFrequencyOnDay(loanProductInterestRecalculationData.getRecalculationRestFrequencyOnDay());
        loanProductInterestRecalculationDataV1.setRecalculationCompoundingFrequencyType(this.enumOptionDataToEnumOptionDataV1(loanProductInterestRecalculationData.getRecalculationCompoundingFrequencyType()));
        loanProductInterestRecalculationDataV1.setRecalculationCompoundingFrequencyInterval(loanProductInterestRecalculationData.getRecalculationCompoundingFrequencyInterval());
        loanProductInterestRecalculationDataV1.setRecalculationCompoundingFrequencyNthDay(this.enumOptionDataToEnumOptionDataV1(loanProductInterestRecalculationData.getRecalculationCompoundingFrequencyNthDay()));
        loanProductInterestRecalculationDataV1.setRecalculationCompoundingFrequencyWeekday(this.enumOptionDataToEnumOptionDataV1(loanProductInterestRecalculationData.getRecalculationCompoundingFrequencyWeekday()));
        loanProductInterestRecalculationDataV1.setRecalculationCompoundingFrequencyOnDay(loanProductInterestRecalculationData.getRecalculationCompoundingFrequencyOnDay());
        loanProductInterestRecalculationDataV1.setIsArrearsBasedOnOriginalSchedule(Boolean.valueOf(loanProductInterestRecalculationData.isIsArrearsBasedOnOriginalSchedule()));
        loanProductInterestRecalculationDataV1.setIsCompoundingToBePostedAsTransaction(Boolean.valueOf(loanProductInterestRecalculationData.isIsCompoundingToBePostedAsTransaction()));
        loanProductInterestRecalculationDataV1.setPreClosureInterestCalculationStrategy(this.enumOptionDataToEnumOptionDataV1(loanProductInterestRecalculationData.getPreClosureInterestCalculationStrategy()));
        loanProductInterestRecalculationDataV1.setAllowCompoundingOnEod(Boolean.valueOf(loanProductInterestRecalculationData.isAllowCompoundingOnEod()));
        loanProductInterestRecalculationDataV1.setDisallowInterestCalculationOnPastDue(loanProductInterestRecalculationData.getDisallowInterestCalculationOnPastDue());
        return loanProductInterestRecalculationDataV1;
    }

    protected PaymentTypeDataV1 paymentTypeDataToPaymentTypeDataV1(PaymentTypeData paymentTypeData) {
        if (paymentTypeData == null) {
            return null;
        }
        PaymentTypeDataV1 paymentTypeDataV1 = new PaymentTypeDataV1();
        paymentTypeDataV1.setId(paymentTypeData.getId());
        paymentTypeDataV1.setName(paymentTypeData.getName());
        paymentTypeDataV1.setDescription(paymentTypeData.getDescription());
        paymentTypeDataV1.setIsCashPayment(paymentTypeData.getIsCashPayment());
        if (paymentTypeData.getPosition() != null) {
            paymentTypeDataV1.setPosition(Long.valueOf(paymentTypeData.getPosition().longValue()));
        }
        paymentTypeDataV1.setCodeName(paymentTypeData.getCodeName());
        paymentTypeDataV1.setIsSystemDefined(paymentTypeData.getIsSystemDefined());
        return paymentTypeDataV1;
    }

    protected CodeValueDataV1 codeValueDataToCodeValueDataV1(CodeValueData codeValueData) {
        if (codeValueData == null) {
            return null;
        }
        CodeValueDataV1 codeValueDataV1 = new CodeValueDataV1();
        codeValueDataV1.setId(codeValueData.getId());
        codeValueDataV1.setName(codeValueData.getName());
        codeValueDataV1.setPosition(codeValueData.getPosition());
        codeValueDataV1.setDescription(codeValueData.getDescription());
        codeValueDataV1.setActive(Boolean.valueOf(codeValueData.isActive()));
        codeValueDataV1.setMandatory(Boolean.valueOf(codeValueData.isMandatory()));
        return codeValueDataV1;
    }

    protected GLAccountDataV1 gLAccountDataToGLAccountDataV1(GLAccountData gLAccountData) {
        if (gLAccountData == null) {
            return null;
        }
        GLAccountDataV1 gLAccountDataV1 = new GLAccountDataV1();
        gLAccountDataV1.setId(gLAccountData.getId());
        gLAccountDataV1.setName(gLAccountData.getName());
        gLAccountDataV1.setParentId(gLAccountData.getParentId());
        gLAccountDataV1.setGlCode(gLAccountData.getGlCode());
        gLAccountDataV1.setDisabled(gLAccountData.getDisabled());
        gLAccountDataV1.setManualEntriesAllowed(gLAccountData.getManualEntriesAllowed());
        gLAccountDataV1.setType(this.enumOptionDataToEnumOptionDataV1(gLAccountData.getType()));
        gLAccountDataV1.setUsage(this.enumOptionDataToEnumOptionDataV1(gLAccountData.getUsage()));
        gLAccountDataV1.setDescription(gLAccountData.getDescription());
        gLAccountDataV1.setNameDecorated(gLAccountData.getNameDecorated());
        gLAccountDataV1.setTagId(this.codeValueDataToCodeValueDataV1(gLAccountData.getTagId()));
        gLAccountDataV1.setOrganizationRunningBalance(gLAccountData.getOrganizationRunningBalance());
        return gLAccountDataV1;
    }

    protected ChargeDataV1 chargeDataToChargeDataV1(ChargeData chargeData) {
        if (chargeData == null) {
            return null;
        }
        ChargeDataV1 chargeDataV1 = new ChargeDataV1();
        chargeDataV1.setId(chargeData.getId());
        chargeDataV1.setName(chargeData.getName());
        chargeDataV1.setActive(Boolean.valueOf(chargeData.isActive()));
        chargeDataV1.setPenalty(Boolean.valueOf(chargeData.isPenalty()));
        chargeDataV1.setFreeWithdrawal(Boolean.valueOf(chargeData.isFreeWithdrawal()));
        chargeDataV1.setFreeWithdrawalChargeFrequency(chargeData.getFreeWithdrawalChargeFrequency());
        chargeDataV1.setRestartFrequency(chargeData.getRestartFrequency());
        chargeDataV1.setRestartFrequencyEnum(chargeData.getRestartFrequencyEnum());
        chargeDataV1.setIsPaymentType(Boolean.valueOf(chargeData.isIsPaymentType()));
        chargeDataV1.setPaymentTypeOptions(this.paymentTypeDataToPaymentTypeDataV1(chargeData.getPaymentTypeOptions()));
        chargeDataV1.setCurrency(this.currencyDataToCurrencyDataV1(chargeData.getCurrency()));
        chargeDataV1.setAmount(chargeData.getAmount());
        chargeDataV1.setChargeTimeType(this.enumOptionDataToEnumOptionDataV1(chargeData.getChargeTimeType()));
        chargeDataV1.setChargeAppliesTo(this.enumOptionDataToEnumOptionDataV1(chargeData.getChargeAppliesTo()));
        chargeDataV1.setChargeCalculationType(this.enumOptionDataToEnumOptionDataV1(chargeData.getChargeCalculationType()));
        chargeDataV1.setChargePaymentMode(this.enumOptionDataToEnumOptionDataV1(chargeData.getChargePaymentMode()));
        chargeDataV1.setFeeOnMonthDay(this.avroMonthDayMapper.mapMonthDay(chargeData.getFeeOnMonthDay()));
        chargeDataV1.setFeeInterval(chargeData.getFeeInterval());
        chargeDataV1.setMinCap(chargeData.getMinCap());
        chargeDataV1.setMaxCap(chargeData.getMaxCap());
        chargeDataV1.setFeeFrequency(this.enumOptionDataToEnumOptionDataV1(chargeData.getFeeFrequency()));
        chargeDataV1.setIncomeOrLiabilityAccount(this.gLAccountDataToGLAccountDataV1(chargeData.getIncomeOrLiabilityAccount()));
        return chargeDataV1;
    }

    protected List<ChargeDataV1> chargeDataCollectionToChargeDataV1List(Collection<ChargeData> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<ChargeDataV1> list = new ArrayList<ChargeDataV1>(collection.size());
        for (ChargeData chargeData : collection) {
            list.add(this.chargeDataToChargeDataV1(chargeData));
        }
        return list;
    }

    protected LoanProductBorrowerCycleVariationDataV1 loanProductBorrowerCycleVariationDataToLoanProductBorrowerCycleVariationDataV1(LoanProductBorrowerCycleVariationData loanProductBorrowerCycleVariationData) {
        if (loanProductBorrowerCycleVariationData == null) {
            return null;
        }
        LoanProductBorrowerCycleVariationDataV1 loanProductBorrowerCycleVariationDataV1 = new LoanProductBorrowerCycleVariationDataV1();
        loanProductBorrowerCycleVariationDataV1.setId(loanProductBorrowerCycleVariationData.getId());
        loanProductBorrowerCycleVariationDataV1.setBorrowerCycleNumber(loanProductBorrowerCycleVariationData.getBorrowerCycleNumber());
        loanProductBorrowerCycleVariationDataV1.setParamType(this.enumOptionDataToEnumOptionDataV1(loanProductBorrowerCycleVariationData.getParamType()));
        loanProductBorrowerCycleVariationDataV1.setValueConditionType(this.enumOptionDataToEnumOptionDataV1(loanProductBorrowerCycleVariationData.getValueConditionType()));
        loanProductBorrowerCycleVariationDataV1.setMinValue(loanProductBorrowerCycleVariationData.getMinValue());
        loanProductBorrowerCycleVariationDataV1.setMaxValue(loanProductBorrowerCycleVariationData.getMaxValue());
        loanProductBorrowerCycleVariationDataV1.setDefaultValue(loanProductBorrowerCycleVariationData.getDefaultValue());
        return loanProductBorrowerCycleVariationDataV1;
    }

    protected List<LoanProductBorrowerCycleVariationDataV1> loanProductBorrowerCycleVariationDataCollectionToLoanProductBorrowerCycleVariationDataV1List(Collection<LoanProductBorrowerCycleVariationData> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<LoanProductBorrowerCycleVariationDataV1> list = new ArrayList<LoanProductBorrowerCycleVariationDataV1>(collection.size());
        for (LoanProductBorrowerCycleVariationData loanProductBorrowerCycleVariationData : collection) {
            list.add(this.loanProductBorrowerCycleVariationDataToLoanProductBorrowerCycleVariationDataV1(loanProductBorrowerCycleVariationData));
        }
        return list;
    }

    protected RateDataV1 rateDataToRateDataV1(RateData rateData) {
        if (rateData == null) {
            return null;
        }
        RateDataV1 rateDataV1 = new RateDataV1();
        rateDataV1.setId(rateData.getId());
        rateDataV1.setName(rateData.getName());
        rateDataV1.setPercentage(rateData.getPercentage());
        rateDataV1.setProductApply(this.enumOptionDataToEnumOptionDataV1(rateData.getProductApply()));
        rateDataV1.setActive(Boolean.valueOf(rateData.isActive()));
        return rateDataV1;
    }

    protected List<RateDataV1> rateDataCollectionToRateDataV1List(Collection<RateData> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<RateDataV1> list = new ArrayList<RateDataV1>(collection.size());
        for (RateData rateData : collection) {
            list.add(this.rateDataToRateDataV1(rateData));
        }
        return list;
    }

    protected LoanProductGuaranteeDataV1 loanProductGuaranteeDataToLoanProductGuaranteeDataV1(LoanProductGuaranteeData loanProductGuaranteeData) {
        if (loanProductGuaranteeData == null) {
            return null;
        }
        LoanProductGuaranteeDataV1 loanProductGuaranteeDataV1 = new LoanProductGuaranteeDataV1();
        loanProductGuaranteeDataV1.setId(loanProductGuaranteeData.getId());
        loanProductGuaranteeDataV1.setProductId(loanProductGuaranteeData.getProductId());
        loanProductGuaranteeDataV1.setMandatoryGuarantee(loanProductGuaranteeData.getMandatoryGuarantee());
        loanProductGuaranteeDataV1.setMinimumGuaranteeFromOwnFunds(loanProductGuaranteeData.getMinimumGuaranteeFromOwnFunds());
        loanProductGuaranteeDataV1.setMinimumGuaranteeFromGuarantor(loanProductGuaranteeData.getMinimumGuaranteeFromGuarantor());
        return loanProductGuaranteeDataV1;
    }

    protected DelinquencyRangeDataV1 delinquencyRangeDataToDelinquencyRangeDataV1(DelinquencyRangeData delinquencyRangeData) {
        if (delinquencyRangeData == null) {
            return null;
        }
        DelinquencyRangeDataV1 delinquencyRangeDataV1 = new DelinquencyRangeDataV1();
        delinquencyRangeDataV1.setId(delinquencyRangeData.getId());
        delinquencyRangeDataV1.setClassification(delinquencyRangeData.getClassification());
        delinquencyRangeDataV1.setMinimumAgeDays(delinquencyRangeData.getMinimumAgeDays());
        delinquencyRangeDataV1.setMaximumAgeDays(delinquencyRangeData.getMaximumAgeDays());
        return delinquencyRangeDataV1;
    }

    protected List<DelinquencyRangeDataV1> delinquencyRangeDataListToDelinquencyRangeDataV1List(List<DelinquencyRangeData> list) {
        if (list == null) {
            return null;
        }
        ArrayList<DelinquencyRangeDataV1> list1 = new ArrayList<DelinquencyRangeDataV1>(list.size());
        for (DelinquencyRangeData delinquencyRangeData : list) {
            list1.add(this.delinquencyRangeDataToDelinquencyRangeDataV1(delinquencyRangeData));
        }
        return list1;
    }

    protected DelinquencyBucketDataV1 delinquencyBucketDataToDelinquencyBucketDataV1(DelinquencyBucketData delinquencyBucketData) {
        if (delinquencyBucketData == null) {
            return null;
        }
        DelinquencyBucketDataV1 delinquencyBucketDataV1 = new DelinquencyBucketDataV1();
        delinquencyBucketDataV1.setId(delinquencyBucketData.getId());
        delinquencyBucketDataV1.setName(delinquencyBucketData.getName());
        delinquencyBucketDataV1.setRanges(this.delinquencyRangeDataListToDelinquencyRangeDataV1List(delinquencyBucketData.getRanges()));
        return delinquencyBucketDataV1;
    }
}

