/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.hooks.processor;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.apache.fineract.infrastructure.hooks.processor.WebHookService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Service
public final class ProcessorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorHelper.class);
    private static final X509TrustManager insecureX509TrustManager = new /* Unavailable Anonymous Inner Class!! */;
    private final boolean insecureHttpClient = Boolean.getBoolean("fineract.insecureHttpClient");
    private final SSLContext insecureSSLContext = this.insecureHttpClient ? this.createInsecureSSLContext() : null;

    private OkHttpClient createClient() {
        OkHttpClient.Builder okBuilder = new OkHttpClient.Builder();
        if (this.insecureHttpClient) {
            this.configureInsecureClient(okBuilder);
        }
        return okBuilder.build();
    }

    private void configureInsecureClient(OkHttpClient.Builder okBuilder) {
        okBuilder.sslSocketFactory(this.insecureSSLContext.getSocketFactory(), insecureX509TrustManager);
        HostnameVerifier insecureHostnameVerifier = (hostname, session) -> true;
        okBuilder.hostnameVerifier(insecureHostnameVerifier);
    }

    private SSLContext createInsecureSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext insecureSSLContext = SSLContext.getInstance("TLS");
        insecureSSLContext.init(null, new TrustManager[]{insecureX509TrustManager}, new SecureRandom());
        return insecureSSLContext;
    }

    public Callback createCallback(String url) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public WebHookService createWebHookService(String url) {
        OkHttpClient client = this.createClient();
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder();
        retrofitBuilder.baseUrl(url);
        retrofitBuilder.client(client);
        retrofitBuilder.addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        Retrofit retrofit = retrofitBuilder.build();
        return (WebHookService)retrofit.create(WebHookService.class);
    }

    public Callback createCallback(String url, String payload) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

