/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.domain;

import com.google.gson.Gson;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.jobs.data.JobParameterDTO;
import org.apache.fineract.infrastructure.jobs.domain.CustomJobParameter;
import org.apache.fineract.infrastructure.jobs.domain.CustomJobParameterRepository;
import org.apache.fineract.infrastructure.jobs.domain.CustomJobParameterRepositoryImpl;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class CustomJobParameterRepositoryImpl
implements CustomJobParameterRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final DatabaseSpecificSQLGenerator databaseSpecificSQLGenerator;
    private final Gson gson = GoogleGsonSerializerHelper.createSimpleGson();

    public Long save(Set<JobParameterDTO> customJobParameters) {
        Objects.requireNonNull(customJobParameters);
        String insertSQL = "INSERT INTO batch_custom_job_parameters (parameter_json) VALUES (%s)".formatted(this.databaseSpecificSQLGenerator.castJson(":jsonString"));
        String jsonString = this.gson.toJson(customJobParameters);
        MapSqlParameterSource parameters = new MapSqlParameterSource("jsonString", (Object)jsonString);
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.namedParameterJdbcTemplate.update(insertSQL, (SqlParameterSource)parameters, (KeyHolder)keyHolder);
        return this.databaseSpecificSQLGenerator.fetchPK(keyHolder);
    }

    public Optional<CustomJobParameter> findById(Long id) {
        Objects.requireNonNull(id);
        CustomJobParameterExtractor customJobParameterExtractor = new CustomJobParameterExtractor();
        MapSqlParameterSource parameters = new MapSqlParameterSource("id", (Object)id);
        return Optional.ofNullable((CustomJobParameter)this.namedParameterJdbcTemplate.query("SELECT cjp.parameter_json AS parameter_json FROM batch_custom_job_parameters cjp WHERE cjp.id = :id", (SqlParameterSource)parameters, (ResultSetExtractor)customJobParameterExtractor));
    }

    @Generated
    public CustomJobParameterRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate, DatabaseSpecificSQLGenerator databaseSpecificSQLGenerator) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.databaseSpecificSQLGenerator = databaseSpecificSQLGenerator;
    }
}

