/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service;

import lombok.Generated;
import org.apache.fineract.commands.annotation.CommandType;
import org.apache.fineract.commands.handler.NewCommandSourceHandler;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.exception.JobIsNotFoundOrNotEnabledException;
import org.apache.fineract.infrastructure.jobs.service.InlineExecutorService;
import org.apache.fineract.infrastructure.jobs.service.InlineJobType;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
@CommandType(entity="INLINE_JOB", action="EXECUTE")
public class InlineJobExecuteHandler
implements NewCommandSourceHandler {
    private final ApplicationContext applicationContext;

    public CommandProcessingResult processCommand(JsonCommand command) {
        InlineJobType inlineJobType = InlineJobType.getInlineJobType((String)command.getJobName());
        try {
            InlineExecutorService inlineJobExecutorService = (InlineExecutorService)this.applicationContext.getBean(inlineJobType.getExecutorServiceClass());
            return inlineJobExecutorService.executeInlineJob(command, inlineJobType.getInlineJobName());
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new JobIsNotFoundOrNotEnabledException((Exception)((Object)e), inlineJobType.getInlineJobName());
        }
    }

    @Generated
    public InlineJobExecuteHandler(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

