/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.s3;

import java.util.List;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.dataqueries.service.ReadReportingService;
import org.apache.fineract.infrastructure.dataqueries.service.export.S3DatatableReportExportServiceImpl;
import org.apache.fineract.infrastructure.s3.AmazonS3ConfigCondition;
import org.apache.fineract.infrastructure.s3.S3ClientCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

@Configuration
@Conditional(value={AmazonS3ConfigCondition.class})
public class AmazonS3Config {
    @Bean
    public DefaultCredentialsProvider awsCredentialsProvider() {
        return DefaultCredentialsProvider.create();
    }

    @Bean
    public AwsRegionProvider awsRegionProvider() {
        return DefaultAwsRegionProviderChain.builder().build();
    }

    @Bean(value={"s3Client"})
    public S3Client s3Client(DefaultCredentialsProvider awsCredentialsProvider, AwsRegionProvider awsRegionProvider, List<S3ClientCustomizer> customizers) {
        S3ClientBuilder builder = (S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)awsCredentialsProvider)).region(awsRegionProvider.getRegion());
        customizers.forEach(customizer -> customizer.customize(builder));
        return (S3Client)builder.build();
    }

    @Bean
    @ConditionalOnBean(value={S3Client.class})
    public S3DatatableReportExportServiceImpl s3DatatableReportExportServiceImpl(ReadReportingService reportServiceImpl, ConfigurationDomainService configurationDomainService, S3Client s3Client, FineractProperties fineractProperties) {
        return new S3DatatableReportExportServiceImpl(reportServiceImpl, configurationDomainService, s3Client, fineractProperties);
    }
}

