/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDateTime;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.data.AccessTokenData;
import org.apache.fineract.useradministration.domain.AppUser;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="twofactor_access_token", uniqueConstraints={@UniqueConstraint(columnNames={"token", "appuser_id"}, name="token_appuser_UNIQUE")})
public class TFAccessToken
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="token", nullable=false, length=32)
    private String token;
    @ManyToOne
    @JoinColumn(name="appuser_id", nullable=false)
    private AppUser user;
    @Column(name="valid_from", nullable=false)
    private LocalDateTime validFrom;
    @Column(name="valid_to", nullable=false)
    private LocalDateTime validTo;
    @Column(name="enabled", nullable=false)
    private boolean enabled;
    static final long serialVersionUID = 8904626241624169974L;

    public static TFAccessToken create(String token, AppUser user, int tokenLiveTimeInSec) {
        LocalDateTime validFrom = DateUtils.getLocalDateTimeOfTenant();
        LocalDateTime validTo = validFrom.plusSeconds(tokenLiveTimeInSec);
        return new TFAccessToken().setToken(token).setUser(user).setValidFrom(validFrom).setValidTo(validTo).setEnabled(true);
    }

    public boolean isValid() {
        return this._persistence_get_enabled() && !DateUtils.isAfterTenantDateTime((LocalDateTime)this.getValidFrom()) && DateUtils.isAfterTenantDateTime((LocalDateTime)this.getValidTo());
    }

    public AccessTokenData toTokenData() {
        return new AccessTokenData().setToken(this._persistence_get_token()).setValidFrom(this.getValidFrom().atZone(DateUtils.getDateTimeZoneOfTenant())).setValidTo(this.getValidTo().atZone(DateUtils.getDateTimeZoneOfTenant()));
    }

    @Generated
    public String getToken() {
        return this._persistence_get_token();
    }

    @Generated
    public AppUser getUser() {
        return this._persistence_get_user();
    }

    @Generated
    public LocalDateTime getValidFrom() {
        return this._persistence_get_validFrom();
    }

    @Generated
    public LocalDateTime getValidTo() {
        return this._persistence_get_validTo();
    }

    @Generated
    public boolean isEnabled() {
        return this._persistence_get_enabled();
    }

    @Generated
    public TFAccessToken setToken(String token) {
        this._persistence_set_token(token);
        return this;
    }

    @Generated
    public TFAccessToken setUser(AppUser user) {
        this._persistence_set_user(user);
        return this;
    }

    @Generated
    public TFAccessToken setValidFrom(LocalDateTime validFrom) {
        this._persistence_set_validFrom(validFrom);
        return this;
    }

    @Generated
    public TFAccessToken setValidTo(LocalDateTime validTo) {
        this._persistence_set_validTo(validTo);
        return this;
    }

    @Generated
    public TFAccessToken setEnabled(boolean enabled) {
        this._persistence_set_enabled(enabled);
        return this;
    }

    @Generated
    public TFAccessToken() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TFAccessToken(persistenceObject);
    }

    public TFAccessToken(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "validFrom") {
            return this.validFrom;
        }
        if (string == "user") {
            return this.user;
        }
        if (string == "enabled") {
            return this.enabled;
        }
        if (string == "token") {
            return this.token;
        }
        if (string == "validTo") {
            return this.validTo;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "validFrom") {
            this.validFrom = (LocalDateTime)object;
            return;
        }
        if (string == "user") {
            this.user = (AppUser)object;
            return;
        }
        if (string == "enabled") {
            this.enabled = (Boolean)object;
            return;
        }
        if (string == "token") {
            this.token = (String)object;
            return;
        }
        if (string == "validTo") {
            this.validTo = (LocalDateTime)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public LocalDateTime _persistence_get_validFrom() {
        this._persistence_checkFetched("validFrom");
        return this.validFrom;
    }

    public void _persistence_set_validFrom(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("validFrom");
        this._persistence_propertyChange("validFrom", (Object)this.validFrom, (Object)localDateTime);
        this.validFrom = localDateTime;
    }

    public AppUser _persistence_get_user() {
        this._persistence_checkFetched("user");
        return this.user;
    }

    public void _persistence_set_user(AppUser appUser) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_propertyChange("user", (Object)this.user, (Object)appUser);
        this.user = appUser;
    }

    public boolean _persistence_get_enabled() {
        this._persistence_checkFetched("enabled");
        return this.enabled;
    }

    public void _persistence_set_enabled(boolean bl) {
        this._persistence_checkFetchedForSet("enabled");
        this._persistence_propertyChange("enabled", (Object)new Boolean(this.enabled), (Object)new Boolean(bl));
        this.enabled = bl;
    }

    public String _persistence_get_token() {
        this._persistence_checkFetched("token");
        return this.token;
    }

    public void _persistence_set_token(String string) {
        this._persistence_checkFetchedForSet("token");
        this._persistence_propertyChange("token", (Object)this.token, (Object)string);
        this.token = string;
    }

    public LocalDateTime _persistence_get_validTo() {
        this._persistence_checkFetched("validTo");
        return this.validTo;
    }

    public void _persistence_set_validTo(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("validTo");
        this._persistence_propertyChange("validTo", (Object)this.validTo, (Object)localDateTime);
        this.validTo = localDateTime;
    }
}

