/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.exception.NoAuthorizationException;
import org.apache.fineract.infrastructure.security.exception.ResetPasswordException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.exception.UnAuthenticatedUserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class SpringSecurityPlatformSecurityContext
implements PlatformSecurityContext {
    private final ConfigurationDomainService configurationDomainService;
    protected static final List<CommandWrapper> EXEMPT_FROM_PASSWORD_RESET_CHECK = new ArrayList<CommandWrapper>(List.of(new CommandWrapperBuilder().updateUser(null).build()));

    @Autowired
    SpringSecurityPlatformSecurityContext(ConfigurationDomainService configurationDomainService) {
        this.configurationDomainService = configurationDomainService;
    }

    public AppUser authenticatedUser() {
        Object principal;
        Authentication auth;
        AppUser currentUser = null;
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && (auth = context.getAuthentication()) != null && (principal = auth.getPrincipal()) instanceof AppUser) {
            AppUser appUser;
            currentUser = appUser = (AppUser)principal;
        }
        if (currentUser == null) {
            throw new UnAuthenticatedUserException();
        }
        if (this.doesPasswordHasToBeRenewed(currentUser)) {
            throw new ResetPasswordException((Long)currentUser.getId());
        }
        return currentUser;
    }

    public void isAuthenticated() {
        this.authenticatedUser();
    }

    public AppUser getAuthenticatedUserIfPresent() {
        Authentication auth;
        AppUser currentUser = null;
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && (auth = context.getAuthentication()) != null) {
            currentUser = (AppUser)auth.getPrincipal();
        }
        if (currentUser == null) {
            return null;
        }
        if (this.doesPasswordHasToBeRenewed(currentUser)) {
            throw new ResetPasswordException((Long)currentUser.getId());
        }
        return currentUser;
    }

    public AppUser authenticatedUser(CommandWrapper commandWrapper) {
        Authentication auth;
        AppUser currentUser = null;
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && (auth = context.getAuthentication()) != null) {
            currentUser = (AppUser)auth.getPrincipal();
        }
        if (currentUser == null) {
            throw new UnAuthenticatedUserException();
        }
        if (this.shouldCheckForPasswordForceReset(commandWrapper) && this.doesPasswordHasToBeRenewed(currentUser)) {
            throw new ResetPasswordException((Long)currentUser.getId());
        }
        return currentUser;
    }

    public void validateAccessRights(String resourceOfficeHierarchy) {
        AppUser user = this.authenticatedUser();
        String userOfficeHierarchy = user.getOffice().getHierarchy();
        if (!resourceOfficeHierarchy.startsWith(userOfficeHierarchy)) {
            throw new NoAuthorizationException("The user doesn't have enough permissions to access the resource.");
        }
    }

    public String officeHierarchy() {
        return this.authenticatedUser().getOffice().getHierarchy();
    }

    public boolean doesPasswordHasToBeRenewed(AppUser currentUser) {
        if (this.configurationDomainService.isPasswordForcedResetEnable() && !currentUser.getPasswordNeverExpires()) {
            Long passwordDurationDays = this.configurationDomainService.retrievePasswordLiveTime();
            LocalDate passWordLastUpdateDate = currentUser.getLastTimePasswordUpdated();
            LocalDate passwordExpirationDate = passWordLastUpdateDate.plusDays(passwordDurationDays);
            if (DateUtils.isBeforeTenantDate((LocalDate)passwordExpirationDate)) {
                return true;
            }
        }
        return false;
    }

    private boolean shouldCheckForPasswordForceReset(CommandWrapper commandWrapper) {
        for (CommandWrapper commandItem : EXEMPT_FROM_PASSWORD_RESET_CHECK) {
            if (!commandItem.actionName().equals(commandWrapper.actionName()) || !commandItem.getEntityName().equals(commandWrapper.getEntityName())) continue;
            return false;
        }
        return true;
    }
}

