/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.sms.data;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class SmsDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private static final Set<String> CREATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "groupId", "clientId", "staffId", "message", "campaignId"));
    public static final Set<String> UPDATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("message", "campaignId"));

    @Autowired
    public SmsDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)CREATE_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("sms");
        if (this.fromApiJsonHelper.parameterExists("groupId", element)) {
            Long groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element);
            baseDataValidator.reset().parameter("groupId").value((Object)groupId).notNull().integerGreaterThanZero();
            if (this.fromApiJsonHelper.parameterExists("clientId", element)) {
                baseDataValidator.reset().parameter("clientId").failWithCode("cannot.be.passed.with.groupId", new Object[0]);
            }
            if (this.fromApiJsonHelper.parameterExists("staffId", element)) {
                baseDataValidator.reset().parameter("staffId").failWithCode("cannot.be.passed.with.groupId", new Object[0]);
            }
        } else if (this.fromApiJsonHelper.parameterExists("clientId", element)) {
            Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
            baseDataValidator.reset().parameter("clientId").value((Object)clientId).notNull().integerGreaterThanZero();
            if (this.fromApiJsonHelper.parameterExists("groupId", element)) {
                baseDataValidator.reset().parameter("groupId").failWithCode("cannot.be.passed.with.clientId", new Object[0]);
            }
            if (this.fromApiJsonHelper.parameterExists("staffId", element)) {
                baseDataValidator.reset().parameter("staffId").failWithCode("cannot.be.passed.with.clientId", new Object[0]);
            }
        } else if (this.fromApiJsonHelper.parameterExists("staffId", element)) {
            Long staffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
            baseDataValidator.reset().parameter("staffId").value((Object)staffId).ignoreIfNull().longGreaterThanZero();
            if (this.fromApiJsonHelper.parameterExists("groupId", element)) {
                baseDataValidator.reset().parameter("groupId").failWithCode("cannot.be.passed.with.staffId", new Object[0]);
            }
            if (this.fromApiJsonHelper.parameterExists("clientId", element)) {
                baseDataValidator.reset().parameter("clientId").failWithCode("cannot.be.passed.with.staffId", new Object[0]);
            }
        }
        if (!(this.fromApiJsonHelper.parameterExists("groupId", element) || this.fromApiJsonHelper.parameterExists("clientId", element) || this.fromApiJsonHelper.parameterExists("staffId", element))) {
            baseDataValidator.reset().parameter("staffId").failWithCodeNoParameterAddedToErrorCode("no.entity.provided", new Object[0]);
        }
        String message = this.fromApiJsonHelper.extractStringNamed("message", element);
        baseDataValidator.reset().parameter("message").value((Object)message).notBlank().notExceedingLengthOf(Integer.valueOf(1000));
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)UPDATE_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("sms");
        if (this.fromApiJsonHelper.parameterExists("message", element)) {
            String message = this.fromApiJsonHelper.extractStringNamed("message", element);
            baseDataValidator.reset().parameter("message").value((Object)message).notBlank().notExceedingLengthOf(Integer.valueOf(1000));
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

