/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.data;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.interoperation.data.ExtensionData;
import org.apache.fineract.interoperation.data.GeoCodeData;
import org.apache.fineract.interoperation.data.InteropTransactionTypeData;
import org.apache.fineract.interoperation.data.MoneyData;
import org.apache.fineract.interoperation.domain.InteropTransactionRole;
import org.apache.fineract.interoperation.util.InteropUtil;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;

public class InteropRequestData {
    @NotNull
    private final String transactionCode;
    private final String requestCode;
    @NotNull
    private final String accountId;
    @NotNull
    private final MoneyData amount;
    @NotNull
    private final InteropTransactionRole transactionRole;
    private final InteropTransactionTypeData transactionType;
    private String note;
    private GeoCodeData geoCode;
    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    private LocalDateTime expiration;
    private List<ExtensionData> extensionList;

    protected InteropRequestData(@NotNull String transactionCode, String requestCode, @NotNull String accountId, @NotNull MoneyData amount, @NotNull InteropTransactionRole transactionRole, InteropTransactionTypeData transactionType, String note, GeoCodeData geoCode, LocalDateTime expiration, List<ExtensionData> extensionList) {
        this.transactionCode = transactionCode;
        this.requestCode = requestCode;
        this.accountId = accountId;
        this.amount = amount;
        this.transactionType = transactionType;
        this.transactionRole = transactionRole;
        this.note = note;
        this.geoCode = geoCode;
        this.expiration = expiration;
        this.extensionList = extensionList;
    }

    protected InteropRequestData(@NotNull String transactionCode, @NotNull String accountId, @NotNull MoneyData amount, @NotNull InteropTransactionRole transactionRole) {
        this(transactionCode, null, accountId, amount, transactionRole, null, null, null, null, null);
    }

    @NotNull
    public String getTransactionCode() {
        return this.transactionCode;
    }

    public String getRequestCode() {
        return this.requestCode;
    }

    @NotNull
    public String getAccountId() {
        return this.accountId;
    }

    @NotNull
    public MoneyData getAmount() {
        return this.amount;
    }

    public InteropTransactionTypeData getTransactionType() {
        return this.transactionType;
    }

    @NotNull
    public InteropTransactionRole getTransactionRole() {
        return this.transactionRole;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public GeoCodeData getGeoCode() {
        return this.geoCode;
    }

    public void setGeoCode(GeoCodeData geoCode) {
        this.geoCode = geoCode;
    }

    public LocalDateTime getExpiration() {
        return this.expiration;
    }

    public LocalDate getExpirationLocalDate() {
        return this.expiration == null ? null : this.expiration.toLocalDate();
    }

    public void setExpiration(LocalDateTime expiration) {
        this.expiration = expiration;
    }

    public List<ExtensionData> getExtensionList() {
        return this.extensionList;
    }

    public void setExtensionList(List<ExtensionData> extensionList) {
        this.extensionList = extensionList;
    }

    public void normalizeAmounts(@NotNull MonetaryCurrency currency) {
        this.amount.normalizeAmount(currency);
    }

    public static InteropRequestData validateAndParse(DataValidatorBuilder dataValidator, JsonObject element, FromJsonHelper jsonHelper) {
        if (element == null) {
            return null;
        }
        String transactionCode = jsonHelper.extractStringNamed("transactionCode", (JsonElement)element);
        DataValidatorBuilder dataValidatorCopy = dataValidator.reset().parameter("transactionCode").value((Object)transactionCode).notBlank();
        String requestCode = jsonHelper.extractStringNamed("requestCode", (JsonElement)element);
        String accountId = jsonHelper.extractStringNamed("accountId", (JsonElement)element);
        dataValidatorCopy = dataValidatorCopy.reset().parameter("accountId").value((Object)accountId).notBlank();
        JsonObject moneyElement = jsonHelper.extractJsonObjectNamed("amount", (JsonElement)element);
        dataValidatorCopy = dataValidatorCopy.reset().parameter("amount").value((Object)moneyElement).notNull();
        dataValidator.merge(dataValidatorCopy);
        MoneyData amount = MoneyData.validateAndParse((DataValidatorBuilder)dataValidator, (JsonObject)moneyElement, (FromJsonHelper)jsonHelper);
        JsonObject transactionTypeElement = jsonHelper.extractJsonObjectNamed("transactionType", (JsonElement)element);
        InteropTransactionTypeData transactionType = InteropTransactionTypeData.validateAndParse((DataValidatorBuilder)dataValidator, (JsonObject)transactionTypeElement, (FromJsonHelper)jsonHelper);
        String transactionRoleString = jsonHelper.extractStringNamed("transactionRole", (JsonElement)element);
        InteropTransactionRole transactionRole = transactionRoleString == null ? InteropTransactionRole.PAYER : InteropTransactionRole.valueOf((String)transactionRoleString);
        String note = jsonHelper.extractStringNamed("note", (JsonElement)element);
        JsonObject geoCodeElement = jsonHelper.extractJsonObjectNamed("geoCode", (JsonElement)element);
        GeoCodeData geoCode = GeoCodeData.validateAndParse((DataValidatorBuilder)dataValidator, (JsonObject)geoCodeElement, (FromJsonHelper)jsonHelper);
        String locale = jsonHelper.extractStringNamed("locale", (JsonElement)element);
        LocalDateTime expiration = locale == null ? jsonHelper.extractLocalDateTimeNamed("expiration", (JsonElement)element, "yyyy-MM-dd'T'HH:mm:ss.SSS[-HH:MM]", InteropUtil.DEFAULT_LOCALE) : jsonHelper.extractLocalDateTimeNamed("expiration", (JsonElement)element);
        JsonArray extensionArray = jsonHelper.extractJsonArrayNamed("extensionList", (JsonElement)element);
        ArrayList<ExtensionData> extensionList = null;
        if (extensionArray != null) {
            extensionList = new ArrayList<ExtensionData>(extensionArray.size());
            for (JsonElement jsonElement : extensionArray) {
                if (!jsonElement.isJsonObject()) continue;
                extensionList.add(ExtensionData.validateAndParse((DataValidatorBuilder)dataValidator, (JsonObject)jsonElement.getAsJsonObject(), (FromJsonHelper)jsonHelper));
            }
        }
        return dataValidator.hasError() ? null : new InteropRequestData(transactionCode, requestCode, accountId, amount, transactionRole, transactionType, note, geoCode, expiration, extensionList);
    }
}

