/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.data;

import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.interoperation.data.InteropTransactionData;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;

public class InteropTransactionsData
extends CommandProcessingResult {
    List<InteropTransactionData> transactions;

    public InteropTransactionsData(Long entityId, List<InteropTransactionData> transactions) {
        super(entityId);
        this.transactions = transactions;
    }

    public static InteropTransactionsData build(SavingsAccount account, @NotNull Predicate<SavingsAccountTransaction> filter) {
        if (account == null) {
            return null;
        }
        List trans = account.getTransactions().stream().filter(filter).sorted((t1, t2) -> {
            int i = DateUtils.compare((LocalDate)t2.getDateOf(), (LocalDate)t1.getDateOf());
            return i != 0 ? i : Long.signum((Long)t2.getId() - (Long)t1.getId());
        }).map(InteropTransactionData::build).collect(Collectors.toList());
        return new InteropTransactionsData((Long)account.getId(), trans);
    }

    @Generated
    public List<InteropTransactionData> getTransactions() {
        return this.transactions;
    }

    @Generated
    public void setTransactions(List<InteropTransactionData> transactions) {
        this.transactions = transactions;
    }
}

