/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.jobs.executestandinginstructions;

import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.jobs.service.JobName;
import org.apache.fineract.portfolio.account.jobs.executestandinginstructions.ExecuteStandingInstructionsTasklet;
import org.apache.fineract.portfolio.account.service.AccountTransfersWritePlatformService;
import org.apache.fineract.portfolio.account.service.StandingInstructionReadPlatformService;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class ExecuteStandingInstructionsConfig {
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private StandingInstructionReadPlatformService standingInstructionReadPlatformService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private DatabaseSpecificSQLGenerator sqlGenerator;
    @Autowired
    private AccountTransfersWritePlatformService accountTransfersWritePlatformService;

    @Bean
    protected Step executeStandingInstructionsStep() {
        return new StepBuilder(JobName.EXECUTE_STANDING_INSTRUCTIONS.name(), this.jobRepository).tasklet((Tasklet)this.executeStandingInstructionsTasklet(), this.transactionManager).build();
    }

    @Bean
    public Job executeStandingInstructionsJob() {
        return ((SimpleJobBuilder)new JobBuilder(JobName.EXECUTE_STANDING_INSTRUCTIONS.name(), this.jobRepository).start(this.executeStandingInstructionsStep()).incrementer((JobParametersIncrementer)new RunIdIncrementer())).build();
    }

    @Bean
    public ExecuteStandingInstructionsTasklet executeStandingInstructionsTasklet() {
        return new ExecuteStandingInstructionsTasklet(this.standingInstructionReadPlatformService, this.jdbcTemplate, this.sqlGenerator, this.accountTransfersWritePlatformService);
    }
}

