/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.client.data.ClientTransactionData;

public final class ClientChargeData {
    private final Long id;
    private final Long clientId;
    private final Long chargeId;
    private final String name;
    private final EnumOptionData chargeTimeType;
    private final LocalDate dueDate;
    private final EnumOptionData chargeCalculationType;
    private final CurrencyData currency;
    private final BigDecimal amount;
    private final BigDecimal amountPaid;
    private final BigDecimal amountWaived;
    private final BigDecimal amountWrittenOff;
    private final BigDecimal amountOutstanding;
    private final boolean penalty;
    private final Boolean isActive;
    private final Boolean isPaid;
    private final Boolean isWaived;
    private final LocalDate inactivationDate;
    private final Collection<ChargeData> chargeOptions;
    private final Collection<ClientTransactionData> clientTransactionDatas;

    public static ClientChargeData instance(Long id, Long clientId, Long chargeId, String name, EnumOptionData chargeTimeType, LocalDate dueDate, EnumOptionData chargeCalculationType, CurrencyData currency, BigDecimal amount, BigDecimal amountPaid, BigDecimal amountWaived, BigDecimal amountWrittenOff, BigDecimal amountOutstanding, boolean penalty, Boolean isPaid, Boolean isWaived, Boolean isActive, LocalDate inactivationDate, Collection<ChargeData> chargeOptions) {
        Collection clientTransactionDatas = null;
        return new ClientChargeData(id, clientId, chargeId, name, chargeTimeType, dueDate, chargeCalculationType, currency, amount, amountPaid, amountWaived, amountWrittenOff, amountOutstanding, penalty, isPaid, isWaived, isActive, inactivationDate, chargeOptions, clientTransactionDatas);
    }

    public static ClientChargeData addAssociations(ClientChargeData clientChargeData, Collection<ClientTransactionData> clientTransactionDatas) {
        return new ClientChargeData(clientChargeData.id, clientChargeData.clientId, clientChargeData.chargeId, clientChargeData.name, clientChargeData.chargeTimeType, clientChargeData.dueDate, clientChargeData.chargeCalculationType, clientChargeData.currency, clientChargeData.amount, clientChargeData.amountPaid, clientChargeData.amountWaived, clientChargeData.amountWrittenOff, clientChargeData.amountOutstanding, clientChargeData.penalty, clientChargeData.isPaid, clientChargeData.isWaived, clientChargeData.isActive, clientChargeData.inactivationDate, clientChargeData.chargeOptions, clientTransactionDatas);
    }

    public static ClientChargeData template(Collection<ChargeData> chargeOptions) {
        Long id = null;
        Long clientId = null;
        Long chargeId = null;
        String name = null;
        EnumOptionData chargeTimeType = null;
        LocalDate dueDate = null;
        EnumOptionData chargeCalculationType = null;
        CurrencyData currency = null;
        BigDecimal amount = null;
        BigDecimal amountPaid = null;
        BigDecimal amountWaived = null;
        BigDecimal amountWrittenOff = null;
        BigDecimal amountOutstanding = null;
        Boolean penalty = false;
        Boolean isPaid = null;
        Boolean isActive = null;
        Boolean isWaived = null;
        LocalDate inactivationDate = null;
        Collection clientTransactionDatas = null;
        return new ClientChargeData(id, clientId, chargeId, name, chargeTimeType, dueDate, chargeCalculationType, currency, amount, amountPaid, amountWaived, amountWrittenOff, amountOutstanding, penalty.booleanValue(), isPaid, isWaived, isActive, inactivationDate, chargeOptions, clientTransactionDatas);
    }

    private ClientChargeData(Long id, Long clientId, Long chargeId, String name, EnumOptionData chargeTimeType, LocalDate dueDate, EnumOptionData chargeCalculationType, CurrencyData currency, BigDecimal amount, BigDecimal amountPaid, BigDecimal amountWaived, BigDecimal amountWrittenOff, BigDecimal amountOutstanding, boolean penalty, Boolean isPaid, Boolean isWaived, Boolean isActive, LocalDate inactivationDate, Collection<ChargeData> chargeOptions, Collection<ClientTransactionData> clientTransactionDatas) {
        this.id = id;
        this.clientId = clientId;
        this.chargeId = chargeId;
        this.name = name;
        this.chargeTimeType = chargeTimeType;
        this.dueDate = dueDate;
        this.chargeCalculationType = chargeCalculationType;
        this.currency = currency;
        this.amount = amount;
        this.amountPaid = amountPaid;
        this.amountWaived = amountWaived;
        this.amountWrittenOff = amountWrittenOff;
        this.amountOutstanding = amountOutstanding;
        this.penalty = penalty;
        this.isPaid = isPaid;
        this.isWaived = isWaived;
        this.isActive = isActive;
        this.inactivationDate = inactivationDate;
        this.chargeOptions = chargeOptions;
        this.clientTransactionDatas = clientTransactionDatas;
    }
}

