/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.serialization.AbstractFromApiJsonDeserializer;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.client.command.ClientIdentifierCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class ClientIdentifierCommandFromApiJsonDeserializer
extends AbstractFromApiJsonDeserializer<ClientIdentifierCommand> {
    public static final String DOCUMENT_TYPE_ID = "documentTypeId";
    public static final String DOCUMENT_KEY = "documentKey";
    public static final String STATUS = "status";
    public static final String DESCRIPTION = "description";
    public static final String DOCUMENT_DESCRIPTION = "documentDescription";
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("documentTypeId", "documentKey", "status", "description"));
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public ClientIdentifierCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public ClientIdentifierCommand commandFromApiJson(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        Long documentTypeId = this.fromApiJsonHelper.extractLongNamed(DOCUMENT_TYPE_ID, element);
        String documentKey = this.fromApiJsonHelper.extractStringNamed(DOCUMENT_KEY, element);
        String documentDescription = this.fromApiJsonHelper.extractStringNamed(DOCUMENT_DESCRIPTION, element);
        String statusString = this.fromApiJsonHelper.extractStringNamed(STATUS, element);
        return new ClientIdentifierCommand(documentTypeId, documentKey, statusString, documentDescription);
    }
}

