/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateralmanagement.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.monetary.service.CurrencyReadPlatformService;
import org.apache.fineract.portfolio.collateralmanagement.api.CollateralManagementApiResourceSwagger;
import org.apache.fineract.portfolio.collateralmanagement.api.CollateralManagementJsonInputParams;
import org.apache.fineract.portfolio.collateralmanagement.data.CollateralManagementData;
import org.apache.fineract.portfolio.collateralmanagement.data.CollateralManagementProductRequest;
import org.apache.fineract.portfolio.collateralmanagement.data.CollateralProductRequest;
import org.apache.fineract.portfolio.collateralmanagement.service.CollateralManagementReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/collateral-management")
@Component
@Tag(name="Collateral Management", description="Collateral Management is for managing collateral operations")
public class CollateralManagementApiResource {
    private final DefaultToApiJsonSerializer<CollateralManagementData> apiJsonSerializerService;
    private final DefaultToApiJsonSerializer<CurrencyData> apiJsonSerializerServiceForCurrency;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final PlatformSecurityContext context;
    private final CollateralManagementReadPlatformService collateralManagementReadPlatformService;
    private final CurrencyReadPlatformService currencyReadPlatformService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a new collateral", description="Collateral Creation")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CollateralManagementProductRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralManagementApiResourceSwagger.PostCollateralManagementProductResponse.class))})})
    public CommandProcessingResult createCollateral(@Parameter(hidden=true) CollateralManagementProductRequest collateralManagementProductRequest) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().createCollateral().withJson(this.apiJsonSerializerService.serialize((Object)collateralManagementProductRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
    }

    @GET
    @Path(value="{collateralId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get Collateral", description="Fetch Collateral")
    public CollateralManagementData getCollateral(@PathParam(value="collateralId") @Parameter(description="collateralId") Long collateralId) {
        this.context.authenticatedUser().validateHasReadPermission(CollateralManagementJsonInputParams.COLLATERAL_PRODUCT_READ_PERMISSION.getValue());
        return this.collateralManagementReadPlatformService.getCollateralProduct(collateralId);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get All Collaterals", description="Fetch all Collateral Products")
    public List<CollateralManagementData> getAllCollaterals() {
        this.context.authenticatedUser().validateHasReadPermission(CollateralManagementJsonInputParams.COLLATERAL_PRODUCT_READ_PERMISSION.getValue());
        return this.collateralManagementReadPlatformService.getAllCollateralProducts();
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get Collateral Template", description="Get Collateral Template")
    public List<CurrencyData> getCollateralTemplate() {
        return this.currencyReadPlatformService.retrieveAllPlatformCurrencies();
    }

    @PUT
    @Path(value="{collateralId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Collateral", description="Update Collateral")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CollateralProductRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralManagementApiResourceSwagger.PutCollateralProductResponse.class))})})
    public CommandProcessingResult updateCollateral(@PathParam(value="collateralId") @Parameter(description="collateralId") Long collateralId, @Parameter(hidden=true) CollateralProductRequest collateralProductRequest) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().updateCollateralProduct(collateralId).withJson(this.apiJsonSerializerService.serialize((Object)collateralProductRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
    }

    @DELETE
    @Path(value="{collateralId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Delete a Collateral", description="Delete Collateral")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralManagementApiResourceSwagger.DeleteCollateralProductResponse.class))})})
    public CommandProcessingResult deleteCollateral(@PathParam(value="collateralId") @Parameter(description="collateralId") Long collateralId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteCollateralProduct(collateralId).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @Generated
    public CollateralManagementApiResource(DefaultToApiJsonSerializer<CollateralManagementData> apiJsonSerializerService, DefaultToApiJsonSerializer<CurrencyData> apiJsonSerializerServiceForCurrency, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, PlatformSecurityContext context, CollateralManagementReadPlatformService collateralManagementReadPlatformService, CurrencyReadPlatformService currencyReadPlatformService) {
        this.apiJsonSerializerService = apiJsonSerializerService;
        this.apiJsonSerializerServiceForCurrency = apiJsonSerializerServiceForCurrency;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.context = context;
        this.collateralManagementReadPlatformService = collateralManagementReadPlatformService;
        this.currencyReadPlatformService = currencyReadPlatformService;
    }
}

