/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateralmanagement.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepositoryWrapper;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagement;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagementRepositoryWrapper;
import org.apache.fineract.portfolio.collateralmanagement.exception.LoanCollateralManagementNotFoundException;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCollateralManagement;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCollateralManagementRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidAmountOfCollateralQuantity;

public class LoanCollateralAssembler {
    private final FromJsonHelper fromApiJsonHelper;
    private final CodeValueRepositoryWrapper codeValueRepository;
    private final LoanCollateralManagementRepository loanCollateralRepository;
    private final ClientCollateralManagementRepositoryWrapper clientCollateralManagementRepositoryWrapper;

    public Set<LoanCollateralManagement> fromParsedJson(JsonElement element) {
        HashSet<LoanCollateralManagement> collateralItems = new HashSet<LoanCollateralManagement>();
        JsonObject jsonObject = element.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(jsonObject);
        if (jsonObject.has("collateral") && jsonObject.get("collateral").isJsonArray()) {
            JsonArray collaterals = jsonObject.get("collateral").getAsJsonArray();
            for (int i = 0; i < collaterals.size(); ++i) {
                JsonObject collateralItemElement = collaterals.get(i).getAsJsonObject();
                Long id = this.fromApiJsonHelper.extractLongNamed("id", (JsonElement)collateralItemElement);
                Long collateralId = this.fromApiJsonHelper.extractLongNamed("clientCollateralId", (JsonElement)collateralItemElement);
                ClientCollateralManagement clientCollateral = this.clientCollateralManagementRepositoryWrapper.getCollateral(collateralId);
                BigDecimal quantity = this.fromApiJsonHelper.extractBigDecimalNamed("quantity", (JsonElement)collateralItemElement, locale);
                BigDecimal updatedClientQuantity = null;
                if (id == null) {
                    updatedClientQuantity = clientCollateral.getQuantity().subtract(quantity);
                    if (BigDecimal.ZERO.compareTo(updatedClientQuantity) > 0) {
                        throw new InvalidAmountOfCollateralQuantity(quantity);
                    }
                    clientCollateral.updateQuantity(updatedClientQuantity);
                    collateralItems.add(LoanCollateralManagement.from((ClientCollateralManagement)clientCollateral, (BigDecimal)quantity));
                    continue;
                }
                LoanCollateralManagement loanCollateralManagement = (LoanCollateralManagement)this.loanCollateralRepository.findById((Object)id).orElseThrow(() -> new LoanCollateralManagementNotFoundException(id));
                if (loanCollateralManagement.getQuantity().compareTo(quantity) != 0) {
                    updatedClientQuantity = clientCollateral.getQuantity().add(loanCollateralManagement.getQuantity()).subtract(quantity);
                    if (BigDecimal.ZERO.compareTo(updatedClientQuantity) > 0) {
                        throw new InvalidAmountOfCollateralQuantity(quantity);
                    }
                } else {
                    updatedClientQuantity = quantity;
                }
                clientCollateral.updateQuantity(updatedClientQuantity);
                collateralItems.add(LoanCollateralManagement.fromExisting((ClientCollateralManagement)clientCollateral, (BigDecimal)quantity, (Loan)loanCollateralManagement.getLoanData(), (LoanTransaction)loanCollateralManagement.getLoanTransaction(), (Long)((Long)loanCollateralManagement.getId())));
            }
        }
        return collateralItems;
    }

    @Generated
    public LoanCollateralAssembler(FromJsonHelper fromApiJsonHelper, CodeValueRepositoryWrapper codeValueRepository, LoanCollateralManagementRepository loanCollateralRepository, ClientCollateralManagementRepositoryWrapper clientCollateralManagementRepositoryWrapper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.codeValueRepository = codeValueRepository;
        this.loanCollateralRepository = loanCollateralRepository;
        this.clientCollateralManagementRepositoryWrapper = clientCollateralManagementRepositoryWrapper;
    }
}

