/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.group.api;

import com.google.gson.JsonElement;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookPopulatorService;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookService;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.api.DateParam;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.DateFormat;
import org.apache.fineract.infrastructure.core.data.PaginationParameters;
import org.apache.fineract.infrastructure.core.data.UploadRequest;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksReadService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.portfolio.accountdetails.data.AccountSummaryCollectionData;
import org.apache.fineract.portfolio.accountdetails.service.AccountDetailsReadPlatformService;
import org.apache.fineract.portfolio.calendar.data.CalendarData;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.service.CalendarReadPlatformService;
import org.apache.fineract.portfolio.collectionsheet.data.JLGCollectionSheetData;
import org.apache.fineract.portfolio.collectionsheet.service.CollectionSheetReadPlatformService;
import org.apache.fineract.portfolio.group.api.CentersApiResourceSwagger;
import org.apache.fineract.portfolio.group.api.GroupingTypesApiConstants;
import org.apache.fineract.portfolio.group.data.CenterData;
import org.apache.fineract.portfolio.group.service.CenterReadPlatformService;
import org.apache.fineract.portfolio.meeting.data.MeetingData;
import org.apache.fineract.portfolio.meeting.service.MeetingReadPlatformService;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;

@Path(value="/v1/centers")
@Component
@Tag(name="Centers", description="Centers along with Groups are used to provided a distinctive banking distribution channel used in microfinance. Its common in areas such as Southern Asia to use Centers and Group as administrative units in grameen style lending. Typically groups will contain one to five people and centers themselves will be made of anywhere between 2-10 groups.")
public class CentersApiResource {
    private final PlatformSecurityContext context;
    private final CenterReadPlatformService centerReadPlatformService;
    private final ToApiJsonSerializer<CenterData> centerApiJsonSerializer;
    private final ToApiJsonSerializer<Object> toApiJsonSerializer;
    private final ToApiJsonSerializer<AccountSummaryCollectionData> groupSummaryToApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final CollectionSheetReadPlatformService collectionSheetReadPlatformService;
    private final FromJsonHelper fromJsonHelper;
    private final AccountDetailsReadPlatformService accountDetailsReadPlatformService;
    private final CalendarReadPlatformService calendarReadPlatformService;
    private final MeetingReadPlatformService meetingReadPlatformService;
    private final EntityDatatableChecksReadService entityDatatableChecksReadService;
    private final BulkImportWorkbookService bulkImportWorkbookService;
    private final BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService;
    private final SqlValidator sqlValidator;

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Center Template", description="Retrieves a Center Template\n\nExample Requests:\n\n\n\ncenters/template\n\n\n\ncenters/template?officeId=2")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CentersApiResourceSwagger.GetCentersTemplateResponse.class))})})
    public String retrieveTemplate(@Context UriInfo uriInfo, @QueryParam(value="command") @Parameter(description="command") String commandParam, @QueryParam(value="officeId") @Parameter(description="officeId") Long officeId, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly) {
        this.context.authenticatedUser().validateHasReadPermission("center");
        if (this.is(commandParam, "close")) {
            CenterData centerClosureTemplate = this.centerReadPlatformService.retrieveCenterWithClosureReasons();
            ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
            return this.centerApiJsonSerializer.serialize(settings, (Object)centerClosureTemplate, GroupingTypesApiConstants.CENTER_RESPONSE_DATA_PARAMETERS);
        }
        CenterData template = this.centerReadPlatformService.retrieveTemplate(officeId, staffInSelectedOfficeOnly);
        List datatableTemplates = this.entityDatatableChecksReadService.retrieveTemplates(StatusEnum.CREATE.getValue(), EntityTables.GROUP.getName(), null);
        template.setDatatables(datatableTemplates);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.centerApiJsonSerializer.serialize(settings, (Object)template, GroupingTypesApiConstants.CENTER_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Centers", description="The default implementation supports pagination and sorting with the default pagination size set to 200 records. The parameter limit with description -1 will return all entries.\n\nExample Requests:\n\n\n\ncenters\n\n\n\ncenters?fields=name,officeName,joinedDate\n\n\n\ncenters?offset=10&limit=50\n\n\n\ncenters?orderBy=name&sortOrder=DESC")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CentersApiResourceSwagger.GetCentersResponse.class))})})
    public String retrieveAll(@Context UriInfo uriInfo, @QueryParam(value="officeId") @Parameter(description="officeId") Long officeId, @QueryParam(value="staffId") @Parameter(description="staffId") Long staffId, @QueryParam(value="externalId") @Parameter(description="externalId") String externalId, @QueryParam(value="name") @Parameter(description="name") String name, @QueryParam(value="underHierarchy") @Parameter(description="underHierarchy") String hierarchy, @QueryParam(value="paged") @Parameter(description="paged") Boolean paged, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder, @QueryParam(value="meetingDate") @Parameter(description="meetingDate") DateParam meetingDateParam, @QueryParam(value="dateFormat") @Parameter(description="dateFormat") String dateFormat, @QueryParam(value="locale") @Parameter(description="locale") String locale) {
        this.context.authenticatedUser().validateHasReadPermission("center");
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (meetingDateParam != null && officeId != null) {
            LocalDate meetingDate = meetingDateParam.getDate("meetingDate", new DateFormat(dateFormat), locale);
            Collection staffCenterDataArray = this.centerReadPlatformService.retriveAllCentersByMeetingDate(officeId, meetingDate, staffId);
            return this.toApiJsonSerializer.serialize(settings, (Object)staffCenterDataArray, GroupingTypesApiConstants.STAFF_CENTER_RESPONSE_DATA_PARAMETERS);
        }
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        this.sqlValidator.validate(externalId);
        this.sqlValidator.validate(hierarchy);
        PaginationParameters parameters = PaginationParameters.builder().paged(Boolean.TRUE.equals(paged)).limit(limit).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).officeId(officeId).externalId(externalId).name(name).hierarchy(hierarchy).offset(offset).orderBy(orderBy).sortOrder(sortOrder).staffId(staffId).build();
        if (parameters.isPaged()) {
            Page centers = this.centerReadPlatformService.retrievePagedAll(searchParameters, parameters);
            return this.toApiJsonSerializer.serialize(settings, (Object)centers, GroupingTypesApiConstants.CENTER_RESPONSE_DATA_PARAMETERS);
        }
        Collection centers = this.centerReadPlatformService.retrieveAll(searchParameters, parameters);
        return this.toApiJsonSerializer.serialize(settings, (Object)centers, GroupingTypesApiConstants.CENTER_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{centerId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Center", description="Retrieves a Center\n\nExample Requests:\n\n\n\ncenters/1\n\n\n\ncenters/1?associations=groupMembers")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CentersApiResourceSwagger.GetCentersCenterIdResponse.class))})})
    public String retrieveOne(@Context UriInfo uriInfo, @PathParam(value="centerId") @Parameter(description="centerId") Long centerId, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly) {
        this.context.authenticatedUser().validateHasReadPermission("center");
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        CalendarData collectionMeetingCalendar = null;
        Collection groups = null;
        CenterData center = this.centerReadPlatformService.retrieveOne(centerId);
        boolean template = ApiParameterHelper.template((MultivaluedMap)uriInfo.getQueryParameters());
        if (template) {
            CenterData templateCenter = this.centerReadPlatformService.retrieveTemplate(center.officeId(), staffInSelectedOfficeOnly);
            center = CenterData.withTemplate((CenterData)templateCenter, (CenterData)center);
        }
        if (!associationParameters.isEmpty()) {
            if (associationParameters.contains("groupMembers")) {
                groups = this.centerReadPlatformService.retrieveAssociatedGroups(centerId);
            }
            if (associationParameters.contains("collectionMeetingCalendar") && (collectionMeetingCalendar = this.calendarReadPlatformService.retrieveCollctionCalendarByEntity(centerId, CalendarEntityType.CENTERS.getValue())) != null) {
                boolean withHistory = true;
                LocalDate tillDate = null;
                Collection recurringDates = this.calendarReadPlatformService.generateRecurringDates(collectionMeetingCalendar, true, tillDate);
                Collection nextTenRecurringDates = this.calendarReadPlatformService.generateNextTenRecurringDates(collectionMeetingCalendar);
                MeetingData lastMeeting = this.meetingReadPlatformService.retrieveLastMeeting(collectionMeetingCalendar.getCalendarInstanceId());
                LocalDate recentEligibleMeetingDate = this.calendarReadPlatformService.generateNextEligibleMeetingDateForCollection(collectionMeetingCalendar, lastMeeting);
                collectionMeetingCalendar = CalendarData.withRecurringDates((CalendarData)collectionMeetingCalendar, (Collection)recurringDates, (Collection)nextTenRecurringDates, (LocalDate)recentEligibleMeetingDate);
            }
            center = CenterData.withAssociations((CenterData)center, (Collection)groups, collectionMeetingCalendar);
        }
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.centerApiJsonSerializer.serialize(settings, (Object)center, GroupingTypesApiConstants.CENTER_RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Center", description="Creates a Center\n\nMandatory Fields: name, officeId, active, activationDate (if active=true)\n\nOptional Fields: externalId, staffId, groupMembers")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CentersApiResourceSwagger.PostCentersRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CentersApiResourceSwagger.PostCentersResponse.class))})})
    public String create(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createCenter().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{centerId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Center", description="Updates a Center")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CentersApiResourceSwagger.PutCentersCenterIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CentersApiResourceSwagger.PutCentersCenterIdResponse.class))})})
    public String update(@PathParam(value="centerId") @Parameter(description="centerId") Long centerId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateCenter(centerId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{centerId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Center", description="A Center can be deleted if it is in pending state and has no association - groups, loans or savings")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CentersApiResourceSwagger.DeleteCentersCenterIdResponse.class))})})
    public String delete(@PathParam(value="centerId") @Parameter(description="centerId") Long centerId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteCenter(centerId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{centerId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Activate a Center | Generate Collection Sheet | Save Collection Sheet | Close a Center | Associate Groups | Disassociate Groups", description="Activate a Center:\n\nCenters can be created in a Pending state. This API exists to enable center activation. If the center happens to be already active, this API will result in an error.\n\nClose a Center:\n\nCenters can be closed if they don't have any non-closed groups or saving accounts. If the Center has any active groups or savings accounts, this API will result in an error.\n\nAssociate Groups:\n\nThis API allows associating existing groups to a center. The groups are listed from the office to which the center is associated. If group(s) is already associated with a center, this API will result in an error.\n\nDisassociate Groups:\n\nThis API allows to disassociate groups from a center.\n\nGenerate Collection Sheet:\n\nThis Api retrieves repayment details of all jlg loans under a center as on a specified meeting date.\n\nSave Collection Sheet:\n\nThis Api allows the loan officer to perform bulk repayments of JLG loans for a center on a given meeting date.\n\nShowing Request/Response for Close a Center")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CentersApiResourceSwagger.PostCentersCenterIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CentersApiResourceSwagger.PostCentersCenterIdResponse.class))})})
    public String activate(@PathParam(value="centerId") @Parameter(description="centerId") Long centerId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson, @Context UriInfo uriInfo) {
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        CommandProcessingResult result = null;
        if (this.is(commandParam, "activate")) {
            CommandWrapper commandRequest = builder.activateCenter(centerId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        if (this.is(commandParam, "generateCollectionSheet")) {
            JsonElement parsedQuery = this.fromJsonHelper.parse(apiRequestBodyAsJson);
            JsonQuery query = JsonQuery.from((String)apiRequestBodyAsJson, (JsonElement)parsedQuery, (FromJsonHelper)this.fromJsonHelper);
            JLGCollectionSheetData collectionSheet = this.collectionSheetReadPlatformService.generateCenterCollectionSheet(centerId, query);
            ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
            return this.toApiJsonSerializer.serialize(settings, (Object)collectionSheet, GroupingTypesApiConstants.COLLECTIONSHEET_DATA_PARAMETERS);
        }
        if (this.is(commandParam, "saveCollectionSheet")) {
            CommandWrapper commandRequest = builder.saveCenterCollectionSheet(centerId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        if (this.is(commandParam, "close")) {
            CommandWrapper commandRequest = builder.closeCenter(centerId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        if (this.is(commandParam, "associateGroups")) {
            CommandWrapper commandRequest = builder.associateGroupsToCenter(centerId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        if (this.is(commandParam, "disassociateGroups")) {
            CommandWrapper commandRequest = builder.disassociateGroupsFromCenter(centerId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"activate", "generateCollectionSheet", "saveCollectionSheet", "close", "associateGroups", "disassociateGroups"});
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @GET
    @Path(value="{centerId}/accounts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Center accounts overview", description="An example of how a savings summary for a Center can be provided. This is requested in a specific use case of the reference application.\n\nIt is quite reasonable to add resources like this to simplify User Interface development.\n\n\n\nExample Requests:\n\n\n\ncenters/9/accounts")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CentersApiResourceSwagger.GetCentersCenterIdAccountsResponse.class))})})
    public String retrieveGroupAccount(@PathParam(value="centerId") @Parameter(description="centerId") Long centerId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("center");
        AccountSummaryCollectionData groupAccount = this.accountDetailsReadPlatformService.retrieveGroupAccountDetails(centerId);
        HashSet<String> GROUP_ACCOUNTS_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("loanAccounts", "savingsAccounts", "memberLoanAccounts", "memberSavingsAccounts"));
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.groupSummaryToApiJsonSerializer.serialize(settings, (Object)groupAccount, GROUP_ACCOUNTS_DATA_PARAMETERS);
    }

    @GET
    @Path(value="downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getCentersTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="staffId") Long staffId, @QueryParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.CENTERS.toString(), officeId, staffId, dateFormat);
    }

    @POST
    @Path(value="uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload centers template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String postCentersTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat) {
        Long importDocumentId = this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.CENTERS.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
        return this.toApiJsonSerializer.serialize((Object)importDocumentId);
    }

    @Generated
    public CentersApiResource(PlatformSecurityContext context, CenterReadPlatformService centerReadPlatformService, ToApiJsonSerializer<CenterData> centerApiJsonSerializer, ToApiJsonSerializer<Object> toApiJsonSerializer, ToApiJsonSerializer<AccountSummaryCollectionData> groupSummaryToApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, CollectionSheetReadPlatformService collectionSheetReadPlatformService, FromJsonHelper fromJsonHelper, AccountDetailsReadPlatformService accountDetailsReadPlatformService, CalendarReadPlatformService calendarReadPlatformService, MeetingReadPlatformService meetingReadPlatformService, EntityDatatableChecksReadService entityDatatableChecksReadService, BulkImportWorkbookService bulkImportWorkbookService, BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService, SqlValidator sqlValidator) {
        this.context = context;
        this.centerReadPlatformService = centerReadPlatformService;
        this.centerApiJsonSerializer = centerApiJsonSerializer;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.groupSummaryToApiJsonSerializer = groupSummaryToApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.collectionSheetReadPlatformService = collectionSheetReadPlatformService;
        this.fromJsonHelper = fromJsonHelper;
        this.accountDetailsReadPlatformService = accountDetailsReadPlatformService;
        this.calendarReadPlatformService = calendarReadPlatformService;
        this.meetingReadPlatformService = meetingReadPlatformService;
        this.entityDatatableChecksReadService = entityDatatableChecksReadService;
        this.bulkImportWorkbookService = bulkImportWorkbookService;
        this.bulkImportWorkbookPopulatorService = bulkImportWorkbookPopulatorService;
        this.sqlValidator = sqlValidator;
    }
}

