/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.group.service;

import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepositoryWrapper;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepositoryWrapper;
import org.apache.fineract.portfolio.group.domain.GroupRole;
import org.apache.fineract.portfolio.group.domain.GroupRoleRepositoryWrapper;
import org.apache.fineract.portfolio.group.exception.ClientNotInGroupException;
import org.apache.fineract.portfolio.group.serialization.GroupRolesDataValidator;
import org.apache.fineract.portfolio.group.service.GroupRolesWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;

public class GroupRolesWritePlatformServiceJpaRepositoryImpl
implements GroupRolesWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupRolesWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final GroupRepositoryWrapper groupRepository;
    private final GroupRolesDataValidator fromApiJsonDeserializer;
    private final CodeValueRepositoryWrapper codeValueRepository;
    private final ClientRepositoryWrapper clientRepository;
    private final GroupRoleRepositoryWrapper groupRoleRepository;

    public CommandProcessingResult createRole(JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreateGroupRole(command);
            Long roleId = command.longValueOfParameterNamed("role");
            CodeValue role = this.codeValueRepository.findOneWithNotFoundDetection(roleId);
            Long clientId = command.longValueOfParameterNamed("clientId");
            Client client = this.clientRepository.findOneWithNotFoundDetection(clientId);
            Group group = this.groupRepository.findOneWithNotFoundDetection(command.getGroupId());
            if (!group.hasClientAsMember(client)) {
                throw new ClientNotInGroupException(clientId, command.getGroupId());
            }
            GroupRole groupRole = GroupRole.createGroupRole((Group)group, (Client)client, (CodeValue)role);
            this.groupRoleRepository.saveAndFlush(groupRole);
            return new CommandProcessingResultBuilder().withClientId((Long)client.getId()).withGroupId((Long)group.getId()).withEntityId((Long)groupRole.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleGroupDataIntegrityIssues(command, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    private void handleGroupDataIntegrityIssues(JsonCommand command, Throwable realCause, NonTransientDataAccessException dve) {
        if (realCause.getMessage().contains("UNIQUE_GROUP_ROLES")) {
            String clientId = command.stringValueOfParameterNamed("clientId");
            String roleId = command.stringValueOfParameterNamed("role");
            String errorMessageForUser = "Group Role with roleId `" + roleId + "`, clientId `" + clientId + "`, groupId `" + command.getGroupId() + "` already exists.";
            String errorMessageForMachine = "error.msg.group.role.already.exists";
            throw new PlatformDataIntegrityException("error.msg.group.role.already.exists", errorMessageForUser, "clientId", new Object[]{roleId, clientId, command.getGroupId()});
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.group.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }

    public CommandProcessingResult updateRole(JsonCommand command) {
        try {
            Long newValue;
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForUpdateRole(command);
            Group group = this.groupRepository.findOneWithNotFoundDetection(command.getGroupId());
            GroupRole groupRole = this.groupRoleRepository.findOneWithNotFoundDetection(command.entityId());
            Map actualChanges = groupRole.update(command);
            if (actualChanges.containsKey("role")) {
                newValue = command.longValueOfParameterNamed("role");
                CodeValue role = null;
                if (newValue != null) {
                    role = this.codeValueRepository.findOneWithNotFoundDetection(newValue);
                }
                groupRole.updateRole(role);
            }
            if (actualChanges.containsKey("clientId")) {
                newValue = command.longValueOfParameterNamed("clientId");
                Client client = null;
                if (newValue != null && !group.hasClientAsMember(client = this.clientRepository.findOneWithNotFoundDetection(newValue))) {
                    throw new ClientNotInGroupException(newValue, command.getGroupId());
                }
                groupRole.updateClient(client);
            }
            this.groupRoleRepository.saveAndFlush(groupRole);
            return new CommandProcessingResultBuilder().with(actualChanges).withGroupId((Long)group.getId()).withEntityId((Long)groupRole.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleGroupDataIntegrityIssues(command, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult deleteRole(Long ruleId) {
        this.context.authenticatedUser();
        GroupRole groupRole = this.groupRoleRepository.findOneWithNotFoundDetection(ruleId);
        this.groupRoleRepository.delete(groupRole);
        return new CommandProcessingResultBuilder().withEntityId((Long)groupRole.getId()).build();
    }

    @Generated
    public GroupRolesWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, GroupRepositoryWrapper groupRepository, GroupRolesDataValidator fromApiJsonDeserializer, CodeValueRepositoryWrapper codeValueRepository, ClientRepositoryWrapper clientRepository, GroupRoleRepositoryWrapper groupRoleRepository) {
        this.context = context;
        this.groupRepository = groupRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.codeValueRepository = codeValueRepository;
        this.clientRepository = clientRepository;
        this.groupRoleRepository = groupRoleRepository;
    }
}

