/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.loanschedule.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanRepaymentScheduleHistory;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanRepaymentScheduleHistoryRepository;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleHistoryReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleHistoryWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.rescheduleloan.domain.LoanRescheduleRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LoanScheduleHistoryWritePlatformServiceImpl
implements LoanScheduleHistoryWritePlatformService {
    private final LoanScheduleHistoryReadPlatformService loanScheduleHistoryReadPlatformService;
    private final LoanRepaymentScheduleHistoryRepository loanRepaymentScheduleHistoryRepository;
    private final PlatformSecurityContext platformSecurityContext;

    public List<LoanRepaymentScheduleHistory> createLoanScheduleArchive(List<LoanRepaymentScheduleInstallment> repaymentScheduleInstallments, Loan loan, LoanRescheduleRequest loanRescheduleRequest) {
        Integer version = this.loanScheduleHistoryReadPlatformService.fetchCurrentVersionNumber((Long)loan.getId()) + 1;
        MonetaryCurrency currency = loan.getCurrency();
        ArrayList<LoanRepaymentScheduleHistory> loanRepaymentScheduleHistoryList = new ArrayList<LoanRepaymentScheduleHistory>();
        for (LoanRepaymentScheduleInstallment repaymentScheduleInstallment : repaymentScheduleInstallments) {
            Integer installmentNumber = repaymentScheduleInstallment.getInstallmentNumber();
            LocalDate fromDate = null;
            LocalDate dueDate = null;
            if (repaymentScheduleInstallment.getFromDate() != null) {
                fromDate = repaymentScheduleInstallment.getFromDate();
            }
            if (repaymentScheduleInstallment.getDueDate() != null) {
                dueDate = repaymentScheduleInstallment.getDueDate();
            }
            BigDecimal principal = repaymentScheduleInstallment.getPrincipal(currency).getAmount();
            BigDecimal interestCharged = repaymentScheduleInstallment.getInterestCharged(currency).getAmount();
            BigDecimal feeChargesCharged = repaymentScheduleInstallment.getFeeChargesCharged(currency).getAmount();
            BigDecimal penaltyCharges = repaymentScheduleInstallment.getPenaltyChargesCharged(currency).getAmount();
            Map oldDates = null;
            OffsetDateTime createdOnDate = DateUtils.getAuditOffsetDateTime();
            LocalDateTime oldCreatedOnDate = null;
            LocalDateTime oldLastModifiedOnDate = null;
            if (repaymentScheduleInstallment.getCreatedDate().isPresent()) {
                createdOnDate = (OffsetDateTime)repaymentScheduleInstallment.getCreatedDate().get();
            } else if (repaymentScheduleInstallment.getId() != null) {
                oldDates = this.loanScheduleHistoryReadPlatformService.fetchOldAuditDates((Long)repaymentScheduleInstallment.getId());
                oldCreatedOnDate = (LocalDateTime)oldDates.get("created_date");
                oldLastModifiedOnDate = (LocalDateTime)oldDates.get("lastmodified_date");
            }
            Long createdByUser = repaymentScheduleInstallment.getCreatedBy().orElse((Long)this.platformSecurityContext.authenticatedUser().getId());
            Long lastModifiedByUser = repaymentScheduleInstallment.getLastModifiedBy().orElse((Long)this.platformSecurityContext.authenticatedUser().getId());
            OffsetDateTime lastModifiedOnDate = DateUtils.getAuditOffsetDateTime();
            if (repaymentScheduleInstallment.getLastModifiedDate().isPresent()) {
                lastModifiedOnDate = (OffsetDateTime)repaymentScheduleInstallment.getLastModifiedDate().get();
            } else if (repaymentScheduleInstallment.getId() != null && oldDates == null) {
                oldDates = this.loanScheduleHistoryReadPlatformService.fetchOldAuditDates((Long)repaymentScheduleInstallment.getId());
                oldCreatedOnDate = (LocalDateTime)oldDates.get("created_date");
                oldLastModifiedOnDate = (LocalDateTime)oldDates.get("lastmodified_date");
            }
            LoanRepaymentScheduleHistory loanRepaymentScheduleHistory = LoanRepaymentScheduleHistory.instance((Loan)loan, (LoanRescheduleRequest)loanRescheduleRequest, (Integer)installmentNumber, (LocalDate)fromDate, (LocalDate)dueDate, (BigDecimal)principal, (BigDecimal)interestCharged, (BigDecimal)feeChargesCharged, (BigDecimal)penaltyCharges, (LocalDateTime)oldCreatedOnDate, (Long)createdByUser, (Long)lastModifiedByUser, (LocalDateTime)oldLastModifiedOnDate, (Integer)version, (OffsetDateTime)createdOnDate, (OffsetDateTime)lastModifiedOnDate);
            loanRepaymentScheduleHistoryList.add(loanRepaymentScheduleHistory);
        }
        return loanRepaymentScheduleHistoryList;
    }

    public void createAndSaveLoanScheduleArchive(List<LoanRepaymentScheduleInstallment> repaymentScheduleInstallments, Loan loan, LoanRescheduleRequest loanRescheduleRequest) {
        List loanRepaymentScheduleHistoryList = this.createLoanScheduleArchive(repaymentScheduleInstallments, loan, loanRescheduleRequest);
        this.loanRepaymentScheduleHistoryRepository.saveAll((Iterable)loanRepaymentScheduleHistoryList);
    }

    @Generated
    public LoanScheduleHistoryWritePlatformServiceImpl(LoanScheduleHistoryReadPlatformService loanScheduleHistoryReadPlatformService, LoanRepaymentScheduleHistoryRepository loanRepaymentScheduleHistoryRepository, PlatformSecurityContext platformSecurityContext) {
        this.loanScheduleHistoryReadPlatformService = loanScheduleHistoryReadPlatformService;
        this.loanRepaymentScheduleHistoryRepository = loanRepaymentScheduleHistoryRepository;
        this.platformSecurityContext = platformSecurityContext;
    }
}

