/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.accountdetails.service.AccountDetailsReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.data.GLIMContainer;
import org.apache.fineract.portfolio.loanaccount.data.GlimRepaymentTemplate;
import org.apache.fineract.portfolio.loanaccount.data.GroupLoanIndividualMonitoringAccountData;
import org.apache.fineract.portfolio.loanaccount.service.GLIMAccountInfoReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.GLIMAccountInfoReadPlatformServiceImpl;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class GLIMAccountInfoReadPlatformServiceImpl
implements GLIMAccountInfoReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final AccountDetailsReadPlatformService accountDetailsReadPlatforService;

    public Collection<GroupLoanIndividualMonitoringAccountData> findGlimAccountsByGLIMId(Long glimId) {
        this.context.authenticatedUser();
        GLIMFieldsMapper rm = new GLIMFieldsMapper();
        String sql = "select " + rm.schema() + " and glim.id=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{glimId});
    }

    public Collection<GroupLoanIndividualMonitoringAccountData> findGlimAccountsByGroupId(String groupId) {
        this.context.authenticatedUser();
        GLIMFieldsMapper rm = new GLIMFieldsMapper();
        String sql = "select " + rm.schema() + " and ln.group_id=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{Long.parseLong(groupId)});
    }

    public Collection<GroupLoanIndividualMonitoringAccountData> findGlimAccountByGroupId(String groupId) {
        this.context.authenticatedUser();
        GLIMMapper rm = new GLIMMapper();
        String sql = "select " + rm.schema() + " where glim.group_id=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{Long.parseLong(groupId)});
    }

    public Collection<GroupLoanIndividualMonitoringAccountData> findGlimAccountByParentAccountId(String parentAccountIds) {
        this.context.authenticatedUser();
        GLIMFieldsMapper rm = new GLIMFieldsMapper();
        String sql = "select " + rm.schema() + " and glim.accountNumber=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{parentAccountIds});
    }

    public Collection<GroupLoanIndividualMonitoringAccountData> findGlimAccountByGroupIdandAccountNo(String groupId, String accountNo) {
        this.context.authenticatedUser();
        GLIMMapper rm = new GLIMMapper();
        String sql = "select " + rm.schema() + " where glim.group_id=? and glim.account_number=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{groupId, accountNo});
    }

    public Collection<GLIMContainer> findGlimAccount(Long groupId) {
        this.context.authenticatedUser();
        Collection glimInfo = this.findGlimAccountByGroupId("" + groupId);
        ArrayList<GLIMContainer> glimAccounts = new ArrayList<GLIMContainer>();
        for (GroupLoanIndividualMonitoringAccountData glimAccount : glimInfo) {
            List childLoans = this.accountDetailsReadPlatforService.retrieveLoanAccountDetailsByGroupIdAndGlimAccountNumber(groupId, glimAccount.getAccountNumber());
            glimAccounts.add(new GLIMContainer(glimAccount.getGlimId(), glimAccount.getGroupId(), glimAccount.getAccountNumber(), childLoans, glimAccount.getParentPrincipalAmount(), glimAccount.getLoanStatus()));
        }
        return glimAccounts;
    }

    public Collection<GLIMContainer> findGlimAccountbyGroupAndAccount(Long groupId, String accountNo) {
        this.context.authenticatedUser();
        Collection glimInfo = this.findGlimAccountByGroupIdandAccountNo("" + groupId, accountNo);
        ArrayList<GLIMContainer> glimAccounts = new ArrayList<GLIMContainer>();
        for (GroupLoanIndividualMonitoringAccountData glimAccount : glimInfo) {
            List childLoans = this.accountDetailsReadPlatforService.retrieveLoanAccountDetailsByGroupIdAndGlimAccountNumber(groupId, glimAccount.getAccountNumber());
            glimAccounts.add(new GLIMContainer(glimAccount.getGlimId(), glimAccount.getGroupId(), glimAccount.getAccountNumber(), childLoans, glimAccount.getParentPrincipalAmount(), glimAccount.getLoanStatus()));
        }
        return glimAccounts;
    }

    public Collection<GlimRepaymentTemplate> findglimRepaymentTemplate(Long glimId) {
        this.context.authenticatedUser();
        GLIMRepaymentMapper rm = new GLIMRepaymentMapper();
        String sql = "select " + rm.schema() + " where glim.id=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{glimId});
    }

    @Generated
    public GLIMAccountInfoReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context, AccountDetailsReadPlatformService accountDetailsReadPlatforService) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
        this.accountDetailsReadPlatforService = accountDetailsReadPlatforService;
    }
}

