/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanAdjustTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanCapitalizedIncomeAmortizationAdjustmentTransactionCreatedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanCapitalizedIncomeAmortizationTransactionCreatedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeBalance;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeStrategy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelation;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelationTypeEnum;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.repository.LoanCapitalizedIncomeBalanceRepository;
import org.apache.fineract.portfolio.loanaccount.service.LoanCapitalizedIncomeAmortizationProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanCapitalizedIncomeAmortizationProcessingServiceImpl;
import org.apache.fineract.portfolio.loanaccount.service.LoanJournalEntryPoster;
import org.apache.fineract.portfolio.loanaccount.util.CapitalizedIncomeAmortizationUtil;
import org.jetbrains.annotations.NotNull;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LoanCapitalizedIncomeAmortizationProcessingServiceImpl
implements LoanCapitalizedIncomeAmortizationProcessingService {
    private final ConfigurationDomainService configurationDomainService;
    private final LoanTransactionRepository loanTransactionRepository;
    private final LoanCapitalizedIncomeBalanceRepository loanCapitalizedIncomeBalanceRepository;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanJournalEntryPoster journalEntryPoster;
    private final ExternalIdFactory externalIdFactory;

    @Transactional
    public void processCapitalizedIncomeAmortizationOnLoanClosure(@NotNull Loan loan, boolean addJournal) {
        List existingTransactionIds = Collections.emptyList();
        List existingReversedTransactionIds = Collections.emptyList();
        if (addJournal) {
            existingTransactionIds = this.loanTransactionRepository.findTransactionIdsByLoan(loan);
            existingReversedTransactionIds = this.loanTransactionRepository.findReversedTransactionIdsByLoan(loan);
        }
        LocalDate transactionDate = this.getFinalCapitalizedIncomeAmortizationTransactionDate(loan);
        Optional amortizationTransaction = this.createCapitalizedIncomeAmortizationTransaction(loan, transactionDate, false, null);
        amortizationTransaction.ifPresent(loanTransaction -> {
            if (loanTransaction.isCapitalizedIncomeAmortization()) {
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanCapitalizedIncomeAmortizationTransactionCreatedBusinessEvent(loanTransaction));
            } else {
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanCapitalizedIncomeAmortizationAdjustmentTransactionCreatedBusinessEvent(loanTransaction));
            }
        });
        if (addJournal) {
            this.journalEntryPoster.postJournalEntries(loan, existingTransactionIds, existingReversedTransactionIds);
        }
    }

    @Transactional
    public void processCapitalizedIncomeAmortizationOnLoanChargeOff(@NotNull Loan loan, @NonNull LoanTransaction chargeOffTransaction) {
        Optional amortizationTransaction;
        List existingTransactionIds = this.loanTransactionRepository.findTransactionIdsByLoan(loan);
        List existingReversedTransactionIds = this.loanTransactionRepository.findReversedTransactionIdsByLoan(loan);
        LocalDate transactionDate = loan.getChargedOffOnDate();
        if (transactionDate == null) {
            transactionDate = DateUtils.getBusinessLocalDate();
        }
        if ((amortizationTransaction = this.createCapitalizedIncomeAmortizationTransaction(loan, transactionDate, true, chargeOffTransaction)).isPresent()) {
            this.journalEntryPoster.postJournalEntries(loan, existingTransactionIds, existingReversedTransactionIds);
            if (((LoanTransaction)amortizationTransaction.get()).isCapitalizedIncomeAmortization()) {
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanCapitalizedIncomeAmortizationTransactionCreatedBusinessEvent((LoanTransaction)amortizationTransaction.get()));
            } else {
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanCapitalizedIncomeAmortizationAdjustmentTransactionCreatedBusinessEvent((LoanTransaction)amortizationTransaction.get()));
            }
        }
    }

    private Optional<LoanTransaction> createCapitalizedIncomeAmortizationTransaction(Loan loan, LocalDate transactionDate, boolean isChargeOff, LoanTransaction chargeOffTransaction) {
        LoanTransaction amortizationTransaction;
        ExternalId externalId = ExternalId.empty();
        if (this.configurationDomainService.isExternalIdAutoGenerationEnabled()) {
            externalId = ExternalId.generate();
        }
        List balances = this.loanCapitalizedIncomeBalanceRepository.findAllByLoanId((Long)loan.getId());
        BigDecimal totalAmortizationAmount = BigDecimal.ZERO;
        for (LoanCapitalizedIncomeBalance balance : balances) {
            List adjustments = this.loanTransactionRepository.findAdjustments(balance.getLoanTransaction());
            LocalDate maturityDate = loan.getMaturityDate() != null ? loan.getMaturityDate() : transactionDate;
            Money amortizationTillDate = CapitalizedIncomeAmortizationUtil.calculateTotalAmortizationTillDate((LoanCapitalizedIncomeBalance)balance, (List)adjustments, (LocalDate)maturityDate, (LoanCapitalizedIncomeStrategy)loan.getLoanProductRelatedDetail().getCapitalizedIncomeStrategy(), (LocalDate)maturityDate, (MonetaryCurrency)loan.getCurrency());
            totalAmortizationAmount = totalAmortizationAmount.add(amortizationTillDate.getAmount());
            if (isChargeOff) {
                balance.setChargedOffAmount(balance.getUnrecognizedAmount());
            }
            balance.setUnrecognizedAmount(BigDecimal.ZERO);
        }
        BigDecimal amortizedAmount = this.loanTransactionRepository.getAmortizedAmountCapitalizedIncome(loan);
        BigDecimal totalUnrecognizedAmount = totalAmortizationAmount.subtract(amortizedAmount);
        if (MathUtil.isZero((BigDecimal)totalUnrecognizedAmount)) {
            return Optional.empty();
        }
        LoanTransaction loanTransaction = amortizationTransaction = MathUtil.isGreaterThanZero((BigDecimal)totalUnrecognizedAmount) ? LoanTransaction.capitalizedIncomeAmortization((Loan)loan, (Office)loan.getOffice(), (LocalDate)transactionDate, (BigDecimal)totalUnrecognizedAmount, (ExternalId)externalId) : LoanTransaction.capitalizedIncomeAmortizationAdjustment((Loan)loan, (Money)Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)MathUtil.negate((BigDecimal)totalUnrecognizedAmount)), (LocalDate)transactionDate, (ExternalId)externalId);
        if (isChargeOff) {
            amortizationTransaction.getLoanTransactionRelations().add(LoanTransactionRelation.linkToTransaction((LoanTransaction)amortizationTransaction, (LoanTransaction)chargeOffTransaction, (LoanTransactionRelationTypeEnum)LoanTransactionRelationTypeEnum.RELATED));
        }
        loan.addLoanTransaction(amortizationTransaction);
        this.loanTransactionRepository.saveAndFlush((Object)amortizationTransaction);
        return Optional.of(amortizationTransaction);
    }

    @Transactional
    public void processCapitalizedIncomeAmortizationOnLoanUndoChargeOff(@NotNull LoanTransaction loanTransaction) {
        Loan loan = loanTransaction.getLoan();
        List existingTransactionIds = this.loanTransactionRepository.findTransactionIdsByLoan(loan);
        List existingReversedTransactionIds = this.loanTransactionRepository.findReversedTransactionIdsByLoan(loan);
        loan.getLoanTransactions().stream().filter(LoanTransaction::isCapitalizedIncomeAmortization).filter(transaction -> transaction.getTransactionDate().equals(loanTransaction.getTransactionDate()) && transaction.getLoanTransactionRelations().stream().anyMatch(rel -> LoanTransactionRelationTypeEnum.RELATED.equals((Object)rel.getRelationType()) && rel.getToTransaction().equals(loanTransaction))).forEach(transaction -> {
            transaction.reverse();
            LoanAdjustTransactionBusinessEvent.Data data = new LoanAdjustTransactionBusinessEvent.Data(transaction);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanAdjustTransactionBusinessEvent(data));
        });
        for (LoanCapitalizedIncomeBalance balance : this.loanCapitalizedIncomeBalanceRepository.findAllByLoanId((Long)loan.getId())) {
            balance.setUnrecognizedAmount(balance.getChargedOffAmount());
            balance.setChargedOffAmount(BigDecimal.ZERO);
        }
        this.journalEntryPoster.postJournalEntries(loan, existingTransactionIds, existingReversedTransactionIds);
    }

    @Transactional
    public void processCapitalizedIncomeAmortizationTillDate(@NonNull Loan loan, @NonNull LocalDate tillDate, boolean addJournal) {
        List existingTransactionIds = this.loanTransactionRepository.findTransactionIdsByLoan(loan);
        List existingReversedTransactionIds = this.loanTransactionRepository.findReversedTransactionIdsByLoan(loan);
        List balances = this.loanCapitalizedIncomeBalanceRepository.findAllByLoanId((Long)loan.getId());
        LocalDate maturityDate = loan.getMaturityDate() != null ? loan.getMaturityDate() : this.getFinalCapitalizedIncomeAmortizationTransactionDate(loan);
        LocalDate tillDatePlusOne = tillDate.plusDays(1L);
        if (tillDatePlusOne.isAfter(maturityDate)) {
            tillDatePlusOne = maturityDate;
        }
        Money totalAmortization = Money.zero((MonetaryCurrency)loan.getCurrency());
        for (LoanCapitalizedIncomeBalance balance : balances) {
            List adjustments = this.loanTransactionRepository.findAdjustments(balance.getLoanTransaction());
            Money amortizationTillDate = CapitalizedIncomeAmortizationUtil.calculateTotalAmortizationTillDate((LoanCapitalizedIncomeBalance)balance, (List)adjustments, (LocalDate)maturityDate, (LoanCapitalizedIncomeStrategy)loan.getLoanProductRelatedDetail().getCapitalizedIncomeStrategy(), (LocalDate)tillDatePlusOne, (MonetaryCurrency)loan.getCurrency());
            totalAmortization = totalAmortization.add(amortizationTillDate);
            balance.setUnrecognizedAmount(balance.getAmount().subtract(MathUtil.nullToZero((BigDecimal)balance.getAmountAdjustment())).subtract(amortizationTillDate.getAmount()));
        }
        this.loanCapitalizedIncomeBalanceRepository.saveAll((Iterable)balances);
        BigDecimal totalAmortized = this.loanTransactionRepository.getAmortizedAmountCapitalizedIncome(loan);
        BigDecimal totalAmortizationAmount = totalAmortization.getAmount().subtract(totalAmortized);
        if (!MathUtil.isZero((BigDecimal)totalAmortizationAmount)) {
            LoanTransaction transaction = MathUtil.isGreaterThanZero((BigDecimal)totalAmortizationAmount) ? LoanTransaction.capitalizedIncomeAmortization((Loan)loan, (Office)loan.getOffice(), (LocalDate)tillDate, (BigDecimal)totalAmortizationAmount, (ExternalId)this.externalIdFactory.create()) : LoanTransaction.capitalizedIncomeAmortizationAdjustment((Loan)loan, (Money)Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)MathUtil.negate((BigDecimal)totalAmortizationAmount)), (LocalDate)tillDate, (ExternalId)this.externalIdFactory.create());
            loan.addLoanTransaction(transaction);
            transaction = (LoanTransaction)this.loanTransactionRepository.save((Object)transaction);
            this.loanTransactionRepository.flush();
            if (addJournal) {
                this.journalEntryPoster.postJournalEntries(loan, existingTransactionIds, existingReversedTransactionIds);
            }
            LoanCapitalizedIncomeAmortizationTransactionCreatedBusinessEvent event = MathUtil.isGreaterThanZero((BigDecimal)totalAmortizationAmount) ? new LoanCapitalizedIncomeAmortizationTransactionCreatedBusinessEvent(transaction) : new LoanCapitalizedIncomeAmortizationAdjustmentTransactionCreatedBusinessEvent(transaction);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)event);
        }
    }

    private LocalDate getFinalCapitalizedIncomeAmortizationTransactionDate(Loan loan) {
        return switch (1.$SwitchMap$org$apache$fineract$portfolio$loanaccount$domain$LoanStatus[loan.getStatus().ordinal()]) {
            case 1 -> loan.getClosedOnDate();
            case 2 -> loan.getOverpaidOnDate();
            case 3 -> loan.getWrittenOffOnDate();
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(loan.getStatus()));
        };
    }

    @Generated
    public LoanCapitalizedIncomeAmortizationProcessingServiceImpl(ConfigurationDomainService configurationDomainService, LoanTransactionRepository loanTransactionRepository, LoanCapitalizedIncomeBalanceRepository loanCapitalizedIncomeBalanceRepository, BusinessEventNotifierService businessEventNotifierService, LoanJournalEntryPoster journalEntryPoster, ExternalIdFactory externalIdFactory) {
        this.configurationDomainService = configurationDomainService;
        this.loanTransactionRepository = loanTransactionRepository;
        this.loanCapitalizedIncomeBalanceRepository = loanCapitalizedIncomeBalanceRepository;
        this.businessEventNotifierService = businessEventNotifierService;
        this.journalEntryPoster = journalEntryPoster;
        this.externalIdFactory = externalIdFactory;
    }
}

