/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.charge.exception.LoanChargeNotFoundException;
import org.apache.fineract.portfolio.charge.service.ChargeDropdownReadPlatformService;
import org.apache.fineract.portfolio.common.service.DropdownReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.data.LoanChargeData;
import org.apache.fineract.portfolio.loanaccount.data.LoanChargePaidByData;
import org.apache.fineract.portfolio.loanaccount.data.LoanInstallmentChargeData;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargeRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class LoanChargeReadPlatformServiceImpl
implements LoanChargeReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final ChargeDropdownReadPlatformService chargeDropdownReadPlatformService;
    private final DropdownReadPlatformService dropdownReadPlatformService;
    private final LoanChargeRepository loanChargeRepository;

    public ChargeData retrieveLoanChargeTemplate() {
        List allowedChargeCalculationTypeOptions = this.chargeDropdownReadPlatformService.retrieveCalculationTypes();
        List allowedChargeTimeOptions = this.chargeDropdownReadPlatformService.retrieveCollectionTimeTypes();
        List loansChargeCalculationTypeOptions = this.chargeDropdownReadPlatformService.retrieveLoanCalculationTypes();
        List loansChargeTimeTypeOptions = this.chargeDropdownReadPlatformService.retrieveLoanCollectionTimeTypes();
        List savingsChargeCalculationTypeOptions = this.chargeDropdownReadPlatformService.retrieveSavingsCalculationTypes();
        List savingsChargeTimeTypeOptions = this.chargeDropdownReadPlatformService.retrieveSavingsCollectionTimeTypes();
        List feeFrequencyOptions = this.dropdownReadPlatformService.retrievePeriodFrequencyTypeOptions();
        return ChargeData.builder().chargeCalculationTypeOptions(allowedChargeCalculationTypeOptions).chargeTimeTypeOptions(allowedChargeTimeOptions).loanChargeCalculationTypeOptions(loansChargeCalculationTypeOptions).loanChargeTimeTypeOptions(loansChargeTimeTypeOptions).savingsChargeCalculationTypeOptions(savingsChargeCalculationTypeOptions).savingsChargeTimeTypeOptions(savingsChargeTimeTypeOptions).feeFrequencyOptions(feeFrequencyOptions).build();
    }

    public LoanChargeData retrieveLoanChargeDetails(Long id, Long loanId) {
        try {
            LoanChargeMapper rm = new LoanChargeMapper();
            String sql = "select " + rm.schema() + " where lc.id=? and lc.loan_id=?";
            return (LoanChargeData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{id, loanId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new LoanChargeNotFoundException(id, loanId, e);
        }
    }

    public Collection<LoanChargeData> retrieveLoanCharges(Long loanId) {
        LoanChargeMapper rm = new LoanChargeMapper();
        String sql = "select " + rm.schema() + " where lc.loan_id=? AND lc.is_active = true order by coalesce(lc.due_for_collection_as_of_date,date(coalesce(dd.disbursedon_date,dd.expected_disburse_date))),lc.charge_time_enum ASC, lc.due_for_collection_as_of_date ASC, lc.is_penalty ASC";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{loanId});
    }

    public Collection<LoanChargeData> retrieveLoanChargesForFeePayment(Integer paymentMode, Integer loanStatus) {
        LoanChargeMapperWithLoanId rm = new LoanChargeMapperWithLoanId();
        String sql = "select " + rm.schema() + "where loan.loan_status_id= ? and lc.charge_payment_mode_enum=? and lc.waived = false and lc.is_paid_derived=false and lc.is_active = true";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{loanStatus, paymentMode});
    }

    public List<LoanInstallmentChargeData> retrieveInstallmentLoanCharges(Long loanChargeId, boolean onlyPaymentPendingCharges) {
        LoanInstallmentChargeMapper rm = new LoanInstallmentChargeMapper();
        String sql = "select " + rm.schema() + "where lic.loan_charge_id= ? ";
        if (onlyPaymentPendingCharges) {
            sql = sql + "and lic.waived = false and lic.is_paid_derived=false";
        }
        sql = sql + " order by lsi.installment";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{loanChargeId});
    }

    public Collection<Integer> retrieveOverdueInstallmentChargeFrequencyNumber(Loan loan, Charge charge, Integer periodNumber) {
        ArrayList<Integer> frequencyNumbers = new ArrayList<Integer>();
        for (LoanCharge loanCharge : loan.getLoanCharges()) {
            if (!loanCharge.isOverdueInstallmentCharge() || !charge.equals((Object)loanCharge.getCharge()) || !loanCharge.isActive() || !periodNumber.equals(loanCharge.getOverdueInstallmentCharge().getInstallment().getInstallmentNumber())) continue;
            frequencyNumbers.add(loanCharge.getOverdueInstallmentCharge().getFrequencyNumber());
        }
        return frequencyNumbers;
    }

    public Collection<LoanChargePaidByData> retrieveLoanChargesPaidBy(Long chargeId, LoanTransactionType transactionType, Integer installmentNumber) {
        LoanChargesPaidByMapper rm = new LoanChargesPaidByMapper();
        StringBuilder sb = new StringBuilder(100);
        sb.append("select ");
        sb.append(rm.schema());
        sb.append(" where lcp.loan_charge_id = ?");
        ArrayList<Number> args = new ArrayList<Number>(3);
        args.add(chargeId);
        if (transactionType != null) {
            sb.append(" and lt.transaction_type_enum = ?");
            args.add(transactionType.getValue());
        }
        if (installmentNumber != null) {
            sb.append(" and lcp.installment_number = ?");
            args.add(installmentNumber);
        }
        return this.jdbcTemplate.query(sb.toString(), (RowMapper)rm, args.toArray());
    }

    public Long retrieveLoanChargeIdByExternalId(ExternalId externalId) {
        return this.loanChargeRepository.findIdByExternalId(externalId);
    }

    @Generated
    public LoanChargeReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, ChargeDropdownReadPlatformService chargeDropdownReadPlatformService, DropdownReadPlatformService dropdownReadPlatformService, LoanChargeRepository loanChargeRepository) {
        this.jdbcTemplate = jdbcTemplate;
        this.chargeDropdownReadPlatformService = chargeDropdownReadPlatformService;
        this.dropdownReadPlatformService = dropdownReadPlatformService;
        this.loanChargeRepository = loanChargeRepository;
    }
}

