/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.math.MathContext;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.monetary.domain.MoneyHelper;
import org.apache.fineract.portfolio.loanaccount.data.OutstandingAmountsDTO;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.ChangedTransactionDetail;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanInterestRecalculationDetails;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleTransactionProcessorFactory;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.LoanRepaymentScheduleTransactionProcessor;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.MoneyHolder;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.TransactionCtx;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.impl.AdvancedPaymentScheduleTransactionProcessor;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.impl.ProgressiveTransactionCtx;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanScheduleDTO;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanApplicationTerms;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleGenerator;
import org.apache.fineract.portfolio.loanaccount.mapper.LoanTermVariationsMapper;
import org.apache.fineract.portfolio.loanaccount.service.InterestScheduleModelRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.service.LoanBalanceService;
import org.apache.fineract.portfolio.loanaccount.service.LoanTransactionProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanTransactionService;
import org.apache.fineract.portfolio.loanproduct.calc.data.ProgressiveLoanInterestScheduleModel;
import org.apache.fineract.portfolio.loanproduct.domain.InterestMethod;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.ObjectUtils;

@Service
public class LoanTransactionProcessingServiceImpl
implements LoanTransactionProcessingService {
    private final LoanRepaymentScheduleTransactionProcessorFactory transactionProcessorFactory;
    private final LoanTermVariationsMapper loanMapper;
    private final InterestScheduleModelRepositoryWrapper modelRepository;
    private final LoanBalanceService loanBalanceService;
    private final LoanTransactionService loanTransactionService;

    public boolean canProcessLatestTransactionOnly(Loan loan, LoanTransaction loanTransaction, LoanRepaymentScheduleInstallment currentInstallment) {
        if (!loan.isInterestBearingAndInterestRecalculationEnabled()) {
            return true;
        }
        if (!DateUtils.isEqualBusinessDate((LocalDate)loanTransaction.getTransactionDate())) {
            return false;
        }
        if (loan.hasChargesAffectedByBackdatedRepaymentLikeTransaction(loanTransaction)) {
            return false;
        }
        LoanInterestRecalculationDetails interestRecalculationDetails = loan.getLoanInterestRecalculationDetails();
        if (interestRecalculationDetails != null && (interestRecalculationDetails.getRestFrequencyType().isSameAsRepayment() && interestRecalculationDetails.getPreCloseInterestCalculationStrategy().calculateTillPreClosureDateEnabled() || interestRecalculationDetails.getRestFrequencyType().isDaily() && interestRecalculationDetails.getPreCloseInterestCalculationStrategy().calculateTillRestFrequencyEnabled())) {
            return false;
        }
        if (loan.isProgressiveSchedule()) {
            return this.modelRepository.hasValidModelForDate((Long)loan.getId(), loanTransaction.getTransactionDate());
        }
        return currentInstallment != null && currentInstallment.getTotalOutstanding(loan.getCurrency()).isEqualTo(loanTransaction.getAmount(loan.getCurrency()));
    }

    private ChangedTransactionDetail processLatestTransactionProgressiveInterestRecalculation(AdvancedPaymentScheduleTransactionProcessor advancedProcessor, Loan loan, LoanTransaction loanTransaction) {
        Optional savedModel = this.modelRepository.getSavedModel(loan, loanTransaction.getTransactionDate());
        ProgressiveTransactionCtx progressiveContext = new ProgressiveTransactionCtx(loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges(), new MoneyHolder(loan.getTotalOverpaidAsMoney()), new ChangedTransactionDetail(), (ProgressiveLoanInterestScheduleModel)savedModel.orElse(null), this.getTotalRefundInterestAmount(loan));
        progressiveContext.getAlreadyProcessedTransactions().addAll(this.loanTransactionService.retrieveListOfTransactionsForReprocessing(loan));
        progressiveContext.setChargedOff(loan.isChargedOff());
        progressiveContext.setContractTerminated(loan.isContractTermination());
        ChangedTransactionDetail result = advancedProcessor.processLatestTransaction(loanTransaction, (TransactionCtx)progressiveContext);
        if (savedModel.isPresent() && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
            this.modelRepository.writeInterestScheduleModel(loan, (ProgressiveLoanInterestScheduleModel)savedModel.get());
        }
        return result;
    }

    private Money getTotalRefundInterestAmount(Loan loan) {
        List supportedInterestRefundTransactionTypes = loan.getSupportedInterestRefundTransactionTypes();
        if (supportedInterestRefundTransactionTypes != null && supportedInterestRefundTransactionTypes.isEmpty()) {
            return Money.zero((MonetaryCurrency)loan.getCurrency());
        }
        return loan.getLoanTransactions().stream().filter(LoanTransaction::isNotReversed).filter(LoanTransaction::isInterestRefund).map(t -> t.getAmount(loan.getCurrency())).reduce(Money.zero((MonetaryCurrency)loan.getCurrency()), Money::add);
    }

    public ChangedTransactionDetail processLatestTransaction(String transactionProcessingStrategyCode, LoanTransaction loanTransaction, TransactionCtx ctx) {
        LoanRepaymentScheduleTransactionProcessor loanRepaymentScheduleTransactionProcessor = this.getTransactionProcessor(transactionProcessingStrategyCode);
        if (loanRepaymentScheduleTransactionProcessor instanceof AdvancedPaymentScheduleTransactionProcessor) {
            AdvancedPaymentScheduleTransactionProcessor advancedProcessor = (AdvancedPaymentScheduleTransactionProcessor)loanRepaymentScheduleTransactionProcessor;
            if (loanTransaction.getLoan().isInterestBearingAndInterestRecalculationEnabled()) {
                return this.processLatestTransactionProgressiveInterestRecalculation(advancedProcessor, loanTransaction.getLoan(), loanTransaction);
            }
        }
        return loanRepaymentScheduleTransactionProcessor.processLatestTransaction(loanTransaction, ctx);
    }

    private Loan getLoan(List<LoanTransaction> loanTransactions, List<LoanRepaymentScheduleInstallment> installments, Set<LoanCharge> charges) {
        if (!ObjectUtils.isEmpty(loanTransactions)) {
            return loanTransactions.getFirst().getLoan();
        }
        if (!ObjectUtils.isEmpty(installments)) {
            return installments.getFirst().getLoan();
        }
        if (!ObjectUtils.isEmpty(charges)) {
            return charges.iterator().next().getLoan();
        }
        throw new IllegalArgumentException("No loan found for the given transactions, installments or charges");
    }

    public ChangedTransactionDetail reprocessLoanTransactions(String transactionProcessingStrategyCode, LocalDate disbursementDate, List<LoanTransaction> loanTransactions, MonetaryCurrency currency, List<LoanRepaymentScheduleInstallment> installments, Set<LoanCharge> charges) {
        LoanRepaymentScheduleTransactionProcessor loanRepaymentScheduleTransactionProcessor = this.getTransactionProcessor(transactionProcessingStrategyCode);
        if (loanRepaymentScheduleTransactionProcessor instanceof AdvancedPaymentScheduleTransactionProcessor) {
            AdvancedPaymentScheduleTransactionProcessor advancedProcessor = (AdvancedPaymentScheduleTransactionProcessor)loanRepaymentScheduleTransactionProcessor;
            LocalDate currentDate = DateUtils.getBusinessLocalDate();
            Pair result = advancedProcessor.reprocessProgressiveLoanTransactions(disbursementDate, currentDate, loanTransactions, currency, installments, charges);
            if (!TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                this.modelRepository.writeInterestScheduleModel(this.getLoan(loanTransactions, installments, charges), (ProgressiveLoanInterestScheduleModel)result.getRight());
            }
            return (ChangedTransactionDetail)result.getLeft();
        }
        return loanRepaymentScheduleTransactionProcessor.reprocessLoanTransactions(disbursementDate, loanTransactions, currency, installments, charges);
    }

    public LoanRepaymentScheduleTransactionProcessor getTransactionProcessor(String transactionProcessingStrategyCode) {
        return this.transactionProcessorFactory.determineProcessor(transactionProcessingStrategyCode);
    }

    public Optional<ChangedTransactionDetail> processPostDisbursementTransactions(Loan loan) {
        LoanRepaymentScheduleTransactionProcessor loanRepaymentScheduleTransactionProcessor = this.getTransactionProcessor(loan.getTransactionProcessingStrategyCode());
        List allNonContraTransactionsPostDisbursement = this.loanTransactionService.retrieveListOfTransactionsForReprocessing(loan);
        ArrayList<LoanTransaction> copyTransactions = new ArrayList<LoanTransaction>();
        if (allNonContraTransactionsPostDisbursement.isEmpty()) {
            return Optional.empty();
        }
        for (LoanTransaction loanTransaction : allNonContraTransactionsPostDisbursement) {
            copyTransactions.add(LoanTransaction.copyTransactionProperties((LoanTransaction)loanTransaction));
        }
        ChangedTransactionDetail changedTransactionDetail = loanRepaymentScheduleTransactionProcessor.reprocessLoanTransactions(loan.getDisbursementDate(), copyTransactions, loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges());
        this.loanBalanceService.updateLoanSummaryDerivedFields(loan);
        return Optional.of(changedTransactionDetail);
    }

    public LoanScheduleDTO getRecalculatedSchedule(ScheduleGeneratorDTO generatorDTO, Loan loan) {
        if (!loan.isInterestBearingAndInterestRecalculationEnabled() || loan.isNpa() || loan.isChargedOff()) {
            return null;
        }
        InterestMethod interestMethod = loan.getLoanRepaymentScheduleDetail().getInterestMethod();
        LoanScheduleGenerator loanScheduleGenerator = generatorDTO.getLoanScheduleFactory().create(loan.getLoanRepaymentScheduleDetail().getLoanScheduleType(), interestMethod);
        MathContext mc = MoneyHelper.getMathContext();
        LoanApplicationTerms loanApplicationTerms = this.loanMapper.constructLoanApplicationTerms(generatorDTO, loan);
        LoanRepaymentScheduleTransactionProcessor loanRepaymentScheduleTransactionProcessor = this.getTransactionProcessor(loan.getTransactionProcessingStrategyCode());
        return loanScheduleGenerator.rescheduleNextInstallments(mc, loanApplicationTerms, loan, generatorDTO.getHolidayDetailDTO(), loanRepaymentScheduleTransactionProcessor, generatorDTO.getRecalculateFrom(), generatorDTO.getRecalculateTill());
    }

    public OutstandingAmountsDTO fetchPrepaymentDetail(ScheduleGeneratorDTO scheduleGeneratorDTO, LocalDate onDate, Loan loan) {
        OutstandingAmountsDTO outstandingAmounts;
        if (loan.isInterestBearingAndInterestRecalculationEnabled() && !loan.isChargeOffOnDate(onDate)) {
            MathContext mc = MoneyHelper.getMathContext();
            InterestMethod interestMethod = loan.getLoanRepaymentScheduleDetail().getInterestMethod();
            LoanApplicationTerms loanApplicationTerms = this.loanMapper.constructLoanApplicationTerms(scheduleGeneratorDTO, loan);
            LoanScheduleGenerator loanScheduleGenerator = scheduleGeneratorDTO.getLoanScheduleFactory().create(loanApplicationTerms.getLoanScheduleType(), interestMethod);
            LoanRepaymentScheduleTransactionProcessor loanRepaymentScheduleTransactionProcessor = this.getTransactionProcessor(loan.getTransactionProcessingStrategyCode());
            outstandingAmounts = loanScheduleGenerator.calculatePrepaymentAmount(loan.getCurrency(), onDate, loanApplicationTerms, mc, loan, scheduleGeneratorDTO.getHolidayDetailDTO(), loanRepaymentScheduleTransactionProcessor);
        } else {
            outstandingAmounts = this.getTotalOutstandingOnLoan(loan);
        }
        return outstandingAmounts;
    }

    private OutstandingAmountsDTO getTotalOutstandingOnLoan(Loan loan) {
        Money totalPrincipal = Money.zero((MonetaryCurrency)loan.getCurrency());
        Money totalInterest = Money.zero((MonetaryCurrency)loan.getCurrency());
        Money feeCharges = Money.zero((MonetaryCurrency)loan.getCurrency());
        Money penaltyCharges = Money.zero((MonetaryCurrency)loan.getCurrency());
        List repaymentSchedule = loan.getRepaymentScheduleInstallments();
        for (LoanRepaymentScheduleInstallment scheduledRepayment : repaymentSchedule) {
            totalPrincipal = totalPrincipal.plus(scheduledRepayment.getPrincipalOutstanding(loan.getCurrency()));
            totalInterest = totalInterest.plus(scheduledRepayment.getInterestOutstanding(loan.getCurrency()));
            feeCharges = feeCharges.plus(scheduledRepayment.getFeeChargesOutstanding(loan.getCurrency()));
            penaltyCharges = penaltyCharges.plus(scheduledRepayment.getPenaltyChargesOutstanding(loan.getCurrency()));
        }
        return new OutstandingAmountsDTO(totalPrincipal.getCurrency()).principal(totalPrincipal).interest(totalInterest).feeCharges(feeCharges).penaltyCharges(penaltyCharges);
    }

    @Generated
    public LoanTransactionProcessingServiceImpl(LoanRepaymentScheduleTransactionProcessorFactory transactionProcessorFactory, LoanTermVariationsMapper loanMapper, InterestScheduleModelRepositoryWrapper modelRepository, LoanBalanceService loanBalanceService, LoanTransactionService loanTransactionService) {
        this.transactionProcessorFactory = transactionProcessorFactory;
        this.loanMapper = loanMapper;
        this.modelRepository = modelRepository;
        this.loanBalanceService = loanBalanceService;
        this.loanTransactionService = loanTransactionService;
    }
}

