/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanproduct.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.accounting.common.AccountingDropdownReadPlatformService;
import org.apache.fineract.accounting.producttoaccountmapping.service.ProductToGLAccountMappingReadPlatformService;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.ApiFacingEnum;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.service.CurrencyReadPlatformService;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.common.domain.DaysInYearCustomStrategyType;
import org.apache.fineract.portfolio.common.service.DropdownReadPlatformService;
import org.apache.fineract.portfolio.delinquency.service.DelinquencyReadPlatformService;
import org.apache.fineract.portfolio.floatingrates.service.FloatingRatesReadPlatformService;
import org.apache.fineract.portfolio.fund.service.FundReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeCalculationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeIncomeType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeStrategy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeCalculationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeStrategy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargeOffBehaviour;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleProcessingType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.apache.fineract.portfolio.loanproduct.api.LoanProductsApiResourceSwagger;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductData;
import org.apache.fineract.portfolio.loanproduct.domain.AllocationType;
import org.apache.fineract.portfolio.loanproduct.domain.CreditAllocationTransactionType;
import org.apache.fineract.portfolio.loanproduct.domain.FutureInstallmentAllocationRule;
import org.apache.fineract.portfolio.loanproduct.domain.LoanSupportedInterestRefundTypes;
import org.apache.fineract.portfolio.loanproduct.domain.PaymentAllocationTransactionType;
import org.apache.fineract.portfolio.loanproduct.domain.PaymentAllocationType;
import org.apache.fineract.portfolio.loanproduct.exception.LoanProductNotFoundException;
import org.apache.fineract.portfolio.loanproduct.productmix.data.ProductMixData;
import org.apache.fineract.portfolio.loanproduct.productmix.service.ProductMixReadPlatformService;
import org.apache.fineract.portfolio.loanproduct.service.LoanDropdownReadPlatformService;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.apache.fineract.portfolio.paymenttype.service.PaymentTypeReadPlatformService;
import org.apache.fineract.portfolio.rate.service.RateReadService;
import org.springframework.stereotype.Component;

@Path(value="/v1/loanproducts")
@Component
@Tag(name="Loan Products", description="A Loan product is a template that is used when creating a loan. Much of the template definition can be overridden during loan creation.")
public class LoanProductsApiResource {
    private static final Set<String> LOAN_PRODUCT_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "name", "shortName", "description", "fundId", "fundName", "includeInBorrowerCycle", "currency", "principal", "minPrincipal", "maxPrincipal", "numberOfRepayments", "minNumberOfRepayments", "maxNumberOfRepayments", "repaymentEvery", "repaymentFrequencyType", "graceOnPrincipalPayment", "recurringMoratoriumOnPrincipalPeriods", "graceOnInterestPayment", "graceOnInterestCharged", "interestRatePerPeriod", "minInterestRatePerPeriod", "maxInterestRatePerPeriod", "interestRateFrequencyType", "annualInterestRate", "amortizationType", "interestType", "interestCalculationPeriodType", "allowPartialPeriodInterestCalcualtion", "inArrearsTolerance", "transactionProcessingStrategyCode", "transactionProcessingStrategyName", "charges", "accountingRule", "externalId", "accountingMappings", "paymentChannelToFundSourceMappings", "fundOptions", "paymentTypeOptions", "currencyOptions", "repaymentFrequencyTypeOptions", "interestRateFrequencyTypeOptions", "amortizationTypeOptions", "interestTypeOptions", "interestCalculationPeriodTypeOptions", "transactionProcessingStrategyOptions", "chargeOptions", "accountingOptions", "accountingRuleOptions", "accountingMappingOptions", "floatingRateOptions", "isLinkedToFloatingInterestRates", "floatingRatesId", "interestRateDifferential", "minDifferentialLendingRate", "defaultDifferentialLendingRate", "maxDifferentialLendingRate", "isFloatingInterestRateCalculationAllowed", "canUseForTopup", "isEqualAmortization", "rates", "fixedPrincipalPercentagePerInstallment", "dueDaysForRepaymentEvent", "overDueDaysForRepaymentEvent", "enableDownPayment", "disbursedAmountPercentageForDownPayment", "enableAutoRepaymentForDownPayment", "repaymentStartDateType", "daysInYearCustomStrategy", "enableIncomeCapitalization", "capitalizedIncomeCalculationType", "capitalizedIncomeStrategy", "capitalizedIncomeType", "enableBuyDownFee", "buyDownFeeCalculationType", "buyDownFeeStrategy", "buyDownFeeIncomeType"));
    private static final Set<String> PRODUCT_MIX_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("productId", "productName", "restrictedProducts", "allowedProducts", "productOptions"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "LOANPRODUCT";
    public static final String PRODUCTMIX = "PRODUCTMIX";
    public static final String PRODUCT_MIXES = "productMixes";
    private final PlatformSecurityContext context;
    private final LoanProductReadPlatformService loanProductReadPlatformService;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final CurrencyReadPlatformService currencyReadPlatformService;
    private final FundReadPlatformService fundReadPlatformService;
    private final DefaultToApiJsonSerializer<LoanProductData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final LoanDropdownReadPlatformService dropdownReadPlatformService;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ProductToGLAccountMappingReadPlatformService accountMappingReadPlatformService;
    private final AccountingDropdownReadPlatformService accountingDropdownReadPlatformService;
    private final DefaultToApiJsonSerializer<ProductMixData> productMixDataApiJsonSerializer;
    private final ProductMixReadPlatformService productMixReadPlatformService;
    private final DropdownReadPlatformService commonDropdownReadPlatformService;
    private final PaymentTypeReadPlatformService paymentTypeReadPlatformService;
    private final FloatingRatesReadPlatformService floatingRateReadPlatformService;
    private final RateReadService rateReadService;
    private final ConfigurationDomainService configurationDomainService;
    private final DelinquencyReadPlatformService delinquencyReadPlatformService;
    private final CodeValueReadPlatformService codeValueReadPlatformService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Loan Product", description="Depending of the Accounting Rule (accountingRule) selected, additional fields with details of the appropriate Ledger Account identifiers would need to be passed in.\n\nRefer MifosX Accounting Specs Draft for more details regarding the significance of the selected accounting rule\n\nMandatory Fields: name, shortName, currencyCode, digitsAfterDecimal, inMultiplesOf, principal, numberOfRepayments, repaymentEvery, repaymentFrequencyType, interestRatePerPeriod, interestRateFrequencyType, amortizationType, interestType, interestCalculationPeriodType, transactionProcessingStrategyCode, accountingRule, isInterestRecalculationEnabled, daysInYearType, daysInMonthType\n\nOptional Fields: inArrearsTolerance, graceOnPrincipalPayment, graceOnInterestPayment, graceOnInterestCharged, graceOnArrearsAgeing, charges, paymentChannelToFundSourceMappings, feeToIncomeAccountMappings, penaltyToIncomeAccountMappings, chargeOffReasonToExpenseAccountMappings, includeInBorrowerCycle, useBorrowerCycle,principalVariationsForBorrowerCycle, numberOfRepaymentVariationsForBorrowerCycle, interestRateVariationsForBorrowerCycle, multiDisburseLoan,maxTrancheCount, outstandingLoanBalance,overdueDaysForNPA,holdGuaranteeFunds, principalThresholdForLastInstalment, accountMovesOutOfNPAOnlyOnArrearsCompletion, canDefineInstallmentAmount, installmentAmountInMultiplesOf, allowAttributeOverrides, allowPartialPeriodInterestCalcualtion,dueDaysForRepaymentEvent,overDueDaysForRepaymentEvent,enableDownPayment,disbursedAmountPercentageDownPayment,enableAutoRepaymentForDownPayment,repaymentStartDateType,enableBuyDownFee\n\nAdditional Mandatory Fields for Cash(2) based accounting: fundSourceAccountId, loanPortfolioAccountId, interestOnLoanAccountId, incomeFromFeeAccountId, incomeFromPenaltyAccountId, writeOffAccountId, transfersInSuspenseAccountId, overpaymentLiabilityAccountId\n\nAdditional Mandatory Fields for periodic (3) and upfront (4)accrual accounting: fundSourceAccountId, loanPortfolioAccountId, interestOnLoanAccountId, incomeFromFeeAccountId, incomeFromPenaltyAccountId, writeOffAccountId, receivableInterestAccountId, receivableFeeAccountId, receivablePenaltyAccountId, transfersInSuspenseAccountId, overpaymentLiabilityAccountId\n\nAdditional Mandatory Fields if interest recalculation is enabled(true): interestRecalculationCompoundingMethod, rescheduleStrategyMethod, recalculationRestFrequencyType\n\nAdditional Optional Fields if interest recalculation is enabled(true): isArrearsBasedOnOriginalSchedule, preClosureInterestCalculationStrategy\n\nAdditional Optional Fields if interest recalculation is enabled(true) and recalculationRestFrequencyType is not same as repayment period: recalculationRestFrequencyInterval, recalculationRestFrequencyDate\n\nAdditional Optional Fields if interest recalculation is enabled(true) and interestRecalculationCompoundingMethod is enabled: recalculationCompoundingFrequencyType\n\nAdditional Optional Fields if interest recalculation is enabled(true) and interestRecalculationCompoundingMethod is enabled and recalculationCompoundingFrequencyType is not same as repayment period: recalculationCompoundingFrequencyInterval, recalculationCompoundingFrequencyDate\n\nAdditional Mandatory Fields if Hold Guarantee funds is enabled(true): mandatoryGuarantee\n\nAdditional Optional Fields if Hold Guarantee funds is enabled(true): minimumGuaranteeFromOwnFunds,minimumGuaranteeFromGuarantor")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanProductsApiResourceSwagger.PostLoanProductsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanProductsApiResourceSwagger.PostLoanProductsResponse.class))})})
    public String createLoanProduct(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createLoanProduct().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Loan Products", description="Lists Loan Products\n\nExample Requests:\n\nloanproducts\n\n\nloanproducts?fields=name,description,interestRateFrequencyType,amortizationType")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=LoanProductsApiResourceSwagger.GetLoanProductsResponse.class)))})})
    public String retrieveAllLoanProducts(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (!associationParameters.isEmpty() && associationParameters.contains(PRODUCT_MIXES)) {
            this.context.authenticatedUser().validateHasReadPermission(PRODUCTMIX);
            Collection productMixes = this.productMixReadPlatformService.retrieveAllProductMixes();
            return this.productMixDataApiJsonSerializer.serialize(settings, productMixes, PRODUCT_MIX_DATA_PARAMETERS);
        }
        Collection products = this.loanProductReadPlatformService.retrieveAllLoanProducts();
        return this.toApiJsonSerializer.serialize(settings, products, LOAN_PRODUCT_DATA_PARAMETERS);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Loan Product Details Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed description Lists\nExample Request:\n\nloanproducts/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanProductsApiResourceSwagger.GetLoanProductsTemplateResponse.class))})})
    public String retrieveTemplate(@Context UriInfo uriInfo, @QueryParam(value="isProductMixTemplate") @Parameter(description="isProductMixTemplate") boolean isProductMixTemplate) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (isProductMixTemplate) {
            this.context.authenticatedUser().validateHasReadPermission(PRODUCTMIX);
            Collection productOptions = this.loanProductReadPlatformService.retrieveAvailableLoanProductsForMix();
            ProductMixData productMixData = ProductMixData.template((Collection)productOptions);
            return this.productMixDataApiJsonSerializer.serialize(settings, (Object)productMixData, PRODUCT_MIX_DATA_PARAMETERS);
        }
        LoanProductData loanProduct = this.loanProductReadPlatformService.retrieveNewLoanProductDetails();
        loanProduct = this.handleTemplate(loanProduct);
        return this.toApiJsonSerializer.serialize(settings, (Object)loanProduct, LOAN_PRODUCT_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Loan Product", description="Retrieves a Loan Product\n\nExample Requests:\n\nloanproducts/1\n\n\nloanproducts/1?template=true\n\n\nloanproducts/1?fields=name,description,numberOfRepayments")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanProductsApiResourceSwagger.GetLoanProductsProductIdResponse.class))})})
    public String retrieveLoanProductDetails(@PathParam(value="productId") @Parameter(description="productId") Long productId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.getLoanProductDetails(productId, uriInfo);
    }

    @PUT
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Loan Product", description="Updates a Loan Product")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanProductsApiResourceSwagger.PutLoanProductsProductIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanProductsApiResourceSwagger.PutLoanProductsProductIdResponse.class))})})
    public String updateLoanProduct(@PathParam(value="productId") @Parameter(description="productId") Long productId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.getUpdateLoanProductResult(apiRequestBodyAsJson, productId);
    }

    @GET
    @Path(value="external-id/{externalProductId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Loan Product", description="Retrieves a Loan Product\n\nExample Requests:\n\nloanproducts/external-id/2075e308-d4a8-44d9-8203-f5a947b8c2f4\n\n\nloanproducts/external-id/2075e308-d4a8-44d9-8203-f5a947b8c2f4?template=true\n\n\nloanproducts/external-id/2075e308-d4a8-44d9-8203-f5a947b8c2f4?fields=name,description,numberOfRepayments")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanProductsApiResourceSwagger.GetLoanProductsProductIdResponse.class))})})
    public String retrieveLoanProductDetails(@PathParam(value="externalProductId") @Parameter(description="externalProductId") String externalProductId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ExternalId externalId = ExternalIdFactory.produce((String)externalProductId);
        Long productId = this.resolveProductId(externalId);
        if (Objects.isNull(productId)) {
            throw new LoanProductNotFoundException(externalId);
        }
        return this.getLoanProductDetails(productId, uriInfo);
    }

    @PUT
    @Path(value="external-id/{externalProductId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Loan Product", description="Updates a Loan Product")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanProductsApiResourceSwagger.PutLoanProductsProductIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanProductsApiResourceSwagger.PutLoanProductsProductIdResponse.class))})})
    public String updateLoanProduct(@PathParam(value="externalProductId") @Parameter(description="externalProductId") String externalProductId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        ExternalId externalId = ExternalIdFactory.produce((String)externalProductId);
        Long productId = this.resolveProductId(externalId);
        if (Objects.isNull(productId)) {
            throw new LoanProductNotFoundException(externalId);
        }
        return this.getUpdateLoanProductResult(apiRequestBodyAsJson, productId);
    }

    private String getUpdateLoanProductResult(String apiRequestBodyAsJson, Long productId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateLoanProduct(productId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private Long resolveProductId(ExternalId externalProductId) {
        return (Long)this.loanProductReadPlatformService.retrieveLoanProductByExternalId(externalProductId).getId();
    }

    private String getLoanProductDetails(Long productId, UriInfo uriInfo) {
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        LoanProductData loanProduct = this.loanProductReadPlatformService.retrieveLoanProduct(productId);
        if (loanProduct.hasAccountingEnabled()) {
            Map accountingMappings = this.accountMappingReadPlatformService.fetchAccountMappingDetailsForLoanProduct(productId, Integer.valueOf(((Long)loanProduct.getAccountingRule().getId()).intValue()));
            List paymentChannelToFundSourceMappings = this.accountMappingReadPlatformService.fetchPaymentTypeToFundSourceMappingsForLoanProduct(productId);
            List feeToGLAccountMappings = this.accountMappingReadPlatformService.fetchFeeToGLAccountMappingsForLoanProduct(productId);
            List penaltyToGLAccountMappings = this.accountMappingReadPlatformService.fetchPenaltyToIncomeAccountMappingsForLoanProduct(productId);
            List chargeOffReasonToGLAccountMappings = this.accountMappingReadPlatformService.fetchChargeOffReasonMappingsForLoanProduct(productId);
            loanProduct = LoanProductData.withAccountingDetails((LoanProductData)loanProduct, (Map)accountingMappings, (Collection)paymentChannelToFundSourceMappings, (Collection)feeToGLAccountMappings, (Collection)penaltyToGLAccountMappings, (List)chargeOffReasonToGLAccountMappings);
        }
        if (settings.isTemplate()) {
            loanProduct = this.handleTemplate(loanProduct);
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)loanProduct, LOAN_PRODUCT_DATA_PARAMETERS);
    }

    private LoanProductData handleTemplate(LoanProductData productData) {
        List delinquencyBucketOptions;
        List penaltyOptions;
        List chargeOptions = this.chargeReadPlatformService.retrieveLoanApplicableFees();
        if (chargeOptions.isEmpty()) {
            chargeOptions = null;
        }
        if ((penaltyOptions = this.chargeReadPlatformService.retrieveLoanApplicablePenalties()).isEmpty()) {
            penaltyOptions = null;
        }
        boolean isRatesEnabled = this.configurationDomainService.isSubRatesEnabled();
        List rateOptions = this.rateReadService.retrieveLoanApplicableRates();
        if (rateOptions.isEmpty()) {
            rateOptions = null;
        }
        List currencyOptions = this.currencyReadPlatformService.retrieveAllowedCurrencies();
        List amortizationTypeOptions = this.dropdownReadPlatformService.retrieveLoanAmortizationTypeOptions();
        List interestTypeOptions = this.dropdownReadPlatformService.retrieveLoanInterestTypeOptions();
        List interestCalculationPeriodTypeOptions = this.dropdownReadPlatformService.retrieveLoanInterestRateCalculatedInPeriodOptions();
        List repaymentFrequencyTypeOptions = this.dropdownReadPlatformService.retrieveRepaymentFrequencyTypeOptions();
        List interestRateFrequencyTypeOptions = this.dropdownReadPlatformService.retrieveInterestRateFrequencyTypeOptions();
        List paymentTypeOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        List fundOptions = this.fundReadPlatformService.retrieveAllFunds();
        if (fundOptions.isEmpty()) {
            fundOptions = null;
        }
        if ((delinquencyBucketOptions = this.delinquencyReadPlatformService.retrieveAllDelinquencyBuckets()).isEmpty()) {
            delinquencyBucketOptions = null;
        }
        Collection transactionProcessingStrategyOptions = this.dropdownReadPlatformService.retrieveTransactionProcessingStrategies();
        Map accountOptions = this.accountingDropdownReadPlatformService.retrieveAccountMappingOptionsForLoanProducts();
        List accountingRuleTypeOptions = this.accountingDropdownReadPlatformService.retrieveAccountingRuleTypeOptions();
        List loanCycleValueConditionTypeOptions = this.dropdownReadPlatformService.retrieveLoanCycleValueConditionTypeOptions();
        List daysInMonthTypeOptions = this.commonDropdownReadPlatformService.retrieveDaysInMonthTypeOptions();
        List daysInYearTypeOptions = this.commonDropdownReadPlatformService.retrieveDaysInYearTypeOptions();
        List interestRecalculationCompoundingTypeOptions = this.dropdownReadPlatformService.retrieveInterestRecalculationCompoundingTypeOptions();
        List rescheduleStrategyTypeOptions = this.dropdownReadPlatformService.retrieveRescheduleStrategyTypeOptions();
        List interestRecalculationFrequencyTypeOptions = this.dropdownReadPlatformService.retrieveInterestRecalculationFrequencyTypeOptions();
        List interestRecalculationNthDayTypeOptions = this.dropdownReadPlatformService.retrieveInterestRecalculationNthDayTypeOptions();
        List interestRecalculationDayOfWeekTypeOptions = this.dropdownReadPlatformService.retrieveInterestRecalculationDayOfWeekTypeOptions();
        List preCloseInterestCalculationStrategyOptions = this.dropdownReadPlatformService.retrievePreCloseInterestCalculationStrategyOptions();
        List floatingRateOptions = this.floatingRateReadPlatformService.retrieveLookupActive();
        List repaymentStartDateTypeOptions = this.dropdownReadPlatformService.retrieveRepaymentStartDateTypeOptions();
        List advancedPaymentAllocationTransactionTypes = PaymentAllocationTransactionType.getValuesAsEnumOptionDataList();
        List advancedPaymentAllocationFutureInstallmentAllocationRules = FutureInstallmentAllocationRule.getValuesAsEnumOptionDataList();
        List advancedPaymentAllocationTypes = PaymentAllocationType.getValuesAsEnumOptionDataList();
        List creditAllocationTransactionTypes = CreditAllocationTransactionType.getValuesAsEnumOptionDataList();
        List creditAllocationAllocationTypes = AllocationType.getValuesAsEnumOptionDataList();
        List supportedInterestRefundTypesOptions = ApiFacingEnum.getValuesAsStringEnumOptionDataList(LoanSupportedInterestRefundTypes.class);
        List chargeOffBehaviourOptions = ApiFacingEnum.getValuesAsStringEnumOptionDataList(LoanChargeOffBehaviour.class);
        List chargeOffReasonOptions = this.codeValueReadPlatformService.retrieveCodeValuesByCode("ChargeOffReasons");
        List daysInYearCustomStrategyOptions = ApiFacingEnum.getValuesAsStringEnumOptionDataList(DaysInYearCustomStrategyType.class);
        List capitalizedIncomeCalculationTypeOptions = ApiFacingEnum.getValuesAsStringEnumOptionDataList(LoanCapitalizedIncomeCalculationType.class);
        List capitalizedIncomeStrategyOptions = ApiFacingEnum.getValuesAsStringEnumOptionDataList(LoanCapitalizedIncomeStrategy.class);
        List capitalizedIncomeTypeOptions = ApiFacingEnum.getValuesAsStringEnumOptionDataList(LoanCapitalizedIncomeType.class);
        List buyDownFeeCalculationTypeOptions = ApiFacingEnum.getValuesAsStringEnumOptionDataList(LoanBuyDownFeeCalculationType.class);
        List buyDownFeeStrategyOptions = ApiFacingEnum.getValuesAsStringEnumOptionDataList(LoanBuyDownFeeStrategy.class);
        List buyDownFeeIncomeTypeOptions = ApiFacingEnum.getValuesAsStringEnumOptionDataList(LoanBuyDownFeeIncomeType.class);
        return new LoanProductData(productData, (Collection)chargeOptions, (Collection)penaltyOptions, (Collection)paymentTypeOptions, (Collection)currencyOptions, amortizationTypeOptions, interestTypeOptions, interestCalculationPeriodTypeOptions, repaymentFrequencyTypeOptions, interestRateFrequencyTypeOptions, (Collection)fundOptions, transactionProcessingStrategyOptions, (Collection)rateOptions, accountOptions, accountingRuleTypeOptions, loanCycleValueConditionTypeOptions, daysInMonthTypeOptions, daysInYearTypeOptions, interestRecalculationCompoundingTypeOptions, rescheduleStrategyTypeOptions, interestRecalculationFrequencyTypeOptions, preCloseInterestCalculationStrategyOptions, floatingRateOptions, interestRecalculationNthDayTypeOptions, interestRecalculationDayOfWeekTypeOptions, isRatesEnabled, (Collection)delinquencyBucketOptions, repaymentStartDateTypeOptions, advancedPaymentAllocationTransactionTypes, advancedPaymentAllocationFutureInstallmentAllocationRules, advancedPaymentAllocationTypes, LoanScheduleType.getValuesAsEnumOptionDataList(), LoanScheduleProcessingType.getValuesAsEnumOptionDataList(), creditAllocationTransactionTypes, creditAllocationAllocationTypes, supportedInterestRefundTypesOptions, chargeOffBehaviourOptions, chargeOffReasonOptions, daysInYearCustomStrategyOptions, capitalizedIncomeCalculationTypeOptions, capitalizedIncomeStrategyOptions, capitalizedIncomeTypeOptions, buyDownFeeCalculationTypeOptions, buyDownFeeStrategyOptions, buyDownFeeIncomeTypeOptions);
    }

    @Generated
    public LoanProductsApiResource(PlatformSecurityContext context, LoanProductReadPlatformService loanProductReadPlatformService, ChargeReadPlatformService chargeReadPlatformService, CurrencyReadPlatformService currencyReadPlatformService, FundReadPlatformService fundReadPlatformService, DefaultToApiJsonSerializer<LoanProductData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, LoanDropdownReadPlatformService dropdownReadPlatformService, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ProductToGLAccountMappingReadPlatformService accountMappingReadPlatformService, AccountingDropdownReadPlatformService accountingDropdownReadPlatformService, DefaultToApiJsonSerializer<ProductMixData> productMixDataApiJsonSerializer, ProductMixReadPlatformService productMixReadPlatformService, DropdownReadPlatformService commonDropdownReadPlatformService, PaymentTypeReadPlatformService paymentTypeReadPlatformService, FloatingRatesReadPlatformService floatingRateReadPlatformService, RateReadService rateReadService, ConfigurationDomainService configurationDomainService, DelinquencyReadPlatformService delinquencyReadPlatformService, CodeValueReadPlatformService codeValueReadPlatformService) {
        this.context = context;
        this.loanProductReadPlatformService = loanProductReadPlatformService;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.currencyReadPlatformService = currencyReadPlatformService;
        this.fundReadPlatformService = fundReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.dropdownReadPlatformService = dropdownReadPlatformService;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.accountMappingReadPlatformService = accountMappingReadPlatformService;
        this.accountingDropdownReadPlatformService = accountingDropdownReadPlatformService;
        this.productMixDataApiJsonSerializer = productMixDataApiJsonSerializer;
        this.productMixReadPlatformService = productMixReadPlatformService;
        this.commonDropdownReadPlatformService = commonDropdownReadPlatformService;
        this.paymentTypeReadPlatformService = paymentTypeReadPlatformService;
        this.floatingRateReadPlatformService = floatingRateReadPlatformService;
        this.rateReadService = rateReadService;
        this.configurationDomainService = configurationDomainService;
        this.delinquencyReadPlatformService = delinquencyReadPlatformService;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
    }
}

