/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.meeting.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.calendar.data.CalendarData;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.exception.CalendarEntityTypeNotSupportedException;
import org.apache.fineract.portfolio.calendar.service.CalendarReadPlatformService;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.meeting.api.MeetingsApiResource;
import org.apache.fineract.portfolio.meeting.attendance.service.AttendanceDropdownReadPlatformService;
import org.apache.fineract.portfolio.meeting.attendance.service.ClientAttendanceReadPlatformService;
import org.apache.fineract.portfolio.meeting.data.MeetingData;
import org.apache.fineract.portfolio.meeting.exception.MeetingNotSupportedResourceException;
import org.apache.fineract.portfolio.meeting.service.MeetingReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/{entityType}/{entityId}/meetings")
@Component
@Tag(name="Meetings", description="")
public class MeetingsApiResource {
    private final PlatformSecurityContext context;
    private final MeetingReadPlatformService readPlatformService;
    private final ClientAttendanceReadPlatformService attendanceReadPlatformService;
    private final ClientReadPlatformService clientReadPlatformService;
    private final CalendarReadPlatformService calendarReadPlatformService;
    private final AttendanceDropdownReadPlatformService attendanceDropdownReadPlatformService;
    private final DefaultToApiJsonSerializer<MeetingData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private static final Set<String> MEETING_RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "meetingDate", "clientsAttendance", "clients", "calendarData", "attendanceTypeOptions"));

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String template(@PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, @QueryParam(value="calendarId") Long calendarId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("meeting");
        Integer entityTypeId = CalendarEntityType.valueOf((String)entityType.toUpperCase()).getValue();
        Collection clients = null;
        CalendarData calendarData = null;
        if (CalendarEntityType.isGroup((String)entityType)) {
            clients = this.clientReadPlatformService.retrieveActiveClientMembersOfGroup(entityId);
        } else if (CalendarEntityType.isCenter((String)entityType)) {
            clients = this.clientReadPlatformService.retrieveActiveClientMembersOfCenter(entityId);
        } else {
            String defaultUserMessage = "Meeting attendance is not supported for the resource " + entityType + ". The supported resources are [" + CalendarEntityType.GROUPS.name() + ", " + CalendarEntityType.CENTERS.name() + "]";
            throw new MeetingNotSupportedResourceException(defaultUserMessage, new Object[]{CalendarEntityType.GROUPS.name(), CalendarEntityType.CENTERS.name()});
        }
        if (calendarId != null) {
            calendarData = this.calendarReadPlatformService.retrieveCalendar(calendarId, entityId, entityTypeId);
            boolean withHistory = true;
            Collection recurringDates = this.calendarReadPlatformService.generateRecurringDates(calendarData, true, DateUtils.getBusinessLocalDate());
            Collection nextTenRecurringDates = this.calendarReadPlatformService.generateNextTenRecurringDates(calendarData);
            LocalDate recentEligibleMeetingDate = null;
            calendarData = CalendarData.withRecurringDates((CalendarData)calendarData, (Collection)recurringDates, (Collection)nextTenRecurringDates, recentEligibleMeetingDate);
        }
        MeetingData meetingData = MeetingData.template((Collection)clients, calendarData, (List)this.attendanceDropdownReadPlatformService.retrieveAttendanceTypeOptions());
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)meetingData, MEETING_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveMeetings(@PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, @QueryParam(value="limit") Integer limit, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("meeting");
        Collection meetingsData = this.readPlatformService.retrieveMeetingsByEntity(entityId, CalendarEntityType.valueOf((String)entityType.toUpperCase()).getValue(), limit);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, meetingsData, MEETING_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{meetingId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveMeeting(@PathParam(value="meetingId") Long meetingId, @PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("meeting");
        Integer entityTypeId = CalendarEntityType.valueOf((String)entityType.toUpperCase()).getValue();
        MeetingData meetingData = this.readPlatformService.retrieveMeeting(meetingId, entityId, entityTypeId);
        Collection clientsAttendance = this.attendanceReadPlatformService.retrieveClientAttendanceByMeetingId(meetingId);
        meetingData = MeetingData.withClientsAttendanceAndAttendanceTypeOptions((MeetingData)meetingData, (Collection)clientsAttendance, (List)this.attendanceDropdownReadPlatformService.retrieveAttendanceTypeOptions());
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)meetingData, MEETING_RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String createMeeting(@PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, String apiRequestBodyAsJson) {
        CalendarEntityType calendarEntityType = CalendarEntityType.getEntityType((String)entityType);
        if (calendarEntityType == null) {
            throw new CalendarEntityTypeNotSupportedException(entityType);
        }
        CommandWrapper resourceDetails = this.getResourceDetails(calendarEntityType, entityId);
        CommandWrapper commandRequest = new CommandWrapperBuilder().createMeeting(resourceDetails, entityType, entityId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{meetingId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String performMeetingCommands(@PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, @PathParam(value="meetingId") Long meetingId, @QueryParam(value="command") String commandParam, String apiRequestBodyAsJson) {
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        CommandProcessingResult result = null;
        if (!this.is(commandParam, "saveOrUpdateAttendance")) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"saveOrUpdateAttendance"});
        }
        CommandWrapper commandRequest = builder.saveOrUpdateAttendance(meetingId, entityType, entityId).build();
        result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{meetingId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String updateMeeting(@PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, @PathParam(value="meetingId") Long meetingId, String jsonRequestBody) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateMeeting(entityType, entityId, meetingId).withJson(jsonRequestBody).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{meetingId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String deleteMeeting(@PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, @PathParam(value="meetingId") Long meetingId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteMeeting(entityType, entityId, meetingId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    private CommandWrapper getResourceDetails(CalendarEntityType type, Long entityId) {
        CommandWrapperBuilder resourceDetails = new CommandWrapperBuilder();
        switch (1.$SwitchMap$org$apache$fineract$portfolio$calendar$domain$CalendarEntityType[type.ordinal()]) {
            case 1: {
                resourceDetails.withGroupId(entityId);
                break;
            }
            case 2: {
                resourceDetails.withClientId(entityId);
                break;
            }
            case 3: {
                resourceDetails.withGroupId(entityId);
                break;
            }
            case 4: {
                resourceDetails.withLoanId(entityId);
                break;
            }
            case 5: {
                resourceDetails.withSavingsId(entityId);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
        }
        return resourceDetails.build();
    }

    @Generated
    public MeetingsApiResource(PlatformSecurityContext context, MeetingReadPlatformService readPlatformService, ClientAttendanceReadPlatformService attendanceReadPlatformService, ClientReadPlatformService clientReadPlatformService, CalendarReadPlatformService calendarReadPlatformService, AttendanceDropdownReadPlatformService attendanceDropdownReadPlatformService, DefaultToApiJsonSerializer<MeetingData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.attendanceReadPlatformService = attendanceReadPlatformService;
        this.clientReadPlatformService = clientReadPlatformService;
        this.calendarReadPlatformService = calendarReadPlatformService;
        this.attendanceDropdownReadPlatformService = attendanceDropdownReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

