/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.jobs.generaterdschedule;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.database.RoutingDataSourceServiceFactory;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.savings.DepositAccountUtils;
import org.apache.fineract.portfolio.savings.service.DepositAccountReadPlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.jdbc.core.JdbcTemplate;

public class GenerateRdScheduleTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenerateRdScheduleTasklet.class);
    private final RoutingDataSourceServiceFactory dataSourceServiceFactory;
    private final DepositAccountReadPlatformService depositAccountReadPlatformService;
    private final PlatformSecurityContext securityContext;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSourceServiceFactory.determineDataSourceService().retrieveDataSource());
        Collection scheduleDetails = this.depositAccountReadPlatformService.retriveDataForRDScheduleCreation();
        String insertSql = "INSERT INTO m_mandatory_savings_schedule (savings_account_id, duedate, installment, deposit_amount, completed_derived, created_on_utc, created_by, last_modified_on_utc, last_modified_by) VALUES (?, ?, ?, ?, ?, ?, ?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Long userId = (Long)this.securityContext.authenticatedUser().getId();
        int iterations = 0;
        for (Map details : scheduleDetails) {
            Long count = (Long)details.get("futureInstallments");
            if (count == null) {
                count = 0L;
            }
            Long savingsId = (Long)details.get("savingsId");
            BigDecimal amount = (BigDecimal)details.get("amount");
            String recurrence = (String)details.get("recurrence");
            LocalDate lastDepositDate = (LocalDate)details.get("dueDate");
            Integer installmentNumber = (Integer)details.get("installment");
            while (count < 5L) {
                Number number = count;
                count = count + 1L;
                number = installmentNumber;
                installmentNumber = installmentNumber + 1;
                lastDepositDate = DepositAccountUtils.calculateNextDepositDate((LocalDate)lastDepositDate, (String)recurrence);
                OffsetDateTime auditTime = DateUtils.getAuditOffsetDateTime();
                params.add(new Object[]{savingsId, lastDepositDate, installmentNumber, amount, false, auditTime, userId, auditTime, userId});
                ++iterations;
            }
            if (iterations <= 200) continue;
            jdbcTemplate.batchUpdate(insertSql, params);
            params.clear();
            iterations = 0;
        }
        if (!params.isEmpty()) {
            jdbcTemplate.batchUpdate(insertSql, params);
        }
        return RepeatStatus.FINISHED;
    }

    @Generated
    public GenerateRdScheduleTasklet(RoutingDataSourceServiceFactory dataSourceServiceFactory, DepositAccountReadPlatformService depositAccountReadPlatformService, PlatformSecurityContext securityContext) {
        this.dataSourceServiceFactory = dataSourceServiceFactory;
        this.depositAccountReadPlatformService = depositAccountReadPlatformService;
        this.securityContext = securityContext;
    }
}

