/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.pockets.service;

import lombok.Generated;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.loanaccount.exception.LoanNotFoundException;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.apache.fineract.portfolio.self.loanaccount.service.AppuserLoansMapperReadService;
import org.apache.fineract.portfolio.self.pockets.service.AccountEntityService;

public class AccountEntityServiceForLoanImpl
implements AccountEntityService {
    private static final String KEY = EntityAccountType.LOAN.name();
    private final PlatformSecurityContext context;
    private final AppuserLoansMapperReadService appuserLoansMapperReadService;
    private final LoanReadPlatformService loanReadPlatformService;

    public String getKey() {
        return KEY;
    }

    public void validateSelfUserAccountMapping(Long accountId) {
        if (!this.appuserLoansMapperReadService.isLoanMappedToUser(accountId, (Long)this.context.authenticatedUser().getId()).booleanValue()) {
            throw new LoanNotFoundException(accountId);
        }
    }

    public String retrieveAccountNumberByAccountId(Long accountId) {
        return this.loanReadPlatformService.retrieveAccountNumberByAccountId(accountId);
    }

    @Generated
    public AccountEntityServiceForLoanImpl(PlatformSecurityContext context, AppuserLoansMapperReadService appuserLoansMapperReadService, LoanReadPlatformService loanReadPlatformService) {
        this.context = context;
        this.appuserLoansMapperReadService = appuserLoansMapperReadService;
        this.loanReadPlatformService = loanReadPlatformService;
    }
}

