/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.spm.starter;

import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.spm.domain.LookupTableRepository;
import org.apache.fineract.spm.domain.ScorecardRepository;
import org.apache.fineract.spm.domain.SurveyRepository;
import org.apache.fineract.spm.domain.SurveyValidator;
import org.apache.fineract.spm.service.LookupTableService;
import org.apache.fineract.spm.service.ScorecardReadPlatformService;
import org.apache.fineract.spm.service.ScorecardReadPlatformServiceImpl;
import org.apache.fineract.spm.service.ScorecardService;
import org.apache.fineract.spm.service.SpmService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class SpmConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={LookupTableService.class})
    public LookupTableService lookupTableService(PlatformSecurityContext securityContext, LookupTableRepository lookupTableRepository) {
        return new LookupTableService(securityContext, lookupTableRepository);
    }

    @Bean
    @ConditionalOnMissingBean(value={ScorecardReadPlatformService.class})
    public ScorecardReadPlatformService scorecardReadPlatformService(JdbcTemplate jdbcTemplate, PlatformSecurityContext context) {
        return new ScorecardReadPlatformServiceImpl(jdbcTemplate, context);
    }

    @Bean
    @ConditionalOnMissingBean(value={ScorecardService.class})
    public ScorecardService scorecardService(PlatformSecurityContext securityContext, ScorecardRepository scorecardRepository) {
        return new ScorecardService(securityContext, scorecardRepository);
    }

    @Bean
    @ConditionalOnMissingBean(value={SpmService.class})
    public SpmService spmService(PlatformSecurityContext securityContext, SurveyRepository surveyRepository, SurveyValidator surveyValidator) {
        return new SpmService(securityContext, surveyRepository, surveyValidator);
    }
}

