/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0-SNAPSHOT
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * ChargeFeeOnMonthDay
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class ChargeFeeOnMonthDay {
  public static final String SERIALIZED_NAME_DAY_OF_MONTH = "dayOfMonth";
  @SerializedName(SERIALIZED_NAME_DAY_OF_MONTH)
  private Integer dayOfMonth;

  /**
   * Gets or Sets month
   */
  @JsonAdapter(MonthEnum.Adapter.class)
  public enum MonthEnum {
    JANUARY("JANUARY"),
    
    FEBRUARY("FEBRUARY"),
    
    MARCH("MARCH"),
    
    APRIL("APRIL"),
    
    MAY("MAY"),
    
    JUNE("JUNE"),
    
    JULY("JULY"),
    
    AUGUST("AUGUST"),
    
    SEPTEMBER("SEPTEMBER"),
    
    OCTOBER("OCTOBER"),
    
    NOVEMBER("NOVEMBER"),
    
    DECEMBER("DECEMBER");

    private String value;

    MonthEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static MonthEnum fromValue(String value) {
      for (MonthEnum b : MonthEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<MonthEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final MonthEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public MonthEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return MonthEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_MONTH = "month";
  @SerializedName(SERIALIZED_NAME_MONTH)
  private MonthEnum month;

  public static final String SERIALIZED_NAME_MONTH_VALUE = "monthValue";
  @SerializedName(SERIALIZED_NAME_MONTH_VALUE)
  private Integer monthValue;

  public ChargeFeeOnMonthDay() {
  }

  public ChargeFeeOnMonthDay dayOfMonth(Integer dayOfMonth) {
    
    this.dayOfMonth = dayOfMonth;
    return this;
  }

  /**
   * Get dayOfMonth
   * @return dayOfMonth
   */
  @javax.annotation.Nullable

  public Integer getDayOfMonth() {
    return dayOfMonth;
  }


  public void setDayOfMonth(Integer dayOfMonth) {
    this.dayOfMonth = dayOfMonth;
  }

  public ChargeFeeOnMonthDay month(MonthEnum month) {
    
    this.month = month;
    return this;
  }

  /**
   * Get month
   * @return month
   */
  @javax.annotation.Nullable

  public MonthEnum getMonth() {
    return month;
  }


  public void setMonth(MonthEnum month) {
    this.month = month;
  }

  public ChargeFeeOnMonthDay monthValue(Integer monthValue) {
    
    this.monthValue = monthValue;
    return this;
  }

  /**
   * Get monthValue
   * @return monthValue
   */
  @javax.annotation.Nullable

  public Integer getMonthValue() {
    return monthValue;
  }


  public void setMonthValue(Integer monthValue) {
    this.monthValue = monthValue;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChargeFeeOnMonthDay chargeFeeOnMonthDay = (ChargeFeeOnMonthDay) o;
    return Objects.equals(this.dayOfMonth, chargeFeeOnMonthDay.dayOfMonth) &&
        Objects.equals(this.month, chargeFeeOnMonthDay.month) &&
        Objects.equals(this.monthValue, chargeFeeOnMonthDay.monthValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dayOfMonth, month, monthValue);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChargeFeeOnMonthDay {\n");
    sb.append("    dayOfMonth: ").append(toIndentedString(dayOfMonth)).append("\n");
    sb.append("    month: ").append(toIndentedString(month)).append("\n");
    sb.append("    monthValue: ").append(toIndentedString(monthValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

