/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.fineract.client.services;

import java.util.List;
import okhttp3.ResponseBody;
import org.apache.fineract.client.models.DeleteEntityTypeEntityIdDocumentsResponse;
import org.apache.fineract.client.models.DocumentData;
import org.apache.fineract.client.models.PostEntityTypeEntityIdDocumentsResponse;
import org.apache.fineract.client.models.PutEntityTypeEntityIdDocumentsResponse;
import retrofit2.Call;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;

// This class was originally generated by OpenAPI Generator (https://openapi-generator.tech),
// but then had to be manually edited by Michael Vorburger.ch to manually fix https://issues.apache.org/jira/browse/FINERACT-1227.
// If we could fix our OpenAPI / Swagger YAML generation from the JAX RS and OpenAPI annotation to have the correct notation for binary document files and images, then this could be removed again.
public interface DocumentsApiFixed {

    /**
     * Create a Document Note: A document is created using a Multi-part form upload Body Parts name : Name or summary of
     * the document description : Description of the document file : The file to be uploaded Mandatory Fields : file and
     * description
     *
     * @param entityType
     *            entityType (required)
     * @param entityId
     *            entityId (required)
     * @param file
     *            (required)
     * @param name
     *            name (optional)
     * @param description
     *            description (optional)
     * @return Call&lt;PostEntityTypeEntityIdDocumentsResponse&gt;
     */
    @retrofit2.http.Multipart
    @POST("v1/{entityType}/{entityId}/documents")
    Call<PostEntityTypeEntityIdDocumentsResponse> createDocument(@retrofit2.http.Path("entityType") String entityType,
            @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Part okhttp3.MultipartBody.Part file,
            @retrofit2.http.Part("name") String name, @retrofit2.http.Part("description") String description);

    /**
     * Remove a Document
     *
     * @param entityType
     *            entityType (required)
     * @param entityId
     *            entityId (required)
     * @param documentId
     *            documentId (required)
     * @return Call&lt;DeleteEntityTypeEntityIdDocumentsResponse&gt;
     */
    @DELETE("v1/{entityType}/{entityId}/documents/{documentId}")
    Call<DeleteEntityTypeEntityIdDocumentsResponse> deleteDocument(@retrofit2.http.Path("entityType") String entityType,
            @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Path("documentId") Long documentId);

    /**
     * Retrieve Binary File associated with Document Request used to download the file associated with the document
     * Example Requests: clients/1/documents/1/attachment loans/1/documents/1/attachment
     *
     * @param entityType
     *            entityType (required)
     * @param entityId
     *            entityId (required)
     * @param documentId
     *            documentId (required)
     * @return Call&lt;Void&gt;
     */
    @GET("v1/{entityType}/{entityId}/documents/{documentId}/attachment")
    Call<ResponseBody> downloadFile(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId,
            @retrofit2.http.Path("documentId") Long documentId);

    /**
     * Retrieve a Document Example Requests: clients/1/documents/1 loans/1/documents/1
     * client_identifiers/1/documents/1?fields&#x3D;name,description
     *
     * @param entityType
     *            entityType (required)
     * @param entityId
     *            entityId (required)
     * @param documentId
     *            documentId (required)
     * @return Call&lt;GetEntityTypeEntityIdDocumentsResponse&gt;
     */
    @GET("v1/{entityType}/{entityId}/documents/{documentId}")
    Call<DocumentData> getDocument(@retrofit2.http.Path("entityType") String entityType, @retrofit2.http.Path("entityId") Long entityId,
            @retrofit2.http.Path("documentId") Long documentId);

    /**
     * List documents Example Requests: clients/1/documents client_identifiers/1/documents
     * loans/1/documents?fields&#x3D;name,description
     *
     * @param entityType
     *            entityType (required)
     * @param entityId
     *            entityId (required)
     * @return Call&lt;List&lt;GetEntityTypeEntityIdDocumentsResponse&gt;&gt;
     */
    @GET("v1/{entityType}/{entityId}/documents")
    Call<List<DocumentData>> retrieveAllDocuments(@retrofit2.http.Path("entityType") String entityType,
            @retrofit2.http.Path("entityId") Long entityId);

    /**
     * Update a Document Note: A document is updated using a Multi-part form upload Body Parts name Name or summary of
     * the document description Description of the document file The file to be uploaded
     *
     * @param entityType
     *            entityType (required)
     * @param entityId
     *            entityId (required)
     * @param documentId
     *            documentId (required)
     * @param file
     *            (optional)
     * @param name
     *            name (optional)
     * @param description
     *            description (optional)
     * @return Call&lt;PutEntityTypeEntityIdDocumentsResponse&gt;
     */
    @retrofit2.http.Multipart
    @PUT("v1/{entityType}/{entityId}/documents/{documentId}")
    Call<PutEntityTypeEntityIdDocumentsResponse> updateDocument(@retrofit2.http.Path("entityType") String entityType,
            @retrofit2.http.Path("entityId") Long entityId, @retrofit2.http.Path("documentId") Long documentId,
            @retrofit2.http.Part okhttp3.MultipartBody.Part file, @retrofit2.http.Part("name") String name,
            @retrofit2.http.Part("description") String description);

}
