package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.DeleteLoansLoanIdChargesChargeIdResponse;
import org.apache.fineract.client.models.GetLoansLoanIdChargesChargeIdResponse;
import org.apache.fineract.client.models.GetLoansLoanIdChargesTemplateResponse;
import org.apache.fineract.client.models.PostLoansLoanIdChargesChargeIdRequest;
import org.apache.fineract.client.models.PostLoansLoanIdChargesChargeIdResponse;
import org.apache.fineract.client.models.PostLoansLoanIdChargesRequest;
import org.apache.fineract.client.models.PostLoansLoanIdChargesResponse;
import org.apache.fineract.client.models.PutLoansLoanIdChargesChargeIdRequest;
import org.apache.fineract.client.models.PutLoansLoanIdChargesChargeIdResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface LoanChargesApi {
    /**
    * Delete a Loan Charge
    * Note: Currently, A Loan Charge may only be removed from Loans that are not yet approved.
        * @param loanId loanId (required)
        * @param loanChargeId loanChargeId (required)
    * @return Call&lt;DeleteLoansLoanIdChargesChargeIdResponse&gt;
    */
    @DELETE("v1/loans/{loanId}/charges/{loanChargeId}")
    Call<DeleteLoansLoanIdChargesChargeIdResponse> deleteLoanCharge(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeId") Long loanChargeId);

    /**
    * Delete a Loan Charge
    * Note: Currently, A Loan Charge may only be removed from Loans that are not yet approved.
        * @param loanId loanId (required)
        * @param loanChargeExternalId loanChargeExternalId (required)
    * @return Call&lt;DeleteLoansLoanIdChargesChargeIdResponse&gt;
    */
    @DELETE("v1/loans/{loanId}/charges/external-id/{loanChargeExternalId}")
    Call<DeleteLoansLoanIdChargesChargeIdResponse> deleteLoanCharge1(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId);

    /**
    * Delete a Loan Charge
    * Note: Currently, A Loan Charge may only be removed from Loans that are not yet approved.
        * @param loanExternalId loanExternalId (required)
        * @param loanChargeId loanChargeId (required)
    * @return Call&lt;DeleteLoansLoanIdChargesChargeIdResponse&gt;
    */
    @DELETE("v1/loans/external-id/{loanExternalId}/charges/{loanChargeId}")
    Call<DeleteLoansLoanIdChargesChargeIdResponse> deleteLoanCharge2(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeId") Long loanChargeId);

    /**
    * Delete a Loan Charge
    * Note: Currently, A Loan Charge may only be removed from Loans that are not yet approved.
        * @param loanExternalId loanExternalId (required)
        * @param loanChargeExternalId loanChargeExternalId (required)
    * @return Call&lt;DeleteLoansLoanIdChargesChargeIdResponse&gt;
    */
    @DELETE("v1/loans/external-id/{loanExternalId}/charges/external-id/{loanChargeExternalId}")
    Call<DeleteLoansLoanIdChargesChargeIdResponse> deleteLoanCharge3(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId);

    /**
    * Create a Loan Charge (no command provided) or Pay a charge (command&#x3D;pay)
    * Creates a Loan Charge | Pay a Loan Charge
        * @param loanId loanId (required)
        * @param postLoansLoanIdChargesRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostLoansLoanIdChargesResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/{loanId}/charges")
    Call<PostLoansLoanIdChargesResponse> executeLoanCharge(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PostLoansLoanIdChargesRequest postLoansLoanIdChargesRequest, @retrofit2.http.Query("command") String command);

    /**
    * Create a Loan Charge (no command provided) or Pay a charge (command&#x3D;pay)
    * Creates a Loan Charge | Pay a Loan Charge
        * @param loanExternalId loanExternalId (required)
        * @param postLoansLoanIdChargesRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostLoansLoanIdChargesResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/external-id/{loanExternalId}/charges")
    Call<PostLoansLoanIdChargesResponse> executeLoanCharge1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PostLoansLoanIdChargesRequest postLoansLoanIdChargesRequest, @retrofit2.http.Query("command") String command);

    /**
    * Pay / Waive / Adjustment for Loan Charge
    * Loan Charge will be paid if the loan is linked with a savings account | Waive Loan Charge | Add Charge Adjustment
        * @param loanId loanId (required)
        * @param loanChargeId loanChargeId (required)
        * @param postLoansLoanIdChargesChargeIdRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostLoansLoanIdChargesChargeIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/{loanId}/charges/{loanChargeId}")
    Call<PostLoansLoanIdChargesChargeIdResponse> executeLoanCharge2(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeId") Long loanChargeId, @retrofit2.http.Body PostLoansLoanIdChargesChargeIdRequest postLoansLoanIdChargesChargeIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * Pay / Waive / Adjustment for Loan Charge
    * Loan Charge will be paid if the loan is linked with a savings account | Waive Loan Charge | Add Charge Adjustment
        * @param loanId loanId (required)
        * @param loanChargeExternalId loanChargeExternalId (required)
        * @param postLoansLoanIdChargesChargeIdRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostLoansLoanIdChargesChargeIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/{loanId}/charges/external-id/{loanChargeExternalId}")
    Call<PostLoansLoanIdChargesChargeIdResponse> executeLoanCharge3(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId, @retrofit2.http.Body PostLoansLoanIdChargesChargeIdRequest postLoansLoanIdChargesChargeIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * Pay / Waive / Adjustment for Loan Charge
    * Loan Charge will be paid if the loan is linked with a savings account | Waive Loan Charge | Add Charge Adjustment
        * @param loanExternalId loanExternalId (required)
        * @param loanChargeId loanChargeId (required)
        * @param postLoansLoanIdChargesChargeIdRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostLoansLoanIdChargesChargeIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/external-id/{loanExternalId}/charges/{loanChargeId}")
    Call<PostLoansLoanIdChargesChargeIdResponse> executeLoanCharge4(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeId") Long loanChargeId, @retrofit2.http.Body PostLoansLoanIdChargesChargeIdRequest postLoansLoanIdChargesChargeIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * Pay / Waive / Adjustment for Loan Charge
    * Loan Charge will be paid if the loan is linked with a savings account | Waive Loan Charge | Add Charge Adjustment
        * @param loanExternalId loanExternalId (required)
        * @param loanChargeExternalId loanChargeExternalId (required)
        * @param postLoansLoanIdChargesChargeIdRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostLoansLoanIdChargesChargeIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/external-id/{loanExternalId}/charges/external-id/{loanChargeExternalId}")
    Call<PostLoansLoanIdChargesChargeIdResponse> executeLoanCharge5(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId, @retrofit2.http.Body PostLoansLoanIdChargesChargeIdRequest postLoansLoanIdChargesChargeIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * List Loan Charges
    * It lists all the Loan Charges specific to a Loan   Example Requests:  loans/1/charges   loans/1/charges?fields&#x3D;name,amountOrPercentage
        * @param loanId loanId (required)
    * @return Call&lt;List&lt;GetLoansLoanIdChargesChargeIdResponse&gt;&gt;
    */
    @GET("v1/loans/{loanId}/charges")
    Call<List<GetLoansLoanIdChargesChargeIdResponse>> retrieveAllLoanCharges(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * List Loan Charges
    * It lists all the Loan Charges specific to a Loan   Example Requests:  loans/1/charges   loans/1/charges?fields&#x3D;name,amountOrPercentage
        * @param loanExternalId loanExternalId (required)
    * @return Call&lt;List&lt;GetLoansLoanIdChargesChargeIdResponse&gt;&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/charges")
    Call<List<GetLoansLoanIdChargesChargeIdResponse>> retrieveAllLoanCharges1(@retrofit2.http.Path("loanExternalId") String loanExternalId);

    /**
    * Retrieve a Loan Charge
    * Retrieves Loan Charge according to the Loan ID and Loan Charge IDExample Requests:  /loans/1/charges/1   /loans/1/charges/1?fields&#x3D;name,amountOrPercentage
        * @param loanId loanId (required)
        * @param loanChargeId loanChargeId (required)
    * @return Call&lt;GetLoansLoanIdChargesChargeIdResponse&gt;
    */
    @GET("v1/loans/{loanId}/charges/{loanChargeId}")
    Call<GetLoansLoanIdChargesChargeIdResponse> retrieveLoanCharge(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeId") Long loanChargeId);

    /**
    * Retrieve a Loan Charge
    * Retrieves Loan Charge according to the Loan ID and Loan Charge External IDExample Requests:  /loans/1/charges/1   /loans/1/charges/external-id/1?fields&#x3D;name,amountOrPercentage
        * @param loanId loanId (required)
        * @param loanChargeExternalId loanChargeExternalId (required)
    * @return Call&lt;GetLoansLoanIdChargesChargeIdResponse&gt;
    */
    @GET("v1/loans/{loanId}/charges/external-id/{loanChargeExternalId}")
    Call<GetLoansLoanIdChargesChargeIdResponse> retrieveLoanCharge1(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId);

    /**
    * Retrieve a Loan Charge
    * Retrieves Loan Charge according to the Loan external ID and Loan Charge IDExample Requests:  /loans/1/charges/1   /loans/1/charges/1?fields&#x3D;name,amountOrPercentage
        * @param loanExternalId loanExternalId (required)
        * @param loanChargeId loanChargeId (required)
    * @return Call&lt;GetLoansLoanIdChargesChargeIdResponse&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/charges/{loanChargeId}")
    Call<GetLoansLoanIdChargesChargeIdResponse> retrieveLoanCharge2(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeId") Long loanChargeId);

    /**
    * Retrieve a Loan Charge
    * Retrieves Loan Charge according to the Loan External ID and Loan Charge External IDExample Requests:  /loans/1/charges/1   /loans/1/charges/1?fields&#x3D;name,amountOrPercentage
        * @param loanExternalId loanExternalId (required)
        * @param loanChargeExternalId loanChargeExternalId (required)
    * @return Call&lt;GetLoansLoanIdChargesChargeIdResponse&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/charges/external-id/{loanChargeExternalId}")
    Call<GetLoansLoanIdChargesChargeIdResponse> retrieveLoanCharge3(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId);

    /**
    * Retrieve Loan Charges Template
    * This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:  Field Defaults Allowed description Lists Example Request:  loans/1/charges/template  
        * @param loanId loanId (required)
    * @return Call&lt;GetLoansLoanIdChargesTemplateResponse&gt;
    */
    @GET("v1/loans/{loanId}/charges/template")
    Call<GetLoansLoanIdChargesTemplateResponse> retrieveTemplate8(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * Retrieve Loan Charges Template
    * This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:  Field Defaults Allowed description Lists Example Request:  loans/1/charges/template  
        * @param loanExternalId loanExternalId (required)
    * @return Call&lt;GetLoansLoanIdChargesTemplateResponse&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/charges/template")
    Call<GetLoansLoanIdChargesTemplateResponse> retrieveTemplate9(@retrofit2.http.Path("loanExternalId") String loanExternalId);

    /**
    * Update a Loan Charge
    * Currently Loan Charges may be updated only if the Loan is not yet approved
        * @param loanId loanId (required)
        * @param loanChargeId loanChargeId (required)
        * @param putLoansLoanIdChargesChargeIdRequest  (required)
    * @return Call&lt;PutLoansLoanIdChargesChargeIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/{loanId}/charges/{loanChargeId}")
    Call<PutLoansLoanIdChargesChargeIdResponse> updateLoanCharge(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeId") Long loanChargeId, @retrofit2.http.Body PutLoansLoanIdChargesChargeIdRequest putLoansLoanIdChargesChargeIdRequest);

    /**
    * Update a Loan Charge
    * Currently Loan Charges may be updated only if the Loan is not yet approved
        * @param loanId loanId (required)
        * @param loanChargeExternalId loanChargeExternalId (required)
        * @param putLoansLoanIdChargesChargeIdRequest  (required)
    * @return Call&lt;PutLoansLoanIdChargesChargeIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/{loanId}/charges/external-id/{loanChargeExternalId}")
    Call<PutLoansLoanIdChargesChargeIdResponse> updateLoanCharge1(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId, @retrofit2.http.Body PutLoansLoanIdChargesChargeIdRequest putLoansLoanIdChargesChargeIdRequest);

    /**
    * Update a Loan Charge
    * Currently Loan Charges may be updated only if the Loan is not yet approved
        * @param loanExternalId loanExternalId (required)
        * @param loanChargeId loanChargeId (required)
        * @param putLoansLoanIdChargesChargeIdRequest  (required)
    * @return Call&lt;PutLoansLoanIdChargesChargeIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/external-id/{loanExternalId}/charges/{loanChargeId}")
    Call<PutLoansLoanIdChargesChargeIdResponse> updateLoanCharge2(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeId") Long loanChargeId, @retrofit2.http.Body PutLoansLoanIdChargesChargeIdRequest putLoansLoanIdChargesChargeIdRequest);

    /**
    * Update a Loan Charge
    * Currently Loan Charges may be updated only if the Loan is not yet approved
        * @param loanExternalId loanExternalId (required)
        * @param loanChargeExternalId loanChargeExternalId (required)
        * @param putLoansLoanIdChargesChargeIdRequest  (required)
    * @return Call&lt;PutLoansLoanIdChargesChargeIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/external-id/{loanExternalId}/charges/external-id/{loanChargeExternalId}")
    Call<PutLoansLoanIdChargesChargeIdResponse> updateLoanCharge3(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId, @retrofit2.http.Body PutLoansLoanIdChargesChargeIdRequest putLoansLoanIdChargesChargeIdRequest);



        /**
        * Delete a Loan Charge
        * Note: Currently, A Loan Charge may only be removed from Loans that are not yet approved.
            * @param loanId loanId (required)
            * @param loanChargeId loanChargeId (required)
        * @return Call&lt;DeleteLoansLoanIdChargesChargeIdResponse&gt;
        */
    @DELETE("v1/loans/{loanId}/charges/{loanChargeId}")
    Call<DeleteLoansLoanIdChargesChargeIdResponse> deleteLoanCharge(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeId") Long loanChargeId, @HeaderMap Map<String, String> headers);

        /**
        * Delete a Loan Charge
        * Note: Currently, A Loan Charge may only be removed from Loans that are not yet approved.
            * @param loanId loanId (required)
            * @param loanChargeExternalId loanChargeExternalId (required)
        * @return Call&lt;DeleteLoansLoanIdChargesChargeIdResponse&gt;
        */
    @DELETE("v1/loans/{loanId}/charges/external-id/{loanChargeExternalId}")
    Call<DeleteLoansLoanIdChargesChargeIdResponse> deleteLoanCharge1(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Delete a Loan Charge
        * Note: Currently, A Loan Charge may only be removed from Loans that are not yet approved.
            * @param loanExternalId loanExternalId (required)
            * @param loanChargeId loanChargeId (required)
        * @return Call&lt;DeleteLoansLoanIdChargesChargeIdResponse&gt;
        */
    @DELETE("v1/loans/external-id/{loanExternalId}/charges/{loanChargeId}")
    Call<DeleteLoansLoanIdChargesChargeIdResponse> deleteLoanCharge2(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeId") Long loanChargeId, @HeaderMap Map<String, String> headers);

        /**
        * Delete a Loan Charge
        * Note: Currently, A Loan Charge may only be removed from Loans that are not yet approved.
            * @param loanExternalId loanExternalId (required)
            * @param loanChargeExternalId loanChargeExternalId (required)
        * @return Call&lt;DeleteLoansLoanIdChargesChargeIdResponse&gt;
        */
    @DELETE("v1/loans/external-id/{loanExternalId}/charges/external-id/{loanChargeExternalId}")
    Call<DeleteLoansLoanIdChargesChargeIdResponse> deleteLoanCharge3(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Create a Loan Charge (no command provided) or Pay a charge (command&#x3D;pay)
        * Creates a Loan Charge | Pay a Loan Charge
            * @param loanId loanId (required)
            * @param postLoansLoanIdChargesRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostLoansLoanIdChargesResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/{loanId}/charges")
    Call<PostLoansLoanIdChargesResponse> executeLoanCharge(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PostLoansLoanIdChargesRequest postLoansLoanIdChargesRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Create a Loan Charge (no command provided) or Pay a charge (command&#x3D;pay)
        * Creates a Loan Charge | Pay a Loan Charge
            * @param loanExternalId loanExternalId (required)
            * @param postLoansLoanIdChargesRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostLoansLoanIdChargesResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/external-id/{loanExternalId}/charges")
    Call<PostLoansLoanIdChargesResponse> executeLoanCharge1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PostLoansLoanIdChargesRequest postLoansLoanIdChargesRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Pay / Waive / Adjustment for Loan Charge
        * Loan Charge will be paid if the loan is linked with a savings account | Waive Loan Charge | Add Charge Adjustment
            * @param loanId loanId (required)
            * @param loanChargeId loanChargeId (required)
            * @param postLoansLoanIdChargesChargeIdRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostLoansLoanIdChargesChargeIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/{loanId}/charges/{loanChargeId}")
    Call<PostLoansLoanIdChargesChargeIdResponse> executeLoanCharge2(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeId") Long loanChargeId, @retrofit2.http.Body PostLoansLoanIdChargesChargeIdRequest postLoansLoanIdChargesChargeIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Pay / Waive / Adjustment for Loan Charge
        * Loan Charge will be paid if the loan is linked with a savings account | Waive Loan Charge | Add Charge Adjustment
            * @param loanId loanId (required)
            * @param loanChargeExternalId loanChargeExternalId (required)
            * @param postLoansLoanIdChargesChargeIdRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostLoansLoanIdChargesChargeIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/{loanId}/charges/external-id/{loanChargeExternalId}")
    Call<PostLoansLoanIdChargesChargeIdResponse> executeLoanCharge3(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId, @retrofit2.http.Body PostLoansLoanIdChargesChargeIdRequest postLoansLoanIdChargesChargeIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Pay / Waive / Adjustment for Loan Charge
        * Loan Charge will be paid if the loan is linked with a savings account | Waive Loan Charge | Add Charge Adjustment
            * @param loanExternalId loanExternalId (required)
            * @param loanChargeId loanChargeId (required)
            * @param postLoansLoanIdChargesChargeIdRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostLoansLoanIdChargesChargeIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/external-id/{loanExternalId}/charges/{loanChargeId}")
    Call<PostLoansLoanIdChargesChargeIdResponse> executeLoanCharge4(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeId") Long loanChargeId, @retrofit2.http.Body PostLoansLoanIdChargesChargeIdRequest postLoansLoanIdChargesChargeIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Pay / Waive / Adjustment for Loan Charge
        * Loan Charge will be paid if the loan is linked with a savings account | Waive Loan Charge | Add Charge Adjustment
            * @param loanExternalId loanExternalId (required)
            * @param loanChargeExternalId loanChargeExternalId (required)
            * @param postLoansLoanIdChargesChargeIdRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostLoansLoanIdChargesChargeIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/external-id/{loanExternalId}/charges/external-id/{loanChargeExternalId}")
    Call<PostLoansLoanIdChargesChargeIdResponse> executeLoanCharge5(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId, @retrofit2.http.Body PostLoansLoanIdChargesChargeIdRequest postLoansLoanIdChargesChargeIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * List Loan Charges
        * It lists all the Loan Charges specific to a Loan   Example Requests:  loans/1/charges   loans/1/charges?fields&#x3D;name,amountOrPercentage
            * @param loanId loanId (required)
        * @return Call&lt;List&lt;GetLoansLoanIdChargesChargeIdResponse&gt;&gt;
        */
    @GET("v1/loans/{loanId}/charges")
    Call<List<GetLoansLoanIdChargesChargeIdResponse>> retrieveAllLoanCharges(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * List Loan Charges
        * It lists all the Loan Charges specific to a Loan   Example Requests:  loans/1/charges   loans/1/charges?fields&#x3D;name,amountOrPercentage
            * @param loanExternalId loanExternalId (required)
        * @return Call&lt;List&lt;GetLoansLoanIdChargesChargeIdResponse&gt;&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/charges")
    Call<List<GetLoansLoanIdChargesChargeIdResponse>> retrieveAllLoanCharges1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Loan Charge
        * Retrieves Loan Charge according to the Loan ID and Loan Charge IDExample Requests:  /loans/1/charges/1   /loans/1/charges/1?fields&#x3D;name,amountOrPercentage
            * @param loanId loanId (required)
            * @param loanChargeId loanChargeId (required)
        * @return Call&lt;GetLoansLoanIdChargesChargeIdResponse&gt;
        */
    @GET("v1/loans/{loanId}/charges/{loanChargeId}")
    Call<GetLoansLoanIdChargesChargeIdResponse> retrieveLoanCharge(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeId") Long loanChargeId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Loan Charge
        * Retrieves Loan Charge according to the Loan ID and Loan Charge External IDExample Requests:  /loans/1/charges/1   /loans/1/charges/external-id/1?fields&#x3D;name,amountOrPercentage
            * @param loanId loanId (required)
            * @param loanChargeExternalId loanChargeExternalId (required)
        * @return Call&lt;GetLoansLoanIdChargesChargeIdResponse&gt;
        */
    @GET("v1/loans/{loanId}/charges/external-id/{loanChargeExternalId}")
    Call<GetLoansLoanIdChargesChargeIdResponse> retrieveLoanCharge1(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Loan Charge
        * Retrieves Loan Charge according to the Loan external ID and Loan Charge IDExample Requests:  /loans/1/charges/1   /loans/1/charges/1?fields&#x3D;name,amountOrPercentage
            * @param loanExternalId loanExternalId (required)
            * @param loanChargeId loanChargeId (required)
        * @return Call&lt;GetLoansLoanIdChargesChargeIdResponse&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/charges/{loanChargeId}")
    Call<GetLoansLoanIdChargesChargeIdResponse> retrieveLoanCharge2(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeId") Long loanChargeId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Loan Charge
        * Retrieves Loan Charge according to the Loan External ID and Loan Charge External IDExample Requests:  /loans/1/charges/1   /loans/1/charges/1?fields&#x3D;name,amountOrPercentage
            * @param loanExternalId loanExternalId (required)
            * @param loanChargeExternalId loanChargeExternalId (required)
        * @return Call&lt;GetLoansLoanIdChargesChargeIdResponse&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/charges/external-id/{loanChargeExternalId}")
    Call<GetLoansLoanIdChargesChargeIdResponse> retrieveLoanCharge3(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve Loan Charges Template
        * This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:  Field Defaults Allowed description Lists Example Request:  loans/1/charges/template  
            * @param loanId loanId (required)
        * @return Call&lt;GetLoansLoanIdChargesTemplateResponse&gt;
        */
    @GET("v1/loans/{loanId}/charges/template")
    Call<GetLoansLoanIdChargesTemplateResponse> retrieveTemplate8(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve Loan Charges Template
        * This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:  Field Defaults Allowed description Lists Example Request:  loans/1/charges/template  
            * @param loanExternalId loanExternalId (required)
        * @return Call&lt;GetLoansLoanIdChargesTemplateResponse&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/charges/template")
    Call<GetLoansLoanIdChargesTemplateResponse> retrieveTemplate9(@retrofit2.http.Path("loanExternalId") String loanExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Update a Loan Charge
        * Currently Loan Charges may be updated only if the Loan is not yet approved
            * @param loanId loanId (required)
            * @param loanChargeId loanChargeId (required)
            * @param putLoansLoanIdChargesChargeIdRequest  (required)
        * @return Call&lt;PutLoansLoanIdChargesChargeIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/{loanId}/charges/{loanChargeId}")
    Call<PutLoansLoanIdChargesChargeIdResponse> updateLoanCharge(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeId") Long loanChargeId, @retrofit2.http.Body PutLoansLoanIdChargesChargeIdRequest putLoansLoanIdChargesChargeIdRequest, @HeaderMap Map<String, String> headers);

        /**
        * Update a Loan Charge
        * Currently Loan Charges may be updated only if the Loan is not yet approved
            * @param loanId loanId (required)
            * @param loanChargeExternalId loanChargeExternalId (required)
            * @param putLoansLoanIdChargesChargeIdRequest  (required)
        * @return Call&lt;PutLoansLoanIdChargesChargeIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/{loanId}/charges/external-id/{loanChargeExternalId}")
    Call<PutLoansLoanIdChargesChargeIdResponse> updateLoanCharge1(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId, @retrofit2.http.Body PutLoansLoanIdChargesChargeIdRequest putLoansLoanIdChargesChargeIdRequest, @HeaderMap Map<String, String> headers);

        /**
        * Update a Loan Charge
        * Currently Loan Charges may be updated only if the Loan is not yet approved
            * @param loanExternalId loanExternalId (required)
            * @param loanChargeId loanChargeId (required)
            * @param putLoansLoanIdChargesChargeIdRequest  (required)
        * @return Call&lt;PutLoansLoanIdChargesChargeIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/external-id/{loanExternalId}/charges/{loanChargeId}")
    Call<PutLoansLoanIdChargesChargeIdResponse> updateLoanCharge2(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeId") Long loanChargeId, @retrofit2.http.Body PutLoansLoanIdChargesChargeIdRequest putLoansLoanIdChargesChargeIdRequest, @HeaderMap Map<String, String> headers);

        /**
        * Update a Loan Charge
        * Currently Loan Charges may be updated only if the Loan is not yet approved
            * @param loanExternalId loanExternalId (required)
            * @param loanChargeExternalId loanChargeExternalId (required)
            * @param putLoansLoanIdChargesChargeIdRequest  (required)
        * @return Call&lt;PutLoansLoanIdChargesChargeIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/external-id/{loanExternalId}/charges/external-id/{loanChargeExternalId}")
    Call<PutLoansLoanIdChargesChargeIdResponse> updateLoanCharge3(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanChargeExternalId") String loanChargeExternalId, @retrofit2.http.Body PutLoansLoanIdChargesChargeIdRequest putLoansLoanIdChargesChargeIdRequest, @HeaderMap Map<String, String> headers);


}
