package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.LoanDeferredIncomeData;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface LoanDeferredIncomeDataApi {
    /**
    * Fetch the Capitalized Income related informations
    * 
        * @param loanId loanId (required)
    * @return Call&lt;LoanDeferredIncomeData&gt;
    */
    @GET("v1/loans/{loanId}/deferredincome")
    Call<LoanDeferredIncomeData> fetchDeferredIncomeDetails(@retrofit2.http.Path("loanId") Long loanId);



        /**
        * Fetch the Capitalized Income related informations
        * 
            * @param loanId loanId (required)
        * @return Call&lt;LoanDeferredIncomeData&gt;
        */
    @GET("v1/loans/{loanId}/deferredincome")
    Call<LoanDeferredIncomeData> fetchDeferredIncomeDetails(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);


}
