/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.client.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum TransactionType {
    DISBURSEMENT("disbursement"),
    REPAYMENT("repayment"),
    WAIVER("waiver"),
    REPAYMENT_AT_DISBURSEMENT("repaymentAtDisbursement"),
    WRITE_OFF("writeOff"),
    MARKED_FOR_RESCHEDULING("markedForRescheduling"),
    RECOVERY_REPAYMENT("recoveryRepayment"),
    WAIVE_CHARGES("waiveCharges"),
    ACCRUAL("accrual"),
    INITIATE_TRANSFER("initiateTransfer"),
    APPROVE_TRANSFER("approveTransfer"),
    WITHDRAW_TRANSFER("withdrawTransfer"),
    REJECT_TRANSFER("rejectTransfer"),
    REFUND("refund"),
    CHARGE_PAYMENT("chargePayment"),
    INCOME_POSTING("incomePosting"),
    CREDIT_BALANCE_REFUND("creditBalanceRefund"),
    MERCHANT_ISSUED_REFUND("merchantIssuedRefund"),
    PAYOUT_REFUND("payoutRefund"),
    GOODWILL_CREDIT("goodwillCredit"),
    CHARGE_REFUND("chargeRefund"),
    CHARGEBACK("chargeback"),
    CHARGE_ADJUSTMENT("chargeAdjustment"),
    CHARGE_OFF("chargeOff"),
    DOWN_PAYMENT("downPayment"),
    RE_AGE("reAge"),
    RE_AMORTIZE("reAmortize"),
    INTEREST_PAYMENT_WAIVER("interestPaymentWaiver"),
    ACCRUAL_ACTIVITY("accrualActivity"),
    INTEREST_REFUND("interestRefund"),
    ACCRUAL_ADJUSTMENT("accrualAdjustment"),
    CAPITALIZED_INCOME("capitalizedIncome"),
    CAPITALIZED_INCOME_AMORTIZATION("capitalizedIncomeAmortization"),
    CAPITALIZED_INCOME_ADJUSTMENT("capitalizedIncomeAdjustment"),
    CONTRACT_TERMINATION("contractTermination"),
    CAPITALIZED_INCOME_AMORTIZATION_ADJUSTMENT("capitalizedIncomeAmortizationAdjustment"),
    BUY_DOWN_FEE_AMORTIZATION("buyDownFeeAmortization"),
    BUY_DOWN_FEE_AMORTIZATION_ADJUSTMENT("buyDownFeeAmortizationAdjustment");

    private String value;

    private TransactionType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransactionType fromValue(String value) {
        for (TransactionType b : TransactionType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter
    extends TypeAdapter<TransactionType> {
        public void write(JsonWriter jsonWriter, TransactionType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public TransactionType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return TransactionType.fromValue(value);
        }
    }
}

