/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.accounting.closure.domain.GLClosure;
import org.apache.fineract.accounting.common.AccountingConstants;
import org.apache.fineract.accounting.journalentry.data.SavingsDTO;
import org.apache.fineract.accounting.journalentry.data.SavingsTransactionDTO;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorForSavings;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorHelper;
import org.apache.fineract.organisation.office.domain.Office;
import org.springframework.stereotype.Component;

@Component
public class CashBasedAccountingProcessorForSavings
implements AccountingProcessorForSavings {
    private final AccountingProcessorHelper helper;

    public void createJournalEntriesForSavings(SavingsDTO savingsDTO) {
        GLClosure latestGLClosure = this.helper.getLatestClosureByBranch(savingsDTO.getOfficeId().longValue());
        Long savingsProductId = savingsDTO.getSavingsProductId();
        Long savingsId = savingsDTO.getSavingsId();
        String currencyCode = savingsDTO.getCurrencyCode();
        for (SavingsTransactionDTO savingsTransactionDTO : savingsDTO.getNewSavingsTransactions()) {
            boolean isPositive;
            LocalDate transactionDate = savingsTransactionDTO.getTransactionDate();
            String transactionId = savingsTransactionDTO.getTransactionId();
            Office office = this.helper.getOfficeById(savingsTransactionDTO.getOfficeId().longValue());
            Long paymentTypeId = savingsTransactionDTO.getPaymentTypeId();
            boolean isReversal = savingsTransactionDTO.isReversed();
            BigDecimal amount = savingsTransactionDTO.getAmount();
            BigDecimal overdraftAmount = savingsTransactionDTO.getOverdraftAmount();
            List feePayments = savingsTransactionDTO.getFeePayments();
            List penaltyPayments = savingsTransactionDTO.getPenaltyPayments();
            this.helper.checkForBranchClosures(latestGLClosure, transactionDate);
            if (savingsTransactionDTO.getTransactionType().isWithdrawal() && savingsTransactionDTO.isOverdraftTransaction()) {
                boolean bl = isPositive = amount.subtract(overdraftAmount).compareTo(BigDecimal.ZERO) > 0;
                if (savingsTransactionDTO.isAccountTransfer()) {
                    this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.OVERDRAFT_PORTFOLIO_CONTROL.getValue(), AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, overdraftAmount, Boolean.valueOf(isReversal));
                    if (!isPositive) continue;
                    this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL.getValue(), AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount.subtract(overdraftAmount), Boolean.valueOf(isReversal));
                    continue;
                }
                this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.OVERDRAFT_PORTFOLIO_CONTROL.getValue(), AccountingConstants.CashAccountsForSavings.SAVINGS_REFERENCE.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, overdraftAmount, Boolean.valueOf(isReversal));
                if (!isPositive) continue;
                this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL.getValue(), AccountingConstants.CashAccountsForSavings.SAVINGS_REFERENCE.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount.subtract(overdraftAmount), Boolean.valueOf(isReversal));
                continue;
            }
            if (savingsTransactionDTO.getTransactionType().isDeposit() && savingsTransactionDTO.isOverdraftTransaction()) {
                boolean bl = isPositive = amount.subtract(overdraftAmount).compareTo(BigDecimal.ZERO) > 0;
                if (savingsTransactionDTO.isAccountTransfer()) {
                    this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue(), AccountingConstants.CashAccountsForSavings.OVERDRAFT_PORTFOLIO_CONTROL.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, overdraftAmount, Boolean.valueOf(isReversal));
                    if (!isPositive) continue;
                    this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue(), AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount.subtract(overdraftAmount), Boolean.valueOf(isReversal));
                    continue;
                }
                this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_REFERENCE.getValue(), AccountingConstants.CashAccountsForSavings.OVERDRAFT_PORTFOLIO_CONTROL.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, overdraftAmount, Boolean.valueOf(isReversal));
                if (!isPositive) continue;
                this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_REFERENCE.getValue(), AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount.subtract(overdraftAmount), Boolean.valueOf(isReversal));
                continue;
            }
            if (savingsTransactionDTO.getTransactionType().isDeposit()) {
                if (savingsTransactionDTO.isAccountTransfer()) {
                    this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue(), AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal));
                    continue;
                }
                this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_REFERENCE.getValue(), AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal));
                continue;
            }
            if (savingsTransactionDTO.getTransactionType().isDividendPayout()) {
                this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.FinancialActivity.PAYABLE_DIVIDENDS.getValue(), AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal));
                continue;
            }
            if (savingsTransactionDTO.getTransactionType().isWithdrawal()) {
                if (savingsTransactionDTO.isAccountTransfer()) {
                    this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL.getValue(), AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal));
                    continue;
                }
                this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL.getValue(), AccountingConstants.CashAccountsForSavings.SAVINGS_REFERENCE.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal));
                continue;
            }
            if (savingsTransactionDTO.getTransactionType().isEscheat()) {
                this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL.getValue(), AccountingConstants.CashAccountsForSavings.ESCHEAT_LIABILITY.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal));
                continue;
            }
            if (savingsTransactionDTO.getTransactionType().isInterestPosting() && savingsTransactionDTO.isOverdraftTransaction()) {
                boolean bl = isPositive = amount.subtract(overdraftAmount).compareTo(BigDecimal.ZERO) > 0;
                if (savingsTransactionDTO.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.INTEREST_ON_SAVINGS.getValue(), AccountingConstants.CashAccountsForSavings.OVERDRAFT_PORTFOLIO_CONTROL.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, overdraftAmount, Boolean.valueOf(isReversal));
                if (!isPositive) continue;
                this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.INTEREST_ON_SAVINGS.getValue(), AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount.subtract(overdraftAmount), Boolean.valueOf(isReversal));
                continue;
            }
            if (savingsTransactionDTO.getTransactionType().isInterestPosting()) {
                if (savingsTransactionDTO.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.INTEREST_ON_SAVINGS.getValue(), AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal));
                continue;
            }
            if (savingsTransactionDTO.getTransactionType().isWithholdTax()) {
                this.helper.createCashBasedJournalEntriesAndReversalsForSavingsTax(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL, AccountingConstants.CashAccountsForSavings.SAVINGS_REFERENCE, savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal), savingsTransactionDTO.getTaxPayments());
                continue;
            }
            if (savingsTransactionDTO.getTransactionType().isFeeDeduction() && savingsTransactionDTO.isOverdraftTransaction()) {
                boolean bl = isPositive = amount.subtract(overdraftAmount).compareTo(BigDecimal.ZERO) > 0;
                if (penaltyPayments.size() > 0) {
                    this.helper.createCashBasedJournalEntriesAndReversalsForSavingsCharges(office, currencyCode, AccountingConstants.CashAccountsForSavings.OVERDRAFT_PORTFOLIO_CONTROL, AccountingConstants.CashAccountsForSavings.INCOME_FROM_PENALTIES, savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, overdraftAmount, Boolean.valueOf(isReversal), penaltyPayments);
                    if (!isPositive) continue;
                    this.helper.createCashBasedJournalEntriesAndReversalsForSavingsCharges(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL, AccountingConstants.CashAccountsForSavings.INCOME_FROM_PENALTIES, savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount.subtract(overdraftAmount), Boolean.valueOf(isReversal), penaltyPayments);
                    continue;
                }
                this.helper.createCashBasedJournalEntriesAndReversalsForSavingsCharges(office, currencyCode, AccountingConstants.CashAccountsForSavings.OVERDRAFT_PORTFOLIO_CONTROL, AccountingConstants.CashAccountsForSavings.INCOME_FROM_FEES, savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, overdraftAmount, Boolean.valueOf(isReversal), feePayments);
                if (!isPositive) continue;
                this.helper.createCashBasedJournalEntriesAndReversalsForSavingsCharges(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL, AccountingConstants.CashAccountsForSavings.INCOME_FROM_FEES, savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount.subtract(overdraftAmount), Boolean.valueOf(isReversal), feePayments);
                continue;
            }
            if (savingsTransactionDTO.getTransactionType().isFeeDeduction()) {
                if (penaltyPayments.size() > 0) {
                    this.helper.createCashBasedJournalEntriesAndReversalsForSavingsCharges(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL, AccountingConstants.CashAccountsForSavings.INCOME_FROM_PENALTIES, savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal), penaltyPayments);
                    continue;
                }
                this.helper.createCashBasedJournalEntriesAndReversalsForSavingsCharges(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL, AccountingConstants.CashAccountsForSavings.INCOME_FROM_FEES, savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal), feePayments);
                continue;
            }
            if (savingsTransactionDTO.getTransactionType().isInitiateTransfer()) {
                this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL.getValue(), AccountingConstants.CashAccountsForSavings.TRANSFERS_SUSPENSE.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal));
                continue;
            }
            if (savingsTransactionDTO.getTransactionType().isWithdrawTransfer() || savingsTransactionDTO.getTransactionType().isApproveTransfer()) {
                this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.TRANSFERS_SUSPENSE.getValue(), AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal));
                continue;
            }
            if (savingsTransactionDTO.getTransactionType().isOverdraftInterest()) {
                this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_REFERENCE.getValue(), AccountingConstants.CashAccountsForSavings.INCOME_FROM_INTEREST.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal));
                continue;
            }
            if (savingsTransactionDTO.getTransactionType().isWrittenoff()) {
                this.helper.createCashBasedJournalEntriesAndReversalsForSavings(office, currencyCode, AccountingConstants.CashAccountsForSavings.LOSSES_WRITTEN_OFF.getValue(), AccountingConstants.CashAccountsForSavings.OVERDRAFT_PORTFOLIO_CONTROL.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal));
                continue;
            }
            if (!savingsTransactionDTO.getTransactionType().isOverdraftFee()) continue;
            this.helper.createCashBasedJournalEntriesAndReversalsForSavingsCharges(office, currencyCode, AccountingConstants.CashAccountsForSavings.SAVINGS_REFERENCE, AccountingConstants.CashAccountsForSavings.INCOME_FROM_FEES, savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal), feePayments);
        }
    }

    @Generated
    public CashBasedAccountingProcessorForSavings(AccountingProcessorHelper helper) {
        this.helper = helper;
    }
}

