/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.batch.command.internal;

import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.batch.command.CommandStrategy;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.batch.domain.BatchResponse;
import org.apache.fineract.infrastructure.core.api.MutableUriInfo;
import org.apache.fineract.infrastructure.dataqueries.api.DatatablesApiResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GetDatatableEntryByQueryCommandStrategy
implements CommandStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetDatatableEntryByQueryCommandStrategy.class);
    private final DatatablesApiResource dataTablesApiResource;

    public BatchResponse execute(BatchRequest request, UriInfo uriInfo) {
        MutableUriInfo parameterizedUriInfo = new MutableUriInfo(uriInfo);
        BatchResponse response = new BatchResponse();
        response.setRequestId(request.getRequestId());
        response.setHeaders(request.getHeaders());
        String relativeUrl = CommandStrategyUtils.relativeUrlWithoutVersion((BatchRequest)request);
        String relativeUrlSubString = StringUtils.substringAfter((String)relativeUrl, (String)"/");
        String columnFilter = null;
        String valueFilter = null;
        String resultColumns = null;
        if (relativeUrl.indexOf(63) > 0) {
            Map queryParameters = CommandStrategyUtils.getQueryParameters((String)relativeUrl);
            CommandStrategyUtils.addQueryParametersToUriInfo((MutableUriInfo)parameterizedUriInfo, (Map)queryParameters);
            block10: for (Map.Entry entry : queryParameters.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "columnFilter": {
                        columnFilter = (String)entry.getValue();
                        continue block10;
                    }
                    case "valueFilter": {
                        valueFilter = (String)entry.getValue();
                        continue block10;
                    }
                    case "resultColumns": {
                        resultColumns = (String)entry.getValue();
                        continue block10;
                    }
                }
                log.warn("Query parameter could not be mapped: {}", entry.getKey());
            }
        }
        String dataTableName = relativeUrlSubString.substring(0, relativeUrlSubString.indexOf("/"));
        String responseBody = this.dataTablesApiResource.queryValues(dataTableName, columnFilter, valueFilter, resultColumns, (UriInfo)parameterizedUriInfo);
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(responseBody);
        return response;
    }

    @Generated
    public GetDatatableEntryByQueryCommandStrategy(DatatablesApiResource dataTablesApiResource) {
        this.dataTablesApiResource = dataTablesApiResource;
    }
}

