/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.batch.command.internal;

import com.google.common.base.Splitter;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.batch.command.CommandStrategy;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.batch.domain.BatchResponse;
import org.apache.fineract.portfolio.savings.api.SavingsAccountTransactionsApiResource;
import org.springframework.stereotype.Component;

@Component
public class SavingsAccountTransactionCommandStrategy
implements CommandStrategy {
    private final SavingsAccountTransactionsApiResource savingsAccountTransactionsApiResource;

    public BatchResponse execute(BatchRequest batchRequest, UriInfo uriInfo) {
        String relativeUrl = CommandStrategyUtils.relativeUrlWithoutVersion((BatchRequest)batchRequest);
        List pathParameters = Splitter.on((char)'/').splitToList((CharSequence)relativeUrl);
        String command = null;
        if (relativeUrl.indexOf(63) > 0) {
            Map queryParameters = CommandStrategyUtils.getQueryParameters((String)relativeUrl);
            command = (String)queryParameters.get("command");
        }
        Long savingsAccountId = Long.parseLong((String)pathParameters.get(1));
        String responseBody = this.savingsAccountTransactionsApiResource.transaction(savingsAccountId, command, batchRequest.getBody());
        return new BatchResponse().setRequestId(batchRequest.getRequestId()).setStatusCode(Integer.valueOf(200)).setBody(responseBody).setHeaders(batchRequest.getHeaders());
    }

    @Generated
    public SavingsAccountTransactionCommandStrategy(SavingsAccountTransactionsApiResource savingsAccountTransactionsApiResource) {
        this.savingsAccountTransactionsApiResource = savingsAccountTransactionsApiResource;
    }
}

