/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import org.apache.fineract.cob.COBBusinessStepService;
import org.apache.fineract.cob.common.CustomJobParameterResolver;
import org.apache.fineract.cob.common.ResetContextTasklet;
import org.apache.fineract.cob.conditions.LoanCOBEnabledCondition;
import org.apache.fineract.cob.listener.InlineCOBLoanItemListener;
import org.apache.fineract.cob.loan.InlineCOBLoanItemProcessor;
import org.apache.fineract.cob.loan.InlineCOBLoanItemReader;
import org.apache.fineract.cob.loan.InlineCOBLoanItemWriter;
import org.apache.fineract.cob.loan.InlineLoanCOBBuildExecutionContextTasklet;
import org.apache.fineract.cob.loan.LoanLockingService;
import org.apache.fineract.infrastructure.jobs.domain.CustomJobParameterRepository;
import org.apache.fineract.infrastructure.jobs.service.JobName;
import org.apache.fineract.infrastructure.springbatch.PropertyService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobScope;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.listener.ExecutionContextPromotionListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.builder.TaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.integration.config.annotation.EnableBatchIntegration;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.repository.CrudRepository;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration
@EnableBatchIntegration
@Conditional(value={LoanCOBEnabledCondition.class})
public class LoanInlineCOBConfig {
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private LoanRepository loanRepository;
    @Autowired
    private COBBusinessStepService cobBusinessStepService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private CustomJobParameterRepository customJobParameterRepository;
    @Autowired
    private CustomJobParameterResolver customJobParameterResolver;
    @Autowired
    private LoanLockingService loanLockingService;

    @Bean
    public InlineLoanCOBBuildExecutionContextTasklet inlineLoanCOBBuildExecutionContextTasklet() {
        return new InlineLoanCOBBuildExecutionContextTasklet(this.cobBusinessStepService, this.customJobParameterRepository, this.customJobParameterResolver);
    }

    @Bean
    protected Step inlineCOBBuildExecutionContextStep() {
        return ((TaskletStepBuilder)new StepBuilder("Inline COB build execution context step", this.jobRepository).tasklet((Tasklet)this.inlineLoanCOBBuildExecutionContextTasklet(), this.transactionManager).listener((StepExecutionListener)this.inlineCobPromotionListener())).build();
    }

    @Bean
    public Step inlineLoanCOBStep() {
        return new StepBuilder("Inline Loan COB Step", this.jobRepository).chunk(this.propertyService.getChunkSize(JobName.LOAN_COB.name()).intValue(), this.transactionManager).reader((ItemReader)this.inlineCobWorkerItemReader()).processor((ItemProcessor)this.inlineCobWorkerItemProcessor()).writer((ItemWriter)this.inlineCobWorkerItemWriter()).listener((Object)this.inlineCobLoanItemListener()).build();
    }

    @Bean(name={"loanInlineCOBJob"})
    public Job loanInlineCOBJob() {
        return ((SimpleJobBuilder)new JobBuilder("INLINE_LOAN_COB", this.jobRepository).start(this.inlineCOBBuildExecutionContextStep()).next(this.inlineLoanCOBStep()).next(this.inlineCOBResetContextStep()).incrementer((JobParametersIncrementer)new RunIdIncrementer())).build();
    }

    @JobScope
    @Bean
    public InlineCOBLoanItemReader inlineCobWorkerItemReader() {
        return new InlineCOBLoanItemReader(this.loanRepository);
    }

    @JobScope
    @Bean
    public InlineCOBLoanItemProcessor inlineCobWorkerItemProcessor() {
        return new InlineCOBLoanItemProcessor(this.cobBusinessStepService);
    }

    @Bean
    public Step inlineCOBResetContextStep() {
        return new StepBuilder("Reset context - Step", this.jobRepository).tasklet((Tasklet)this.inlineCOBResetContext(), this.transactionManager).build();
    }

    @Bean
    public InlineCOBLoanItemWriter inlineCobWorkerItemWriter() {
        InlineCOBLoanItemWriter repositoryItemWriter = new InlineCOBLoanItemWriter(this.loanLockingService);
        repositoryItemWriter.setRepository((CrudRepository)this.loanRepository);
        return repositoryItemWriter;
    }

    @Bean
    public InlineCOBLoanItemListener inlineCobLoanItemListener() {
        return new InlineCOBLoanItemListener(this.loanLockingService, this.transactionTemplate);
    }

    @Bean
    public ResetContextTasklet inlineCOBResetContext() {
        return new ResetContextTasklet();
    }

    @Bean
    public ExecutionContextPromotionListener inlineCobPromotionListener() {
        ExecutionContextPromotionListener listener = new ExecutionContextPromotionListener();
        listener.setKeys(new String[]{"loanCobParameter", "businessSteps", "BusinessDate"});
        return listener;
    }
}

