/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import lombok.Generated;
import org.apache.fineract.cob.common.CustomJobParameterResolver;
import org.apache.fineract.cob.converter.COBParameterConverter;
import org.apache.fineract.cob.data.COBParameter;
import org.apache.fineract.cob.domain.LoanAccountLock;
import org.apache.fineract.cob.domain.LockOwner;
import org.apache.fineract.cob.loan.AbstractLoanItemReader;
import org.apache.fineract.cob.loan.LoanLockingService;
import org.apache.fineract.cob.loan.RetrieveLoanIdService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.lang.NonNull;

public class LoanItemReader
extends AbstractLoanItemReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanItemReader.class);
    private final RetrieveLoanIdService retrieveLoanIdService;
    private final CustomJobParameterResolver customJobParameterResolver;
    private final LoanLockingService loanLockingService;

    public LoanItemReader(LoanRepository loanRepository, RetrieveLoanIdService retrieveLoanIdService, CustomJobParameterResolver customJobParameterResolver, LoanLockingService loanLockingService) {
        super(loanRepository);
        this.retrieveLoanIdService = retrieveLoanIdService;
        this.customJobParameterResolver = customJobParameterResolver;
        this.loanLockingService = loanLockingService;
    }

    @BeforeStep
    public void beforeStep(@NonNull StepExecution stepExecution) {
        List loanIds;
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        COBParameter loanCOBParameter = COBParameterConverter.convert((Object)executionContext.get("loanCobParameter"));
        if (Objects.isNull(loanCOBParameter) || Objects.isNull(loanCOBParameter.getMinAccountId()) && Objects.isNull(loanCOBParameter.getMaxAccountId()) || loanCOBParameter.getMinAccountId().equals(0L) && loanCOBParameter.getMaxAccountId().equals(0L)) {
            loanIds = Collections.emptyList();
        } else {
            loanIds = this.retrieveLoanIdService.retrieveAllNonClosedLoansByLastClosedBusinessDateAndMinAndMaxLoanId(loanCOBParameter, this.customJobParameterResolver.getCustomJobParameterById(stepExecution, "IS_CATCH_UP").map(Boolean::parseBoolean).orElse(false).booleanValue());
            if (loanIds.size() > 0) {
                List lockedByCOBChunkProcessingAccountIds = this.getLoanIdsLockedWithChunkProcessingLock(loanIds);
                loanIds.retainAll(lockedByCOBChunkProcessingAccountIds);
            }
        }
        this.setRemainingData(new LinkedBlockingQueue(loanIds));
    }

    private List<Long> getLoanIdsLockedWithChunkProcessingLock(List<Long> loanIds) {
        ArrayList accountLocks = new ArrayList();
        accountLocks.addAll(this.loanLockingService.findAllByLoanIdInAndLockOwner(loanIds, LockOwner.LOAN_COB_CHUNK_PROCESSING));
        return accountLocks.stream().map(LoanAccountLock::getLoanId).toList();
    }
}

