/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.service;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.cob.conditions.LoanCOBEnabledCondition;
import org.apache.fineract.cob.data.COBIdAndLastClosedBusinessDate;
import org.apache.fineract.cob.domain.LoanAccountLock;
import org.apache.fineract.cob.domain.LoanAccountLockRepository;
import org.apache.fineract.cob.domain.LockOwner;
import org.apache.fineract.cob.exceptions.AccountLockCannotBeOverruledException;
import org.apache.fineract.cob.loan.RetrieveLoanIdService;
import org.apache.fineract.cob.service.InlineLoanCOBExecutionDataParser;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateType;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformInternalServerException;
import org.apache.fineract.infrastructure.core.exception.PlatformRequestBodyItemLimitValidationException;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.jobs.data.JobParameterDTO;
import org.apache.fineract.infrastructure.jobs.domain.CustomJobParameterRepository;
import org.apache.fineract.infrastructure.jobs.exception.JobNotFoundException;
import org.apache.fineract.infrastructure.jobs.service.InlineExecutorService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Conditional(value={LoanCOBEnabledCondition.class})
public class InlineLoanCOBExecutorServiceImpl
implements InlineExecutorService<Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InlineLoanCOBExecutorServiceImpl.class);
    private static final String JOB_EXECUTION_FAILED_MESSAGE = "Job execution failed for job with name: ";
    private final LoanAccountLockRepository loanAccountLockRepository;
    private final InlineLoanCOBExecutionDataParser dataParser;
    private final JobLauncher jobLauncher;
    private final JobLocator jobLocator;
    private final JobExplorer jobExplorer;
    private final TransactionTemplate transactionTemplate;
    private final CustomJobParameterRepository customJobParameterRepository;
    private final PlatformSecurityContext context;
    private final RetrieveLoanIdService retrieveLoanIdService;
    private final FineractProperties fineractProperties;
    private final Gson gson = GoogleGsonSerializerHelper.createSimpleGson();

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public CommandProcessingResult executeInlineJob(JsonCommand command, String jobName) throws AccountLockCannotBeOverruledException {
        List loanIds = this.dataParser.parseExecution(command);
        this.validateLoanIdsListSize(loanIds);
        this.execute(loanIds, jobName);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).build();
    }

    public void execute(List<Long> loanIds, String jobName) {
        LocalDate cobBusinessDate = ThreadLocalContextUtil.getBusinessDateByType((BusinessDateType)BusinessDateType.COB_DATE);
        List loansToBeProcessed = this.getLoansToBeProcessed(loanIds, cobBusinessDate);
        LocalDate executingBusinessDate = this.getOldestCOBBusinessDate(loansToBeProcessed).plusDays(1L);
        if (!loansToBeProcessed.isEmpty()) {
            while (!DateUtils.isAfter((LocalDate)executingBusinessDate, (LocalDate)cobBusinessDate)) {
                this.execute(this.getLoanIdsToBeProcessed(loansToBeProcessed, executingBusinessDate), jobName, executingBusinessDate);
                executingBusinessDate = executingBusinessDate.plusDays(1L);
            }
        }
    }

    private List<Long> getLoanIdsToBeProcessed(List<COBIdAndLastClosedBusinessDate> loansToBeProcessed, LocalDate executingBusinessDate) {
        ArrayList<Long> loanIdsToBeProcessed = new ArrayList<Long>();
        loansToBeProcessed.forEach(loan -> {
            if (loan.getLastClosedBusinessDate() != null) {
                if (DateUtils.isBefore((LocalDate)loan.getLastClosedBusinessDate(), (LocalDate)executingBusinessDate)) {
                    loanIdsToBeProcessed.add(loan.getId());
                }
            } else {
                loanIdsToBeProcessed.add(loan.getId());
            }
        });
        return loanIdsToBeProcessed;
    }

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    private void execute(List<Long> loanIds, String jobName, LocalDate businessDate) {
        JobExecution jobExecution;
        Job inlineLoanCOBJob;
        this.lockLoanAccounts(loanIds, businessDate);
        try {
            inlineLoanCOBJob = this.jobLocator.getJob(jobName);
        }
        catch (NoSuchJobException e) {
            throw new JobNotFoundException(jobName, e);
        }
        JobParameters jobParameters = new JobParametersBuilder(this.jobExplorer).getNextJobParameters(inlineLoanCOBJob).addJobParameters(new JobParameters(this.getJobParametersMap(loanIds, businessDate))).toJobParameters();
        try {
            jobExecution = this.jobLauncher.run(inlineLoanCOBJob, jobParameters);
        }
        catch (Exception e) {
            log.error("{}{}", new Object[]{JOB_EXECUTION_FAILED_MESSAGE, jobName, e});
            throw new PlatformInternalServerException("error.msg.sheduler.job.execution.failed", JOB_EXECUTION_FAILED_MESSAGE, new Object[]{jobName, e});
        }
        if (!BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            log.error("{}{}", (Object)JOB_EXECUTION_FAILED_MESSAGE, (Object)jobName);
            throw new PlatformInternalServerException("error.msg.sheduler.job.execution.failed", JOB_EXECUTION_FAILED_MESSAGE, new Object[]{jobName});
        }
    }

    private LocalDate getOldestCOBBusinessDate(List<COBIdAndLastClosedBusinessDate> loans) {
        COBIdAndLastClosedBusinessDate oldestLoan = loans.stream().min(Comparator.comparing(COBIdAndLastClosedBusinessDate::getLastClosedBusinessDate, Comparator.nullsLast(Comparator.naturalOrder()))).orElse(null);
        return oldestLoan != null && oldestLoan.getLastClosedBusinessDate() != null ? oldestLoan.getLastClosedBusinessDate() : ThreadLocalContextUtil.getBusinessDateByType((BusinessDateType)BusinessDateType.COB_DATE).minusDays(1L);
    }

    private List<COBIdAndLastClosedBusinessDate> getLoansToBeProcessed(List<Long> loanIds, LocalDate cobBusinessDate) {
        ArrayList<COBIdAndLastClosedBusinessDate> loanIdAndLastClosedBusinessDates = new ArrayList<COBIdAndLastClosedBusinessDate>();
        List partitions = Lists.partition(loanIds, (int)this.fineractProperties.getQuery().getInClauseParameterSizeLimit());
        partitions.forEach(partition -> loanIdAndLastClosedBusinessDates.addAll(this.retrieveLoanIdService.retrieveLoanIdsBehindDateOrNull(cobBusinessDate, partition)));
        return loanIdAndLastClosedBusinessDates;
    }

    private List<LoanAccountLock> getLoanAccountLocks(List<Long> loanIds, LocalDate businessDate) {
        ArrayList<LoanAccountLock> loanAccountLocks = new ArrayList<LoanAccountLock>();
        ArrayList alreadyLockedLoanIds = new ArrayList();
        loanIds.forEach(loanId -> {
            Optional loanLockOptional = this.loanAccountLockRepository.findById(loanId);
            if (loanLockOptional.isPresent()) {
                LoanAccountLock loanAccountLock = (LoanAccountLock)loanLockOptional.get();
                if (this.isLockOverrulable(loanAccountLock)) {
                    loanAccountLocks.add(loanAccountLock);
                } else {
                    alreadyLockedLoanIds.add(loanId);
                }
            } else {
                loanAccountLocks.add(new LoanAccountLock(loanId, LockOwner.LOAN_INLINE_COB_PROCESSING, businessDate));
            }
        });
        if (!alreadyLockedLoanIds.isEmpty()) {
            String message = "There is a hard lock on the loan account without any error, so it can't be overruled.";
            String loanIdsMessage = " Locked loan IDs: " + String.valueOf(alreadyLockedLoanIds);
            throw new AccountLockCannotBeOverruledException(message + loanIdsMessage);
        }
        return loanAccountLocks;
    }

    private Map<String, JobParameter<?>> getJobParametersMap(List<Long> loanIds, LocalDate businessDate) {
        String parameterJson = this.gson.toJson(loanIds);
        JobParameterDTO loanIdsParameterDTO = new JobParameterDTO("LoanIds", parameterJson);
        Set<JobParameterDTO> loanIdJobParameter = Collections.singleton(loanIdsParameterDTO);
        Long loanIdsJobParameterId = this.customJobParameterRepository.save(loanIdJobParameter);
        JobParameterDTO businessDateParameterDTO = new JobParameterDTO("BusinessDate", businessDate.format(DateTimeFormatter.ISO_DATE));
        Set<JobParameterDTO> businessDateJobParameter = Collections.singleton(businessDateParameterDTO);
        Long businessDateJobParameterId = this.customJobParameterRepository.save(businessDateJobParameter);
        HashMap jobParameterMap = new HashMap();
        jobParameterMap.put("CUSTOM_JOB_PARAMETER_ID", new JobParameter((Object)loanIdsJobParameterId, Long.class));
        jobParameterMap.put("BusinessDate", new JobParameter((Object)businessDateJobParameterId, Long.class));
        return jobParameterMap;
    }

    private void lockLoanAccounts(List<Long> loanIds, LocalDate businessDate) {
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isLockOverrulable(LoanAccountLock loanAccountLock) {
        if (this.isBypassUser()) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)loanAccountLock.getError());
    }

    private boolean isBypassUser() {
        return this.context.getAuthenticatedUserIfPresent().isBypassUser();
    }

    private void validateLoanIdsListSize(List<Long> loanIds) {
        int inlineLoanCobRequestItemLimit = this.fineractProperties.getApi().getBodyItemSizeLimit().getInlineLoanCob();
        if (loanIds.size() > inlineLoanCobRequestItemLimit) {
            String userMessage = "Size of the loan IDs list cannot be over " + inlineLoanCobRequestItemLimit;
            throw new PlatformRequestBodyItemLimitValidationException(userMessage);
        }
    }

    @Generated
    public InlineLoanCOBExecutorServiceImpl(LoanAccountLockRepository loanAccountLockRepository, InlineLoanCOBExecutionDataParser dataParser, JobLauncher jobLauncher, JobLocator jobLocator, JobExplorer jobExplorer, TransactionTemplate transactionTemplate, CustomJobParameterRepository customJobParameterRepository, PlatformSecurityContext context, RetrieveLoanIdService retrieveLoanIdService, FineractProperties fineractProperties) {
        this.loanAccountLockRepository = loanAccountLockRepository;
        this.dataParser = dataParser;
        this.jobLauncher = jobLauncher;
        this.jobLocator = jobLocator;
        this.jobExplorer = jobExplorer;
        this.transactionTemplate = transactionTemplate;
        this.customJobParameterRepository = customJobParameterRepository;
        this.context = context;
        this.retrieveLoanIdService = retrieveLoanIdService;
        this.fineractProperties = fineractProperties;
    }
}

