/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.email.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.google.gson.Gson;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.campaigns.email.data.EmailCampaignValidator;
import org.apache.fineract.infrastructure.campaigns.email.data.PreviewCampaignMessage;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailCampaign;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailCampaignRepository;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailMessage;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailMessageRepository;
import org.apache.fineract.infrastructure.campaigns.email.exception.EmailCampaignMustBeClosedToBeDeletedException;
import org.apache.fineract.infrastructure.campaigns.email.exception.EmailCampaignMustBeClosedToEditException;
import org.apache.fineract.infrastructure.campaigns.email.exception.EmailCampaignNotFound;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailCampaignWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.dataqueries.data.GenericResultsetData;
import org.apache.fineract.infrastructure.dataqueries.domain.Report;
import org.apache.fineract.infrastructure.dataqueries.domain.ReportParameterUsage;
import org.apache.fineract.infrastructure.dataqueries.domain.ReportRepository;
import org.apache.fineract.infrastructure.dataqueries.exception.ReportNotFoundException;
import org.apache.fineract.infrastructure.dataqueries.service.GenericDataService;
import org.apache.fineract.infrastructure.dataqueries.service.ReadReportingService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EmailCampaignWritePlatformCommandHandlerImpl
implements EmailCampaignWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailCampaignWritePlatformCommandHandlerImpl.class);
    private final PlatformSecurityContext context;
    private final EmailCampaignRepository emailCampaignRepository;
    private final EmailCampaignValidator emailCampaignValidator;
    private final ReportRepository reportRepository;
    private final EmailMessageRepository emailMessageRepository;
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final ReadReportingService readReportingService;
    private final GenericDataService genericDataService;
    private final FromJsonHelper fromJsonHelper;

    @Transactional
    public CommandProcessingResult create(JsonCommand command) {
        AppUser currentUser = this.context.authenticatedUser();
        this.emailCampaignValidator.validateCreate(command.json());
        Long businessRuleId = command.longValueOfParameterNamed("businessRuleId");
        Report businessRule = (Report)this.reportRepository.findById((Object)businessRuleId).orElseThrow(() -> new ReportNotFoundException(businessRuleId));
        Long reportId = command.longValueOfParameterNamed("stretchyReportId");
        Report report = null;
        HashMap<String, String> stretchyReportParams = null;
        if (reportId != null) {
            report = (Report)this.reportRepository.findById((Object)reportId).orElseThrow(() -> new ReportNotFoundException(reportId));
            Set reportParameterUsages = report.getReportParameterUsages();
            stretchyReportParams = new HashMap<String, String>();
            if (reportParameterUsages != null && !reportParameterUsages.isEmpty()) {
                for (ReportParameterUsage reportParameterUsage : reportParameterUsages) {
                    stretchyReportParams.put(reportParameterUsage.getReportParameterName(), "");
                }
            }
        }
        EmailCampaign emailCampaign = EmailCampaign.instance((AppUser)currentUser, (Report)businessRule, report, (JsonCommand)command);
        if (stretchyReportParams != null) {
            emailCampaign.setStretchyReportParamMap(new Gson().toJson(stretchyReportParams));
        }
        this.emailCampaignRepository.saveAndFlush((Object)emailCampaign);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)emailCampaign.getId()).build();
    }

    @Transactional
    public CommandProcessingResult update(Long resourceId, JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.emailCampaignValidator.validateForUpdate(command.json());
            EmailCampaign emailCampaign = (EmailCampaign)this.emailCampaignRepository.findById((Object)resourceId).orElseThrow(() -> new EmailCampaignNotFound(resourceId));
            if (emailCampaign.isActive()) {
                throw new EmailCampaignMustBeClosedToEditException((Long)emailCampaign.getId());
            }
            Map changes = emailCampaign.update(command);
            if (changes.containsKey("businessRuleId")) {
                Long newValue = command.longValueOfParameterNamed("businessRuleId");
                Report reportId = (Report)this.reportRepository.findById((Object)newValue).orElseThrow(() -> new ReportNotFoundException(newValue));
                emailCampaign.setBusinessRuleId(reportId);
            }
            if (!changes.isEmpty()) {
                this.emailCampaignRepository.saveAndFlush((Object)emailCampaign);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(resourceId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(command, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult delete(Long resourceId) {
        this.context.authenticatedUser();
        EmailCampaign emailCampaign = (EmailCampaign)this.emailCampaignRepository.findById((Object)resourceId).orElseThrow(() -> new EmailCampaignNotFound(resourceId));
        if (emailCampaign.isActive()) {
            throw new EmailCampaignMustBeClosedToBeDeletedException((Long)emailCampaign.getId());
        }
        emailCampaign.delete();
        this.emailCampaignRepository.saveAndFlush((Object)emailCampaign);
        return new CommandProcessingResultBuilder().withEntityId((Long)emailCampaign.getId()).build();
    }

    public void insertDirectCampaignIntoEmailOutboundTable(Loan loan, EmailCampaign emailCampaign, HashMap<String, String> campaignParams) {
        try {
            List runReportObject = this.getRunReportByServiceImpl(campaignParams.get("reportName"), campaignParams);
            if (runReportObject != null) {
                for (HashMap entry : runReportObject) {
                    String message = this.compileEmailTemplate(emailCampaign.getEmailMessage(), emailCampaign.getCampaignName(), (Map)entry);
                    Client client = loan.getClient();
                    String emailAddress = client.emailAddress();
                    if (emailAddress == null || !EmailCampaignWritePlatformCommandHandlerImpl.isValidEmail((String)emailAddress)) continue;
                    EmailMessage emailMessage = EmailMessage.pendingEmail(null, (Client)client, null, (EmailCampaign)emailCampaign, (String)emailCampaign.getEmailSubject(), (String)message, (String)emailAddress, (String)emailCampaign.getCampaignName());
                    this.emailMessageRepository.save((Object)emailMessage);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void insertDirectCampaignIntoEmailOutboundTable(String emailParams, String emailSubject, String messageTemplate, String campaignName, Long campaignId) {
        try {
            HashMap campaignParams = (HashMap)new ObjectMapper().readValue(emailParams, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            HashMap queryParamForRunReport = (HashMap)new ObjectMapper().readValue(emailParams, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            List runReportObject = this.getRunReportByServiceImpl((String)campaignParams.get("reportName"), (Map)queryParamForRunReport);
            if (runReportObject != null) {
                for (HashMap entry : runReportObject) {
                    String message = this.compileEmailTemplate(messageTemplate, campaignName, (Map)entry);
                    Integer clientId = (Integer)entry.get("id");
                    EmailCampaign emailCampaign = this.emailCampaignRepository.findById((Object)campaignId).orElse(null);
                    Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(Long.valueOf(clientId.longValue()));
                    String emailAddress = client.emailAddress();
                    if (emailAddress == null || !EmailCampaignWritePlatformCommandHandlerImpl.isValidEmail((String)emailAddress)) continue;
                    EmailMessage emailMessage = EmailMessage.pendingEmail(null, (Client)client, null, (EmailCampaign)emailCampaign, (String)emailSubject, (String)message, (String)emailAddress, (String)campaignName);
                    this.emailMessageRepository.save((Object)emailMessage);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isValidEmail(String email) {
        boolean isValid = true;
        try {
            InternetAddress emailO = new InternetAddress(email);
            emailO.validate();
        }
        catch (AddressException ex) {
            isValid = false;
        }
        return isValid;
    }

    @Transactional
    public CommandProcessingResult activateEmailCampaign(Long campaignId, JsonCommand command) {
        AppUser currentUser = this.context.authenticatedUser();
        this.emailCampaignValidator.validateActivation(command.json());
        EmailCampaign emailCampaign = (EmailCampaign)this.emailCampaignRepository.findById((Object)campaignId).orElseThrow(() -> new EmailCampaignNotFound(campaignId));
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate activationDate = command.localDateValueOfParameterNamed("activationDate");
        emailCampaign.activate(currentUser, fmt, activationDate);
        this.emailCampaignRepository.saveAndFlush((Object)emailCampaign);
        if (emailCampaign.isDirect()) {
            this.insertDirectCampaignIntoEmailOutboundTable(emailCampaign.getParamValue(), emailCampaign.getEmailSubject(), emailCampaign.getEmailMessage(), emailCampaign.getCampaignName(), (Long)emailCampaign.getId());
        } else if (emailCampaign.isSchedule()) {
            LocalDateTime tenantDateTime;
            LocalDateTime recurrenceStartDate = emailCampaign.getRecurrenceStartDate();
            LocalDateTime nextTriggerDateWithTime = DateUtils.isBefore((LocalDateTime)recurrenceStartDate, (LocalDateTime)(tenantDateTime = DateUtils.getLocalDateTimeOfTenant())) ? CalendarUtils.getNextRecurringDate((String)emailCampaign.getRecurrence(), (LocalDateTime)recurrenceStartDate, (LocalDateTime)tenantDateTime) : recurrenceStartDate;
            emailCampaign.setNextTriggerDate(nextTriggerDateWithTime);
            this.emailCampaignRepository.saveAndFlush((Object)emailCampaign);
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)emailCampaign.getId()).build();
    }

    @Transactional
    public CommandProcessingResult closeEmailCampaign(Long campaignId, JsonCommand command) {
        AppUser currentUser = this.context.authenticatedUser();
        this.emailCampaignValidator.validateClosedDate(command.json());
        EmailCampaign emailCampaign = (EmailCampaign)this.emailCampaignRepository.findById((Object)campaignId).orElseThrow(() -> new EmailCampaignNotFound(campaignId));
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate closureDate = command.localDateValueOfParameterNamed("closureDate");
        emailCampaign.close(currentUser, fmt, closureDate);
        this.emailCampaignRepository.saveAndFlush((Object)emailCampaign);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)emailCampaign.getId()).build();
    }

    private String compileEmailTemplate(String textMessageTemplate, String campaignName, Map<String, Object> emailParams) {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile((Reader)new StringReader(textMessageTemplate), campaignName);
        StringWriter stringWriter = new StringWriter();
        mustache.execute((Writer)stringWriter, emailParams);
        return stringWriter.toString();
    }

    public List<HashMap<String, Object>> getRunReportByServiceImpl(String reportName, Map<String, String> queryParams) throws IOException {
        String reportType = "report";
        GenericResultsetData results = this.readReportingService.retrieveGenericResultSetForSmsEmailCampaign(reportName, "report", queryParams);
        String response = this.genericDataService.generateJsonFromGenericResultsetData(results);
        List resultList = (List)new ObjectMapper().readValue(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (HashMap entry : resultList) {
            for (Map.Entry map : entry.entrySet()) {
                String key = (String)map.getKey();
                Object ob = map.getValue();
                if (!(ob instanceof ArrayList) || ((ArrayList)ob).size() != 3) continue;
                String changeArrayDateToStringDate = ((ArrayList)ob).get(2).toString() + "-" + ((ArrayList)ob).get(1).toString() + "-" + ((ArrayList)ob).get(0).toString();
                entry.put(key, changeArrayDateToStringDate);
            }
        }
        return resultList;
    }

    public PreviewCampaignMessage previewMessage(JsonQuery query) {
        PreviewCampaignMessage campaignMessage;
        block3: {
            campaignMessage = null;
            this.context.authenticatedUser();
            this.emailCampaignValidator.validatePreviewMessage(query.json());
            String emailParams = this.fromJsonHelper.extractStringNamed("paramValue", query.parsedJson());
            String textMessageTemplate = this.fromJsonHelper.extractStringNamed("emailMessage", query.parsedJson());
            try {
                HashMap campaignParams = (HashMap)new ObjectMapper().readValue(emailParams, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                HashMap queryParamForRunReport = (HashMap)new ObjectMapper().readValue(emailParams, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                List runReportObject = this.getRunReportByServiceImpl((String)campaignParams.get("reportName"), (Map)queryParamForRunReport);
                if (runReportObject == null) break block3;
                for (HashMap entry : runReportObject) {
                    String textMessage = this.compileEmailTemplate(textMessageTemplate, "EmailCampaign", (Map)entry);
                    if (textMessage.isEmpty()) continue;
                    Integer totalMessage = runReportObject.size();
                    campaignMessage = new PreviewCampaignMessage().setCampaignMessage(textMessage).setTotalNumberOfMessages(totalMessage);
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return campaignMessage;
    }

    @Transactional
    public CommandProcessingResult reactivateEmailCampaign(Long campaignId, JsonCommand command) {
        this.emailCampaignValidator.validateActivation(command.json());
        AppUser currentUser = this.context.authenticatedUser();
        EmailCampaign emailCampaign = (EmailCampaign)this.emailCampaignRepository.findById((Object)campaignId).orElseThrow(() -> new EmailCampaignNotFound(campaignId));
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate reactivationDate = command.localDateValueOfParameterNamed("activationDate");
        emailCampaign.reactivate(currentUser, fmt, reactivationDate);
        if (emailCampaign.isSchedule()) {
            LocalDateTime nextTriggerDate = null;
            LocalDateTime tenantDateTime = DateUtils.getLocalDateTimeOfTenant();
            LocalDateTime recurrenceStartDate = emailCampaign.getRecurrenceStartDate();
            nextTriggerDate = DateUtils.isBefore((LocalDateTime)recurrenceStartDate, (LocalDateTime)tenantDateTime) ? CalendarUtils.getNextRecurringDate((String)emailCampaign.getRecurrence(), (LocalDateTime)recurrenceStartDate, (LocalDateTime)tenantDateTime) : recurrenceStartDate;
            String dateString = nextTriggerDate.toString() + " " + recurrenceStartDate.getHour() + ":" + recurrenceStartDate.getMinute() + ":" + recurrenceStartDate.getSecond();
            DateTimeFormatter simpleDateFormat = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendPattern("yyyy-MM-dd HH:mm:ss").toFormatter();
            LocalDateTime nextTriggerDateWithTime = LocalDateTime.parse(dateString, simpleDateFormat);
            emailCampaign.setNextTriggerDate(nextTriggerDateWithTime);
            this.emailCampaignRepository.saveAndFlush((Object)emailCampaign);
        }
        return new CommandProcessingResultBuilder().withEntityId((Long)emailCampaign.getId()).build();
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, NonTransientDataAccessException dve) {
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.email.campaign.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    @Generated
    public EmailCampaignWritePlatformCommandHandlerImpl(PlatformSecurityContext context, EmailCampaignRepository emailCampaignRepository, EmailCampaignValidator emailCampaignValidator, ReportRepository reportRepository, EmailMessageRepository emailMessageRepository, ClientRepositoryWrapper clientRepositoryWrapper, ReadReportingService readReportingService, GenericDataService genericDataService, FromJsonHelper fromJsonHelper) {
        this.context = context;
        this.emailCampaignRepository = emailCampaignRepository;
        this.emailCampaignValidator = emailCampaignValidator;
        this.reportRepository = reportRepository;
        this.emailMessageRepository = emailMessageRepository;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.readReportingService = readReportingService;
        this.genericDataService = genericDataService;
        this.fromJsonHelper = fromJsonHelper;
    }
}

