/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.sms.api;

import com.google.gson.JsonElement;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.campaigns.constants.CampaignType;
import org.apache.fineract.infrastructure.campaigns.sms.data.CampaignPreviewData;
import org.apache.fineract.infrastructure.campaigns.sms.data.SmsCampaignData;
import org.apache.fineract.infrastructure.campaigns.sms.data.dto.SmsCampaignCreationDto;
import org.apache.fineract.infrastructure.campaigns.sms.data.dto.SmsCampaignHandlerDto;
import org.apache.fineract.infrastructure.campaigns.sms.data.dto.SmsCampaignPreviewDto;
import org.apache.fineract.infrastructure.campaigns.sms.data.dto.SmsCampaignUpdateDto;
import org.apache.fineract.infrastructure.campaigns.sms.service.SmsCampaignReadPlatformService;
import org.apache.fineract.infrastructure.campaigns.sms.service.SmsCampaignWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.stereotype.Component;

@Path(value="/v1/smscampaigns")
@Component
public class SmsCampaignApiResource {
    private final PlatformSecurityContext platformSecurityContext;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final SmsCampaignReadPlatformService smsCampaignReadPlatformService;
    private final FromJsonHelper fromJsonHelper;
    private final SmsCampaignWritePlatformService smsCampaignWritePlatformService;
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<String> toApiJsonSerializer;
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "SMS_CAMPAIGN";

    @GET
    @Path(value="template")
    @Operation(summary="Retrieve a SMS Campaign", description="Example Requests:\n\nsmscampaigns/1\n\n\nsmscampaigns/1?template=true\n\n\nsmscampaigns/template")
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SmsCampaignData.class))})
    public SmsCampaignData template() {
        this.platformSecurityContext.authenticatedUser().validateHasReadPermission("SMSCAMPAIGN");
        return this.smsCampaignReadPlatformService.retrieveTemplate(CampaignType.SMS.name());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a SMS Campaign", description="Mandatory Fields\ncampaignName, campaignType, triggerType, providerId, runReportId, message\n\nMandatory Fields for Cash based on selected report id\nparamValue in json format")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CommandWrapper.class))})
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CommandProcessingResult.class))})
    public CommandProcessingResult createCampaign(@Parameter(hidden=true) SmsCampaignCreationDto smsCampaignCreationDto) {
        this.platformSecurityContext.authenticatedUser();
        CommandWrapper commandRequest = new CommandWrapperBuilder().createSmsCampaign().withJson(this.toApiJsonSerializer.serialize((Object)smsCampaignCreationDto)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @GET
    @Path(value="{resourceId}")
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a SMS Campaign", description="Example Requests:\n\nsmscampaigns/1\n")
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SmsCampaignData.class))})
    public SmsCampaignData retrieveCampaign(@PathParam(value="resourceId") Long resourceId) {
        this.platformSecurityContext.authenticatedUser().validateHasReadPermission("SMSCAMPAIGN");
        return this.smsCampaignReadPlatformService.retrieveOne(resourceId);
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List SMS Campaigns", description="Example Requests:\n\nsmscampaigns")
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SmsCampaignData.class))})
    public Page<SmsCampaignData> retrieveAllEmails(@QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="sortOrder") String sortOrder) {
        this.platformSecurityContext.authenticatedUser().validateHasReadPermission("SMSCAMPAIGN");
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        return this.smsCampaignReadPlatformService.retrieveAll(searchParameters);
    }

    @PUT
    @Path(value="{campaignId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Campaign")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CommandWrapper.class))})
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CommandProcessingResult.class))})
    public CommandProcessingResult updateCampaign(@PathParam(value="campaignId") Long campaignId, @Parameter(hidden=true) SmsCampaignUpdateDto smsCampaignUpdateDto) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateSmsCampaign(campaignId).withJson(this.toApiJsonSerializer.serialize((Object)smsCampaignUpdateDto)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @POST
    @Path(value="{campaignId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="SMS Campaign", description="Activates | Deactivates | Reactivates")
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CommandProcessingResult.class))})
    public CommandProcessingResult handleCommands(@PathParam(value="campaignId") Long campaignId, @QueryParam(value="command") String commandParam, @Parameter(hidden=true) SmsCampaignHandlerDto campaignHandlerDto) {
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(this.toApiJsonSerializer.serialize((Object)campaignHandlerDto));
        return this.getCommandProcessingResult(commandParam, builder, campaignId);
    }

    @POST
    @Path(value="preview")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CampaignPreviewData preview(SmsCampaignPreviewDto previewDto) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        String strPreviewDtoJson = this.toApiJsonSerializer.serialize((Object)previewDto);
        JsonElement parsedQuery = this.fromJsonHelper.parse(strPreviewDtoJson);
        JsonQuery query = JsonQuery.from((String)strPreviewDtoJson, (JsonElement)parsedQuery, (FromJsonHelper)this.fromJsonHelper);
        return this.smsCampaignWritePlatformService.previewMessage(query);
    }

    @DELETE
    @Path(value="{campaignId}")
    @Operation(summary="Delete a SMS Campaign", description="Note: Only closed SMS Campaigns can be deleted")
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CommandProcessingResult.class))})
    public CommandProcessingResult delete(@PathParam(value="campaignId") Long campaignId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteSmsCampaign(campaignId).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    private CommandProcessingResult getCommandProcessingResult(String commandParam, CommandWrapperBuilder builder, Long campaignId) {
        if (StringUtils.isBlank((CharSequence)commandParam)) {
            return null;
        }
        return switch (commandParam.trim().toLowerCase()) {
            case "activate" -> this.commandsSourceWritePlatformService.logCommandSource(builder.activateSmsCampaign(campaignId).build());
            case "close" -> this.commandsSourceWritePlatformService.logCommandSource(builder.closeSmsCampaign(campaignId).build());
            case "reactivate" -> this.commandsSourceWritePlatformService.logCommandSource(builder.reactivateSmsCampaign(campaignId).build());
            default -> null;
        };
    }

    @Generated
    public SmsCampaignApiResource(PlatformSecurityContext platformSecurityContext, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, SmsCampaignReadPlatformService smsCampaignReadPlatformService, FromJsonHelper fromJsonHelper, SmsCampaignWritePlatformService smsCampaignWritePlatformService, PlatformSecurityContext context, DefaultToApiJsonSerializer<String> toApiJsonSerializer) {
        this.platformSecurityContext = platformSecurityContext;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.smsCampaignReadPlatformService = smsCampaignReadPlatformService;
        this.fromJsonHelper = fromJsonHelper;
        this.smsCampaignWritePlatformService = smsCampaignWritePlatformService;
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
    }
}

