/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.sms.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.campaigns.constants.CampaignType;
import org.apache.fineract.infrastructure.campaigns.sms.constants.SmsCampaignStatus;
import org.apache.fineract.infrastructure.campaigns.sms.constants.SmsCampaignTriggerType;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.dataqueries.domain.Report;
import org.apache.fineract.portfolio.calendar.domain.CalendarFrequencyType;
import org.apache.fineract.portfolio.calendar.domain.CalendarWeekDaysType;
import org.apache.fineract.useradministration.domain.AppUser;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="sms_campaign", uniqueConstraints={@UniqueConstraint(columnNames={"campaign_name"}, name="campaign_name_UNIQUE")})
public class SmsCampaign
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="campaign_name", nullable=false)
    private String campaignName;
    @Column(name="campaign_type", nullable=false)
    private Integer campaignType;
    @Column(name="campaign_trigger_type", nullable=false)
    private Integer triggerType;
    @Column(name="provider_id", nullable=true)
    private Long providerId;
    @ManyToOne
    @JoinColumn(name="report_id", nullable=false)
    private Report businessRuleId;
    @Column(name="param_value")
    private String paramValue;
    @Column(name="status_enum", nullable=false)
    private Integer status;
    @Column(name="message", nullable=false)
    private String message;
    @Column(name="closedon_date", nullable=true)
    private LocalDate closureDate;
    @ManyToOne(optional=true)
    @JoinColumn(name="closedon_userid", nullable=true)
    private AppUser closedBy;
    @Column(name="submittedon_date", nullable=true)
    private LocalDate submittedOnDate;
    @ManyToOne(optional=true)
    @JoinColumn(name="submittedon_userid", nullable=true)
    private AppUser submittedBy;
    @Column(name="approvedon_date", nullable=true)
    private LocalDate approvedOnDate;
    @ManyToOne(optional=true)
    @JoinColumn(name="approvedon_userid", nullable=true)
    private AppUser approvedBy;
    @Column(name="recurrence", nullable=true)
    private String recurrence;
    @Column(name="next_trigger_date", nullable=true)
    private LocalDateTime nextTriggerDate;
    @Column(name="last_trigger_date", nullable=true)
    private LocalDateTime lastTriggerDate;
    @Column(name="recurrence_start_date", nullable=true)
    private LocalDateTime recurrenceStartDate;
    @Column(name="is_visible", nullable=true)
    private boolean isVisible;
    @Column(name="is_notification", nullable=true)
    private boolean isNotification;
    static final long serialVersionUID = -7481862180443811728L;

    public SmsCampaign() {
    }

    private SmsCampaign(String campaignName, Integer campaignType, Integer triggerType, Report businessRuleId, Long providerId, String paramValue, String message, LocalDate submittedOnDate, AppUser submittedBy, String recurrence, LocalDateTime recurrenceStartDate, boolean isNotification) {
        this.campaignName = campaignName;
        this.campaignType = campaignType;
        this.triggerType = SmsCampaignTriggerType.fromInt((Integer)triggerType).getValue();
        this.businessRuleId = businessRuleId;
        this.providerId = providerId;
        this.paramValue = paramValue;
        this.status = SmsCampaignStatus.PENDING.getValue();
        this.message = message;
        this.submittedOnDate = submittedOnDate;
        this.submittedBy = submittedBy;
        this.recurrence = recurrence;
        this.isVisible = true;
        this.recurrenceStartDate = recurrenceStartDate;
        this.isNotification = isNotification;
    }

    public static SmsCampaign instance(AppUser submittedBy, Report report, JsonCommand command) {
        String campaignName = command.stringValueOfParameterNamed("campaignName");
        Long campaignType = command.longValueOfParameterNamed("campaignType");
        Long triggerType = command.longValueOfParameterNamed("triggerType");
        boolean isNotification = false;
        if (command.parameterExists("isNotification")) {
            isNotification = command.booleanPrimitiveValueOfParameterNamed("isNotification");
        }
        Long providerId = null;
        if (!isNotification) {
            providerId = command.longValueOfParameterNamed("providerId");
        }
        String paramValue = command.jsonFragment("paramValue");
        String message = command.stringValueOfParameterNamed("message");
        LocalDate submittedOnDate = DateUtils.getBusinessLocalDate();
        if (command.hasParameter("submittedOnDate")) {
            submittedOnDate = command.localDateValueOfParameterNamed("submittedOnDate");
        }
        String recurrence = null;
        LocalDateTime recurrenceStartDate = null;
        if (SmsCampaignTriggerType.SCHEDULE.getValue().equals(triggerType.intValue())) {
            Locale locale = command.extractLocale();
            recurrenceStartDate = DateUtils.getLocalDateTimeOfTenant();
            if (command.hasParameter("dateTimeFormat")) {
                String dateTimeFormat = command.stringValueOfParameterNamed("dateTimeFormat");
                DateTimeFormatter fmt = DateTimeFormatter.ofPattern(dateTimeFormat).withLocale(locale);
                if (command.hasParameter("recurrenceStartDate")) {
                    recurrenceStartDate = LocalDateTime.parse(command.stringValueOfParameterNamed("recurrenceStartDate"), fmt);
                }
                recurrence = SmsCampaign.constructRecurrence((JsonCommand)command);
            }
        }
        return new SmsCampaign(campaignName, Integer.valueOf(campaignType.intValue()), Integer.valueOf(triggerType.intValue()), report, providerId, paramValue, message, submittedOnDate, submittedBy, recurrence, recurrenceStartDate, isNotification);
    }

    public Map<String, Object> update(JsonCommand command) {
        Object newValue;
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(5);
        if (command.isChangeInStringParameterNamed("campaignName", this._persistence_get_campaignName())) {
            newValue = command.stringValueOfParameterNamed("campaignName");
            actualChanges.put("campaignName", newValue);
            this._persistence_set_campaignName((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        if (command.isChangeInStringParameterNamed("message", this._persistence_get_message())) {
            newValue = command.stringValueOfParameterNamed("message");
            actualChanges.put("message", newValue);
            this._persistence_set_message((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        if (command.isChangeInStringParameterNamed("paramValue", this._persistence_get_paramValue())) {
            newValue = command.jsonFragment("paramValue");
            actualChanges.put("paramValue", newValue);
            this._persistence_set_paramValue((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        if (command.isChangeInIntegerParameterNamed("campaignType", this._persistence_get_campaignType())) {
            newValue = command.integerValueOfParameterNamed("campaignType");
            actualChanges.put("campaignType", CampaignType.fromInt((Integer)newValue));
            this._persistence_set_campaignType(CampaignType.fromInt((Integer)newValue).getValue());
        }
        if (command.isChangeInIntegerParameterNamed("triggerType", this._persistence_get_triggerType())) {
            newValue = command.integerValueOfParameterNamed("triggerType");
            actualChanges.put("triggerType", SmsCampaignTriggerType.fromInt((Integer)newValue));
            this._persistence_set_triggerType(SmsCampaignTriggerType.fromInt((Integer)newValue).getValue());
        }
        if (command.isChangeInLongParameterNamed("runReportId", this._persistence_get_businessRuleId() != null ? (Long)this._persistence_get_businessRuleId().getId() : null)) {
            newValue = command.stringValueOfParameterNamed("runReportId");
            actualChanges.put("runReportId", newValue);
        }
        if (command.isChangeInStringParameterNamed("recurrence", this._persistence_get_recurrence())) {
            newValue = command.stringValueOfParameterNamed("recurrence");
            actualChanges.put("recurrence", newValue);
            this._persistence_set_recurrence((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        if (command.isChangeInLongParameterNamed("providerId", this._persistence_get_providerId())) {
            newValue = command.longValueOfParameterNamed("providerId");
            actualChanges.put("providerId", newValue);
        }
        if (command.isChangeInBooleanParameterNamed("isNotification", Boolean.valueOf(this._persistence_get_isNotification()))) {
            newValue = command.booleanObjectValueOfParameterNamed("isNotification");
            this._persistence_set_isNotification(((Boolean)newValue).booleanValue());
            actualChanges.put("isNotification", newValue);
        }
        if (this.isSchedule()) {
            String dateFormatAsInput = command.dateFormat();
            String dateTimeFormatAsInput = command.stringValueOfParameterNamed("dateTimeFormat");
            String localeAsInput = command.locale();
            Locale locale = command.extractLocale();
            DateTimeFormatter fmt = DateTimeFormatter.ofPattern(dateTimeFormatAsInput).withLocale(locale);
            String valueAsInput = command.stringValueOfParameterNamed("recurrenceStartDate");
            actualChanges.put("recurrenceStartDate", valueAsInput);
            actualChanges.put("dateFormat", dateFormatAsInput);
            actualChanges.put("dateTimeFormat", dateTimeFormatAsInput);
            actualChanges.put("locale", localeAsInput);
            this._persistence_set_recurrenceStartDate(LocalDateTime.parse(valueAsInput, fmt));
        }
        return actualChanges;
    }

    public void activate(AppUser currentUser, DateTimeFormatter formatter, LocalDate activationLocalDate) {
        if (this.isActive()) {
            String defaultUserMessage = "Cannot activate campaign. Campaign is already active.";
            ApiParameterError error = ApiParameterError.parameterError((String)"error.msg.campaign.already.active", (String)"Cannot activate campaign. Campaign is already active.", (String)"activationDate", (Object[])new Object[]{activationLocalDate.format(formatter)});
            ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
            dataValidationErrors.add(error);
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        this._persistence_set_approvedOnDate(activationLocalDate);
        this._persistence_set_approvedBy(currentUser);
        this._persistence_set_status(SmsCampaignStatus.ACTIVE.getValue());
        this.validate();
    }

    public void close(AppUser currentUser, DateTimeFormatter dateTimeFormatter, LocalDate closureLocalDate) {
        if (this.isClosed()) {
            String defaultUserMessage = "Cannot close campaign. Campaign already in closed state.";
            ApiParameterError error = ApiParameterError.parameterError((String)"error.msg.campaign.already.closed", (String)"Cannot close campaign. Campaign already in closed state.", (String)"status", (Object[])new Object[]{SmsCampaignStatus.fromInt((Integer)this._persistence_get_status()).getCode()});
            ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
            dataValidationErrors.add(error);
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        if (this._persistence_get_triggerType().intValue() == SmsCampaignTriggerType.SCHEDULE.getValue().intValue()) {
            this._persistence_set_nextTriggerDate(null);
            this._persistence_set_lastTriggerDate(null);
        }
        this._persistence_set_closedBy(currentUser);
        this._persistence_set_closureDate(closureLocalDate);
        this._persistence_set_status(SmsCampaignStatus.CLOSED.getValue());
        this.validateClosureDate();
    }

    public void reactivate(AppUser currentUser, DateTimeFormatter dateTimeFormat, LocalDate reactivateLocalDate) {
        if (!this.isClosed()) {
            String defaultUserMessage = "Cannot reactivate campaign. Campaign must be in closed state.";
            ApiParameterError error = ApiParameterError.parameterError((String)"error.msg.campaign.must.be.closed", (String)"Cannot reactivate campaign. Campaign must be in closed state.", (String)"status", (Object[])new Object[]{SmsCampaignStatus.fromInt((Integer)this._persistence_get_status()).getCode()});
            ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
            dataValidationErrors.add(error);
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        this._persistence_set_approvedOnDate(reactivateLocalDate);
        this._persistence_set_status(SmsCampaignStatus.ACTIVE.getValue());
        this._persistence_set_approvedBy(currentUser);
        this._persistence_set_closureDate(null);
        this._persistence_set_isVisible(true);
        this._persistence_set_closedBy(null);
        this.validateReactivate();
    }

    public void delete() {
        if (!this.isClosed()) {
            String defaultUserMessage = "Cannot delete campaign. Campaign must be in closed state.";
            ApiParameterError error = ApiParameterError.parameterError((String)"error.msg.campaign.must.be.closed", (String)"Cannot delete campaign. Campaign must be in closed state.", (String)"status", (Object[])new Object[]{SmsCampaignStatus.fromInt((Integer)this._persistence_get_status()).getCode()});
            ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
            dataValidationErrors.add(error);
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        this._persistence_set_isVisible(false);
    }

    public boolean isActive() {
        return SmsCampaignStatus.fromInt((Integer)this._persistence_get_status()).equals((Object)SmsCampaignStatus.ACTIVE);
    }

    public boolean isPending() {
        return SmsCampaignStatus.fromInt((Integer)this._persistence_get_status()).equals((Object)SmsCampaignStatus.PENDING);
    }

    public boolean isClosed() {
        return SmsCampaignStatus.fromInt((Integer)this._persistence_get_status()).equals((Object)SmsCampaignStatus.CLOSED);
    }

    public boolean isDirect() {
        return SmsCampaignTriggerType.fromInt((Integer)this._persistence_get_triggerType()).equals((Object)SmsCampaignTriggerType.DIRECT);
    }

    public boolean isSchedule() {
        return SmsCampaignTriggerType.fromInt((Integer)this._persistence_get_triggerType()).equals((Object)SmsCampaignTriggerType.SCHEDULE);
    }

    public boolean isTriggered() {
        return SmsCampaignTriggerType.fromInt((Integer)this._persistence_get_triggerType()).equals((Object)SmsCampaignTriggerType.TRIGGERED);
    }

    private void validate() {
        ArrayList dataValidationErrors = new ArrayList();
        this.validateActivationDate(dataValidationErrors);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void validateReactivate() {
        ArrayList dataValidationErrors = new ArrayList();
        this.validateReactivationDate(dataValidationErrors);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void validateClosureDate() {
        ArrayList dataValidationErrors = new ArrayList();
        this.validateClosureDate(dataValidationErrors);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void validateActivationDate(List<ApiParameterError> dataValidationErrors) {
        ApiParameterError error;
        String defaultUserMessage;
        if (DateUtils.isDateInTheFuture((LocalDate)this.getSubmittedOnDate())) {
            defaultUserMessage = "submitted date cannot be in the future.";
            error = ApiParameterError.parameterError((String)"error.msg.campaign.submittedOnDate.in.the.future", (String)"submitted date cannot be in the future.", (String)"submittedOnDate", (Object[])new Object[]{this._persistence_get_submittedOnDate()});
            dataValidationErrors.add(error);
        }
        if (this.getActivationDate() != null && DateUtils.isAfter((LocalDate)this.getSubmittedOnDate(), (LocalDate)this.getActivationDate())) {
            defaultUserMessage = "submitted date cannot be after the activation date";
            error = ApiParameterError.parameterError((String)"error.msg.campaign.submittedOnDate.after.activation.date", (String)"submitted date cannot be after the activation date", (String)"submittedOnDate", (Object[])new Object[]{this._persistence_get_submittedOnDate()});
            dataValidationErrors.add(error);
        }
        if (DateUtils.isDateInTheFuture((LocalDate)this.getActivationDate())) {
            defaultUserMessage = "Activation date cannot be in the future.";
            error = ApiParameterError.parameterError((String)"error.msg.campaign.activationDate.in.the.future", (String)"Activation date cannot be in the future.", (String)"activationDate", (Object[])new Object[]{this.getActivationDate()});
            dataValidationErrors.add(error);
        }
    }

    private void validateReactivationDate(List<ApiParameterError> dataValidationErrors) {
        ApiParameterError error;
        String defaultUserMessage;
        if (DateUtils.isDateInTheFuture((LocalDate)this.getActivationDate())) {
            defaultUserMessage = "Activation date cannot be in the future.";
            error = ApiParameterError.parameterError((String)"error.msg.campaign.activationDate.in.the.future", (String)"Activation date cannot be in the future.", (String)"activationDate", (Object[])new Object[]{this.getActivationDate()});
            dataValidationErrors.add(error);
        }
        if (this.getActivationDate() != null && DateUtils.isAfter((LocalDate)this.getSubmittedOnDate(), (LocalDate)this.getActivationDate())) {
            defaultUserMessage = "submitted date cannot be after the activation date";
            error = ApiParameterError.parameterError((String)"error.msg.campaign.submittedOnDate.after.activation.date", (String)"submitted date cannot be after the activation date", (String)"submittedOnDate", (Object[])new Object[]{this._persistence_get_submittedOnDate()});
            dataValidationErrors.add(error);
        }
        if (DateUtils.isDateInTheFuture((LocalDate)this.getSubmittedOnDate())) {
            defaultUserMessage = "submitted date cannot be in the future.";
            error = ApiParameterError.parameterError((String)"error.msg.campaign.submittedOnDate.in.the.future", (String)"submitted date cannot be in the future.", (String)"submittedOnDate", (Object[])new Object[]{this._persistence_get_submittedOnDate()});
            dataValidationErrors.add(error);
        }
    }

    private void validateClosureDate(List<ApiParameterError> dataValidationErrors) {
        if (DateUtils.isDateInTheFuture((LocalDate)this.getClosureDate())) {
            String defaultUserMessage = "closure date cannot be in the future.";
            ApiParameterError error = ApiParameterError.parameterError((String)"error.msg.campaign.closureDate.in.the.future", (String)"closure date cannot be in the future.", (String)"closureDate", (Object[])new Object[]{this._persistence_get_closureDate()});
            dataValidationErrors.add(error);
        }
    }

    public LocalDate getSubmittedOnDate() {
        return this._persistence_get_submittedOnDate();
    }

    public LocalDate getClosureDate() {
        return this._persistence_get_closureDate();
    }

    public LocalDate getActivationDate() {
        return this._persistence_get_approvedOnDate();
    }

    public Report getBusinessRuleId() {
        return this._persistence_get_businessRuleId();
    }

    public String getCampaignName() {
        return this._persistence_get_campaignName();
    }

    public String getMessage() {
        return this._persistence_get_message();
    }

    public String getParamValue() {
        return this._persistence_get_paramValue();
    }

    public String getRecurrence() {
        return this._persistence_get_recurrence();
    }

    public LocalDateTime getRecurrenceStartDate() {
        return this._persistence_get_recurrenceStartDate();
    }

    public LocalDateTime getRecurrenceStartDateTime() {
        return this._persistence_get_recurrenceStartDate();
    }

    public void setLastTriggerDate(LocalDateTime lastTriggerDate) {
        this._persistence_set_lastTriggerDate(lastTriggerDate);
    }

    public void setNextTriggerDate(LocalDateTime nextTriggerDate) {
        this._persistence_set_nextTriggerDate(nextTriggerDate);
    }

    public LocalDateTime getNextTriggerDate() {
        return this._persistence_get_nextTriggerDate();
    }

    public LocalDateTime getLastTriggerDate() {
        return this._persistence_get_lastTriggerDate();
    }

    public void updateIsVisible(boolean isVisible) {
        this._persistence_set_isVisible(isVisible);
    }

    public void updateBusinessRuleId(Report report) {
        this._persistence_set_businessRuleId(report);
    }

    public Long getProviderId() {
        return this._persistence_get_providerId();
    }

    private static String constructRecurrence(JsonCommand command) {
        Integer frequency = command.integerValueOfParameterNamed("frequency");
        CalendarFrequencyType frequencyType = CalendarFrequencyType.fromInt((int)frequency);
        Integer interval = command.integerValueOfParameterNamed("interval");
        Integer repeatsOnDay = null;
        if (frequencyType.isWeekly()) {
            repeatsOnDay = command.integerValueOfParameterNamed("repeatsOnDay");
        }
        return SmsCampaign.constructRecurrence((CalendarFrequencyType)frequencyType, (Integer)interval, (Integer)repeatsOnDay);
    }

    private static String constructRecurrence(CalendarFrequencyType frequencyType, Integer interval, Integer repeatsOnDay) {
        CalendarWeekDaysType weekDays;
        StringBuilder recurrenceBuilder = new StringBuilder(200);
        recurrenceBuilder.append("FREQ=");
        recurrenceBuilder.append(frequencyType.toString().toUpperCase());
        if (interval > 1) {
            recurrenceBuilder.append(";INTERVAL=");
            recurrenceBuilder.append(interval);
        }
        if (frequencyType.isWeekly() && repeatsOnDay != null && !(weekDays = CalendarWeekDaysType.fromInt((int)repeatsOnDay)).isInvalid()) {
            recurrenceBuilder.append(";BYDAY=");
            recurrenceBuilder.append(weekDays.toString().toUpperCase());
        }
        return recurrenceBuilder.toString();
    }

    public boolean isNotification() {
        return this._persistence_get_isNotification();
    }

    public void setNotification(boolean isNotification) {
        this._persistence_set_isNotification(isNotification);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new SmsCampaign(persistenceObject);
    }

    public SmsCampaign(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "closedBy") {
            return this.closedBy;
        }
        if (string == "submittedBy") {
            return this.submittedBy;
        }
        if (string == "businessRuleId") {
            return this.businessRuleId;
        }
        if (string == "campaignType") {
            return this.campaignType;
        }
        if (string == "approvedBy") {
            return this.approvedBy;
        }
        if (string == "isVisible") {
            return this.isVisible;
        }
        if (string == "message") {
            return this.message;
        }
        if (string == "isNotification") {
            return this.isNotification;
        }
        if (string == "nextTriggerDate") {
            return this.nextTriggerDate;
        }
        if (string == "recurrence") {
            return this.recurrence;
        }
        if (string == "lastTriggerDate") {
            return this.lastTriggerDate;
        }
        if (string == "recurrenceStartDate") {
            return this.recurrenceStartDate;
        }
        if (string == "providerId") {
            return this.providerId;
        }
        if (string == "approvedOnDate") {
            return this.approvedOnDate;
        }
        if (string == "closureDate") {
            return this.closureDate;
        }
        if (string == "triggerType") {
            return this.triggerType;
        }
        if (string == "submittedOnDate") {
            return this.submittedOnDate;
        }
        if (string == "campaignName") {
            return this.campaignName;
        }
        if (string == "paramValue") {
            return this.paramValue;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "closedBy") {
            this.closedBy = (AppUser)object;
            return;
        }
        if (string == "submittedBy") {
            this.submittedBy = (AppUser)object;
            return;
        }
        if (string == "businessRuleId") {
            this.businessRuleId = (Report)object;
            return;
        }
        if (string == "campaignType") {
            this.campaignType = (Integer)object;
            return;
        }
        if (string == "approvedBy") {
            this.approvedBy = (AppUser)object;
            return;
        }
        if (string == "isVisible") {
            this.isVisible = (Boolean)object;
            return;
        }
        if (string == "message") {
            this.message = (String)object;
            return;
        }
        if (string == "isNotification") {
            this.isNotification = (Boolean)object;
            return;
        }
        if (string == "nextTriggerDate") {
            this.nextTriggerDate = (LocalDateTime)object;
            return;
        }
        if (string == "recurrence") {
            this.recurrence = (String)object;
            return;
        }
        if (string == "lastTriggerDate") {
            this.lastTriggerDate = (LocalDateTime)object;
            return;
        }
        if (string == "recurrenceStartDate") {
            this.recurrenceStartDate = (LocalDateTime)object;
            return;
        }
        if (string == "providerId") {
            this.providerId = (Long)object;
            return;
        }
        if (string == "approvedOnDate") {
            this.approvedOnDate = (LocalDate)object;
            return;
        }
        if (string == "closureDate") {
            this.closureDate = (LocalDate)object;
            return;
        }
        if (string == "triggerType") {
            this.triggerType = (Integer)object;
            return;
        }
        if (string == "submittedOnDate") {
            this.submittedOnDate = (LocalDate)object;
            return;
        }
        if (string == "campaignName") {
            this.campaignName = (String)object;
            return;
        }
        if (string == "paramValue") {
            this.paramValue = (String)object;
            return;
        }
        if (string == "status") {
            this.status = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public AppUser _persistence_get_closedBy() {
        this._persistence_checkFetched("closedBy");
        return this.closedBy;
    }

    public void _persistence_set_closedBy(AppUser appUser) {
        this._persistence_checkFetchedForSet("closedBy");
        this._persistence_propertyChange("closedBy", (Object)this.closedBy, (Object)appUser);
        this.closedBy = appUser;
    }

    public AppUser _persistence_get_submittedBy() {
        this._persistence_checkFetched("submittedBy");
        return this.submittedBy;
    }

    public void _persistence_set_submittedBy(AppUser appUser) {
        this._persistence_checkFetchedForSet("submittedBy");
        this._persistence_propertyChange("submittedBy", (Object)this.submittedBy, (Object)appUser);
        this.submittedBy = appUser;
    }

    public Report _persistence_get_businessRuleId() {
        this._persistence_checkFetched("businessRuleId");
        return this.businessRuleId;
    }

    public void _persistence_set_businessRuleId(Report report) {
        this._persistence_checkFetchedForSet("businessRuleId");
        this._persistence_propertyChange("businessRuleId", (Object)this.businessRuleId, (Object)report);
        this.businessRuleId = report;
    }

    public Integer _persistence_get_campaignType() {
        this._persistence_checkFetched("campaignType");
        return this.campaignType;
    }

    public void _persistence_set_campaignType(Integer n) {
        this._persistence_checkFetchedForSet("campaignType");
        this._persistence_propertyChange("campaignType", (Object)this.campaignType, (Object)n);
        this.campaignType = n;
    }

    public AppUser _persistence_get_approvedBy() {
        this._persistence_checkFetched("approvedBy");
        return this.approvedBy;
    }

    public void _persistence_set_approvedBy(AppUser appUser) {
        this._persistence_checkFetchedForSet("approvedBy");
        this._persistence_propertyChange("approvedBy", (Object)this.approvedBy, (Object)appUser);
        this.approvedBy = appUser;
    }

    public boolean _persistence_get_isVisible() {
        this._persistence_checkFetched("isVisible");
        return this.isVisible;
    }

    public void _persistence_set_isVisible(boolean bl) {
        this._persistence_checkFetchedForSet("isVisible");
        this._persistence_propertyChange("isVisible", (Object)new Boolean(this.isVisible), (Object)new Boolean(bl));
        this.isVisible = bl;
    }

    public String _persistence_get_message() {
        this._persistence_checkFetched("message");
        return this.message;
    }

    public void _persistence_set_message(String string) {
        this._persistence_checkFetchedForSet("message");
        this._persistence_propertyChange("message", (Object)this.message, (Object)string);
        this.message = string;
    }

    public boolean _persistence_get_isNotification() {
        this._persistence_checkFetched("isNotification");
        return this.isNotification;
    }

    public void _persistence_set_isNotification(boolean bl) {
        this._persistence_checkFetchedForSet("isNotification");
        this._persistence_propertyChange("isNotification", (Object)new Boolean(this.isNotification), (Object)new Boolean(bl));
        this.isNotification = bl;
    }

    public LocalDateTime _persistence_get_nextTriggerDate() {
        this._persistence_checkFetched("nextTriggerDate");
        return this.nextTriggerDate;
    }

    public void _persistence_set_nextTriggerDate(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("nextTriggerDate");
        this._persistence_propertyChange("nextTriggerDate", (Object)this.nextTriggerDate, (Object)localDateTime);
        this.nextTriggerDate = localDateTime;
    }

    public String _persistence_get_recurrence() {
        this._persistence_checkFetched("recurrence");
        return this.recurrence;
    }

    public void _persistence_set_recurrence(String string) {
        this._persistence_checkFetchedForSet("recurrence");
        this._persistence_propertyChange("recurrence", (Object)this.recurrence, (Object)string);
        this.recurrence = string;
    }

    public LocalDateTime _persistence_get_lastTriggerDate() {
        this._persistence_checkFetched("lastTriggerDate");
        return this.lastTriggerDate;
    }

    public void _persistence_set_lastTriggerDate(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("lastTriggerDate");
        this._persistence_propertyChange("lastTriggerDate", (Object)this.lastTriggerDate, (Object)localDateTime);
        this.lastTriggerDate = localDateTime;
    }

    public LocalDateTime _persistence_get_recurrenceStartDate() {
        this._persistence_checkFetched("recurrenceStartDate");
        return this.recurrenceStartDate;
    }

    public void _persistence_set_recurrenceStartDate(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("recurrenceStartDate");
        this._persistence_propertyChange("recurrenceStartDate", (Object)this.recurrenceStartDate, (Object)localDateTime);
        this.recurrenceStartDate = localDateTime;
    }

    public Long _persistence_get_providerId() {
        this._persistence_checkFetched("providerId");
        return this.providerId;
    }

    public void _persistence_set_providerId(Long l) {
        this._persistence_checkFetchedForSet("providerId");
        this._persistence_propertyChange("providerId", (Object)this.providerId, (Object)l);
        this.providerId = l;
    }

    public LocalDate _persistence_get_approvedOnDate() {
        this._persistence_checkFetched("approvedOnDate");
        return this.approvedOnDate;
    }

    public void _persistence_set_approvedOnDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("approvedOnDate");
        this._persistence_propertyChange("approvedOnDate", (Object)this.approvedOnDate, (Object)localDate);
        this.approvedOnDate = localDate;
    }

    public LocalDate _persistence_get_closureDate() {
        this._persistence_checkFetched("closureDate");
        return this.closureDate;
    }

    public void _persistence_set_closureDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("closureDate");
        this._persistence_propertyChange("closureDate", (Object)this.closureDate, (Object)localDate);
        this.closureDate = localDate;
    }

    public Integer _persistence_get_triggerType() {
        this._persistence_checkFetched("triggerType");
        return this.triggerType;
    }

    public void _persistence_set_triggerType(Integer n) {
        this._persistence_checkFetchedForSet("triggerType");
        this._persistence_propertyChange("triggerType", (Object)this.triggerType, (Object)n);
        this.triggerType = n;
    }

    public LocalDate _persistence_get_submittedOnDate() {
        this._persistence_checkFetched("submittedOnDate");
        return this.submittedOnDate;
    }

    public void _persistence_set_submittedOnDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("submittedOnDate");
        this._persistence_propertyChange("submittedOnDate", (Object)this.submittedOnDate, (Object)localDate);
        this.submittedOnDate = localDate;
    }

    public String _persistence_get_campaignName() {
        this._persistence_checkFetched("campaignName");
        return this.campaignName;
    }

    public void _persistence_set_campaignName(String string) {
        this._persistence_checkFetchedForSet("campaignName");
        this._persistence_propertyChange("campaignName", (Object)this.campaignName, (Object)string);
        this.campaignName = string;
    }

    public String _persistence_get_paramValue() {
        this._persistence_checkFetched("paramValue");
        return this.paramValue;
    }

    public void _persistence_set_paramValue(String string) {
        this._persistence_checkFetchedForSet("paramValue");
        this._persistence_propertyChange("paramValue", (Object)this.paramValue, (Object)string);
        this.paramValue = string;
    }

    public Integer _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(Integer n) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", (Object)this.status, (Object)n);
        this.status = n;
    }
}

