/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.sms.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.campaigns.sms.constants.SmsCampaignTriggerType;
import org.apache.fineract.infrastructure.campaigns.sms.domain.SmsCampaign;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.calendar.domain.CalendarFrequencyType;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.self.device.domain.DeviceRegistration;
import org.apache.fineract.portfolio.self.device.domain.DeviceRegistrationRepositoryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SmsCampaignValidator {
    public static final String RESOURCE_NAME = "sms";
    public static final String campaignName = "campaignName";
    public static final String campaignType = "campaignType";
    public static final String triggerType = "triggerType";
    public static final String triggerEntityType = "triggerEntityType";
    public static final String triggerActionType = "triggerActionType";
    public static final String providerId = "providerId";
    public static final String runReportId = "runReportId";
    public static final String paramValue = "paramValue";
    public static final String message = "message";
    public static final String activationDateParamName = "activationDate";
    public static final String recurrenceStartDate = "recurrenceStartDate";
    public static final String dateTimeFormat = "dateTimeFormat";
    public static final String submittedOnDateParamName = "submittedOnDate";
    public static final String closureDateParamName = "closureDate";
    public static final String recurrenceParamName = "recurrence";
    public static final String statusParamName = "status";
    public static final String localeParamName = "locale";
    public static final String dateFormatParamName = "dateFormat";
    public static final String frequencyParamName = "frequency";
    public static final String intervalParamName = "interval";
    public static final String repeatsOnDayParamName = "repeatsOnDay";
    public static final String isNotificationParamName = "isNotification";
    private final FromJsonHelper fromApiJsonHelper;
    private final DeviceRegistrationRepositoryWrapper deviceRegistrationRepository;
    protected static final Set<String> supportedParams = new HashSet<String>(Arrays.asList("campaignName", "campaignType", "locale", "dateFormat", "runReportId", "paramValue", "message", "recurrenceStartDate", "activationDate", "submittedOnDate", "closureDate", "recurrence", "providerId", "triggerType", "frequency", "interval", "repeatsOnDay", "triggerEntityType", "triggerActionType", "dateTimeFormat", "isNotification"));
    protected static final Set<String> supportedParamsForUpdate = new HashSet<String>(Arrays.asList("campaignName", "campaignType", "locale", "dateFormat", "runReportId", "paramValue", "message", "recurrenceStartDate", "activationDate", "recurrence", "providerId", "triggerType", "triggerEntityType", "triggerActionType", "dateTimeFormat", "isNotification"));
    protected static final Set<String> ACTIVATION_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "activationDate"));
    protected static final Set<String> CLOSE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "closureDate"));
    protected static final Set<String> PREVIEW_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("paramValue", "message"));

    @Autowired
    public SmsCampaignValidator(FromJsonHelper fromApiJsonHelper, DeviceRegistrationRepositoryWrapper deviceRegistrationRepository) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.deviceRegistrationRepository = deviceRegistrationRepository;
    }

    public void validateCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)supportedParams);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(RESOURCE_NAME);
        String campaignName = this.fromApiJsonHelper.extractStringNamed(campaignName, element);
        baseDataValidator.reset().parameter(campaignName).value((Object)campaignName).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        Long campaignType = this.fromApiJsonHelper.extractLongNamed(campaignType, element);
        baseDataValidator.reset().parameter(campaignType).value((Object)campaignType).notNull().integerGreaterThanZero();
        Long triggerType = this.fromApiJsonHelper.extractLongNamed(triggerType, element);
        baseDataValidator.reset().parameter(triggerType).value((Object)triggerType).notNull().integerGreaterThanZero();
        if (triggerType.intValue() == SmsCampaignTriggerType.SCHEDULE.getValue().intValue()) {
            Integer frequencyParam = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(frequencyParamName, element);
            baseDataValidator.reset().parameter(frequencyParamName).value((Object)frequencyParam).notNull().integerGreaterThanZero();
            String intervalParam = this.fromApiJsonHelper.extractStringNamed(intervalParamName, element);
            baseDataValidator.reset().parameter(intervalParamName).value((Object)intervalParam).notBlank();
            if (frequencyParam != null && frequencyParam.equals(CalendarFrequencyType.WEEKLY.getValue())) {
                String repeatsOnDayParam = this.fromApiJsonHelper.extractStringNamed(repeatsOnDayParamName, element);
                baseDataValidator.reset().parameter(repeatsOnDayParamName).value((Object)repeatsOnDayParam).notBlank();
            }
            String recurrenceStartDate = this.fromApiJsonHelper.extractStringNamed(recurrenceStartDate, element);
            baseDataValidator.reset().parameter(recurrenceStartDate).value((Object)recurrenceStartDate).notBlank();
        }
        Long runReportId = this.fromApiJsonHelper.extractLongNamed(runReportId, element);
        baseDataValidator.reset().parameter(runReportId).value((Object)runReportId).notNull().integerGreaterThanZero();
        String message = this.fromApiJsonHelper.extractStringNamed(message, element);
        baseDataValidator.reset().parameter(message).value((Object)message).notBlank().notExceedingLengthOf(Integer.valueOf(480));
        JsonObject paramValueJsonObject = this.fromApiJsonHelper.extractJsonObjectNamed(paramValue, element);
        if (triggerType.intValue() != SmsCampaignTriggerType.TRIGGERED.getValue().intValue()) {
            baseDataValidator.reset().parameter(paramValue).value((Object)paramValueJsonObject).notBlank();
            if (paramValueJsonObject != null && paramValueJsonObject.isJsonObject()) {
                for (Map.Entry entry : paramValueJsonObject.getAsJsonObject().entrySet()) {
                    JsonElement inner = (JsonElement)entry.getValue();
                    baseDataValidator.reset().parameter((String)entry.getKey()).value((Object)inner).notBlank();
                }
            }
        }
        if (this.fromApiJsonHelper.parameterExists(submittedOnDateParamName, element)) {
            LocalDate submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed(submittedOnDateParamName, element);
            baseDataValidator.reset().parameter(submittedOnDateParamName).value((Object)submittedOnDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists(isNotificationParamName, element)) {
            Boolean isNotification = this.fromApiJsonHelper.extractBooleanNamed(isNotificationParamName, element);
            baseDataValidator.reset().parameter(submittedOnDateParamName).trueOrFalseRequired((Object)isNotification);
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)supportedParamsForUpdate);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(RESOURCE_NAME);
        String campaignName = this.fromApiJsonHelper.extractStringNamed(campaignName, element);
        baseDataValidator.reset().parameter(campaignName).value((Object)campaignName).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        Long campaignType = this.fromApiJsonHelper.extractLongNamed(campaignType, element);
        baseDataValidator.reset().parameter(campaignType).value((Object)campaignType).notNull().integerGreaterThanZero();
        Long triggerType = this.fromApiJsonHelper.extractLongNamed(triggerType, element);
        baseDataValidator.reset().parameter(triggerType).value((Object)triggerType).notNull().integerGreaterThanZero();
        if (triggerType.intValue() == SmsCampaignTriggerType.SCHEDULE.getValue().intValue()) {
            if (this.fromApiJsonHelper.parameterExists(recurrenceParamName, element)) {
                String recurrenceParamName = this.fromApiJsonHelper.extractStringNamed(recurrenceParamName, element);
                baseDataValidator.reset().parameter(recurrenceParamName).value((Object)recurrenceParamName).notBlank();
            }
            if (this.fromApiJsonHelper.parameterExists(recurrenceStartDate, element)) {
                String recurrenceStartDate = this.fromApiJsonHelper.extractStringNamed(recurrenceStartDate, element);
                baseDataValidator.reset().parameter(recurrenceStartDate).value((Object)recurrenceStartDate).notBlank();
            }
        }
        if (this.fromApiJsonHelper.parameterExists(runReportId, element)) {
            Long runReportId = this.fromApiJsonHelper.extractLongNamed(runReportId, element);
            baseDataValidator.reset().parameter(runReportId).value((Object)runReportId).notNull().integerGreaterThanZero();
        }
        String message = this.fromApiJsonHelper.extractStringNamed(message, element);
        baseDataValidator.reset().parameter(message).value((Object)message).notBlank().notExceedingLengthOf(Integer.valueOf(480));
        JsonObject paramValueJsonObject = this.fromApiJsonHelper.extractJsonObjectNamed(paramValue, element);
        if (triggerType.intValue() != SmsCampaignTriggerType.TRIGGERED.getValue().intValue()) {
            baseDataValidator.reset().parameter(paramValue).value((Object)paramValueJsonObject).notBlank();
            if (paramValueJsonObject != null && paramValueJsonObject.isJsonObject()) {
                for (Map.Entry entry : paramValueJsonObject.getAsJsonObject().entrySet()) {
                    JsonElement inner = (JsonElement)entry.getValue();
                    baseDataValidator.reset().parameter((String)entry.getKey()).value((Object)inner).notBlank();
                }
            }
        }
        if (this.fromApiJsonHelper.parameterExists(isNotificationParamName, element)) {
            Boolean isNotification = this.fromApiJsonHelper.extractBooleanNamed(isNotificationParamName, element);
            baseDataValidator.reset().parameter(submittedOnDateParamName).trueOrFalseRequired((Object)isNotification);
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validatePreviewMessage(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)PREVIEW_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(RESOURCE_NAME);
        JsonObject paramValueJsonObject = this.fromApiJsonHelper.extractJsonObjectNamed(paramValue, element);
        baseDataValidator.reset().parameter(paramValue).value((Object)paramValueJsonObject).notBlank();
        if (!paramValueJsonObject.isJsonNull() && paramValueJsonObject.isJsonObject()) {
            for (Map.Entry entry : paramValueJsonObject.getAsJsonObject().entrySet()) {
                JsonElement inner = (JsonElement)entry.getValue();
                baseDataValidator.reset().parameter((String)entry.getKey()).value((Object)inner).notBlank();
            }
        }
        String message = this.fromApiJsonHelper.extractStringNamed(message, element);
        baseDataValidator.reset().parameter(message).value((Object)message).notBlank().notExceedingLengthOf(Integer.valueOf(480));
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateClosedDate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)CLOSE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(RESOURCE_NAME);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate closeDate = this.fromApiJsonHelper.extractLocalDateNamed(closureDateParamName, element);
        baseDataValidator.reset().parameter(closureDateParamName).value((Object)closeDate).notNull();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateActivation(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)ACTIVATION_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(RESOURCE_NAME);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate activationDate = this.fromApiJsonHelper.extractLocalDateNamed(activationDateParamName, element);
        baseDataValidator.reset().parameter(activationDateParamName).value((Object)activationDate).notNull();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateClosure(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)CLOSE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(RESOURCE_NAME);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate closeDate = this.fromApiJsonHelper.extractLocalDateNamed(closureDateParamName, element);
        baseDataValidator.reset().parameter(closureDateParamName).value((Object)closeDate).notNull();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public boolean isValidNotificationOrSms(Client client, SmsCampaign smsCampaign, Object mobileNo) {
        if (smsCampaign.isNotification()) {
            if (client != null) {
                DeviceRegistration deviceRegistration = this.deviceRegistrationRepository.findDeviceRegistrationByClientId((Long)client.getId());
                return deviceRegistration != null;
            }
            return false;
        }
        return mobileNo != null;
    }
}

