/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.configuration.domain;

import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.cache.domain.CacheType;
import org.apache.fineract.infrastructure.cache.domain.PlatformCache;
import org.apache.fineract.infrastructure.cache.domain.PlatformCacheRepository;
import org.apache.fineract.infrastructure.configuration.data.GlobalConfigurationPropertyData;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.configuration.domain.GlobalConfigurationRepositoryWrapper;
import org.apache.fineract.useradministration.domain.Permission;
import org.apache.fineract.useradministration.domain.PermissionRepository;
import org.apache.fineract.useradministration.exception.PermissionNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConfigurationDomainServiceJpa
implements ConfigurationDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationDomainServiceJpa.class);
    private final PermissionRepository permissionRepository;
    private final GlobalConfigurationRepositoryWrapper globalConfigurationRepository;
    private final PlatformCacheRepository cacheTypeRepository;

    public boolean isMakerCheckerEnabledForTask(String taskPermissionCode) {
        if (StringUtils.isBlank((CharSequence)taskPermissionCode)) {
            throw new PermissionNotFoundException(taskPermissionCode);
        }
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("maker-checker");
        if (property.isEnabled()) {
            Permission thisTask = this.permissionRepository.findOneByCode(taskPermissionCode);
            if (thisTask == null) {
                throw new PermissionNotFoundException(taskPermissionCode);
            }
            return thisTask.hasMakerCheckerEnabled();
        }
        return false;
    }

    public List<String> getAllowedLoanStatusesForExternalAssetTransfer() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("allowed-loan-statuses-for-external-asset-transfer");
        return List.of(property.getStringValue().split(","));
    }

    public List<String> getAllowedLoanStatusesOfDelayedSettlementForExternalAssetTransfer() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("allowed-loan-statuses-of-delayed-settlement-for-external-asset-transfer");
        return List.of(property.getStringValue().split(","));
    }

    public boolean isSameMakerCheckerEnabled() {
        return this.getGlobalConfigurationPropertyData("enable-same-maker-checker").isEnabled();
    }

    public boolean isAmazonS3Enabled() {
        return this.getGlobalConfigurationPropertyData("amazon-s3").isEnabled();
    }

    public boolean isRescheduleFutureRepaymentsEnabled() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("reschedule-future-repayments");
        return property.isEnabled();
    }

    public boolean isRescheduleRepaymentsOnHolidaysEnabled() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("reschedule-repayments-on-holidays");
        return property.isEnabled();
    }

    public boolean allowTransactionsOnHolidayEnabled() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("allow-transactions-on-holiday");
        return property.isEnabled();
    }

    public boolean allowTransactionsOnNonWorkingDayEnabled() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("allow-transactions-on-non-workingday");
        return property.isEnabled();
    }

    public boolean isConstraintApproachEnabledForDatatables() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("constraint-approach-for-datatables");
        return property.isEnabled();
    }

    public boolean isEhcacheEnabled() {
        return this.cacheTypeRepository.findById((Object)1L).map(PlatformCache::isEhcacheEnabled).orElseThrow();
    }

    @Transactional
    public void updateCache(CacheType cacheType) {
        this.cacheTypeRepository.findById((Object)1L).ifPresent(cache -> {
            cache.setCacheType(cacheType.getValue());
            this.cacheTypeRepository.save(cache);
        });
    }

    public Long retrievePenaltyWaitPeriod() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("penalty-wait-period");
        return property.getValue();
    }

    public Long retrieveGraceOnPenaltyPostingPeriod() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("grace-on-penalty-posting");
        return property.getValue();
    }

    public boolean isPasswordForcedResetEnable() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("force-password-reset-days");
        return property.isEnabled();
    }

    public Long retrievePasswordLiveTime() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("force-password-reset-days");
        return property.getValue();
    }

    public Long retrieveOpeningBalancesContraAccount() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("office-opening-balances-contra-account");
        return property.getValue();
    }

    public boolean isSavingsInterestPostingAtCurrentPeriodEnd() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("savings-interest-posting-current-period-end");
        return property.isEnabled();
    }

    public Integer retrieveFinancialYearBeginningMonth() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("financial-year-beginning-month");
        if (property.isEnabled()) {
            return property.getValue().intValue();
        }
        return 1;
    }

    public Integer retrieveMinAllowedClientsInGroup() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("min-clients-in-group");
        if (property.isEnabled()) {
            return property.getValue().intValue();
        }
        return null;
    }

    public Integer retrieveMaxAllowedClientsInGroup() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("max-clients-in-group");
        if (property.isEnabled()) {
            return property.getValue().intValue();
        }
        return null;
    }

    public boolean isMeetingMandatoryForJLGLoans() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("meetings-mandatory-for-jlg-loans");
        return property.isEnabled();
    }

    public int getRoundingMode() {
        int defaultValue = 6;
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("rounding-mode");
        if (property.isEnabled()) {
            int value = property.getValue().intValue();
            if (value < 0 || value > 6) {
                return defaultValue;
            }
            return value;
        }
        return defaultValue;
    }

    public boolean isBackdatePenaltiesEnabled() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("backdate-penalties-enabled");
        return property.isEnabled();
    }

    public boolean isOrganisationstartDateEnabled() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("organisation-start-date");
        return property.isEnabled();
    }

    public LocalDate retrieveOrganisationStartDate() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("organisation-start-date");
        return property.getDateValue();
    }

    public boolean isPaymentTypeApplicableForDisbursementCharge() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("paymenttype-applicable-for-disbursement-charges");
        return property.isEnabled();
    }

    public boolean isSkippingMeetingOnFirstDayOfMonthEnabled() {
        return this.getGlobalConfigurationPropertyData("skip-repayment-on-first-day-of-month").isEnabled();
    }

    public boolean isFirstRepaymentDateAfterRescheduleAllowedOnHoliday() {
        return this.getGlobalConfigurationPropertyData("loan-reschedule-is-first-payday-allowed-on-holiday").isEnabled();
    }

    public boolean isInterestToBeRecoveredFirstWhenGreaterThanEMI() {
        return this.getGlobalConfigurationPropertyData("is-interest-to-be-recovered-first-when-greater-than-emi").isEnabled();
    }

    public boolean isPrincipalCompoundingDisabledForOverdueLoans() {
        return this.getGlobalConfigurationPropertyData("is-principal-compounding-disabled-for-overdue-loans").isEnabled();
    }

    public Long retreivePeriodInNumberOfDaysForSkipMeetingDate() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("skip-repayment-on-first-day-of-month");
        return property.getValue();
    }

    public boolean isInterestChargedFromDateSameAsDisbursementDate() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("interest-charged-from-date-same-as-disbursal-date");
        return property.isEnabled();
    }

    public boolean isChangeEmiIfRepaymentDateSameAsDisbursementDateEnabled() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("change-emi-if-repaymentdate-same-as-disbursementdate");
        return property.isEnabled();
    }

    public boolean isDailyTPTLimitEnabled() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("daily-tpt-limit");
        return property.isEnabled();
    }

    public Long getDailyTPTLimit() {
        String propertyName = "daily-tpt-limit";
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("daily-tpt-limit");
        return property.getValue();
    }

    public void removeGlobalConfigurationPropertyDataFromCache(String propertyName) {
        this.globalConfigurationRepository.removeFromCache(propertyName);
    }

    public boolean isSMSOTPDeliveryEnabled() {
        String propertyName = "use-sms-for-2fa";
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("use-sms-for-2fa");
        return property.isEnabled();
    }

    public boolean isEmailOTPDeliveryEnabled() {
        String propertyName = "use-email-for-2fa";
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("use-email-for-2fa");
        return property.isEnabled();
    }

    public Integer retrieveOTPCharacterLength() {
        String propertyName = "otp-character-length";
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("otp-character-length");
        int defaultValue = 6;
        int value = property.getValue().intValue();
        if (value < 1) {
            return defaultValue;
        }
        return value;
    }

    public Integer retrieveOTPLiveTime() {
        String propertyName = "otp-validity-period";
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("otp-validity-period");
        int defaultValue = 300;
        int value = property.getValue().intValue();
        if (value < 1) {
            return defaultValue;
        }
        return value;
    }

    public boolean retrievePivotDateConfig() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("allow-backdated-transaction-before-interest-posting");
        return !property.isEnabled();
    }

    public boolean isRelaxingDaysConfigForPivotDateEnabled() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("allow-backdated-transaction-before-interest-posting-date-for-days");
        return property.isEnabled();
    }

    public Long retrieveRelaxingDaysConfigForPivotDate() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("allow-backdated-transaction-before-interest-posting-date-for-days");
        if (property.getValue() == null) {
            return 0L;
        }
        return property.getValue();
    }

    @NotNull
    private GlobalConfigurationPropertyData getGlobalConfigurationPropertyData(String propertyName) {
        return this.globalConfigurationRepository.findOneByNameWithNotFoundDetection(propertyName).toData();
    }

    public boolean isSubRatesEnabled() {
        return this.getGlobalConfigurationPropertyData("sub-rates").isEnabled();
    }

    public String getAccountMappingForPaymentType() {
        String defaultValue = "Asset";
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("account-mapping-for-payment-type");
        if (property.isEnabled()) {
            String value = property.getStringValue();
            if (StringUtils.isBlank((CharSequence)value)) {
                return defaultValue;
            }
            return value;
        }
        return defaultValue;
    }

    public String getAccountMappingForCharge() {
        String defaultValue = "Income";
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("account-mapping-for-charge");
        if (property.isEnabled()) {
            String value = property.getStringValue();
            if (StringUtils.isBlank((CharSequence)value)) {
                return defaultValue;
            }
            return value;
        }
        return defaultValue;
    }

    public boolean isNextDayFixedDepositInterestTransferEnabledForPeriodEnd() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("fixed-deposit-transfer-interest-next-day-for-period-end-posting");
        return property.isEnabled();
    }

    public boolean isBusinessDateEnabled() {
        return this.getGlobalConfigurationPropertyData("enable-business-date").isEnabled();
    }

    public boolean isCOBDateAdjustmentEnabled() {
        return this.getGlobalConfigurationPropertyData("enable-automatic-cob-date-adjustment").isEnabled();
    }

    public boolean isReversalTransactionAllowed() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("enable-post-reversal-txns-for-reverse-transactions");
        return property.isEnabled();
    }

    public Long retrieveExternalEventsPurgeDaysCriteria() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("purge-external-events-older-than-days");
        return property.getValue();
    }

    public Long retrieveProcessedCommandsPurgeDaysCriteria() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("purge-processed-commands-older-than-days");
        return property.getValue();
    }

    public Long retrieveRepaymentDueDays() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("days-before-repayment-is-due");
        return property.getValue();
    }

    public Long retrieveRepaymentOverdueDays() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("days-after-repayment-is-overdue");
        return property.getValue();
    }

    public boolean isExternalIdAutoGenerationEnabled() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("enable-auto-generated-external-id");
        return property.isEnabled();
    }

    public boolean isAddressEnabled() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("enable-address");
        return property.isEnabled();
    }

    public boolean isCOBBulkEventEnabled() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("enable-cob-bulk-event");
        return property.isEnabled();
    }

    public Long retrieveExternalEventBatchSize() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("external-event-batch-size");
        return property.getValue();
    }

    public String retrieveReportExportS3FolderName() {
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("report-export-s3-folder-name");
        return property.getStringValue();
    }

    public String getAccrualDateConfigForCharge() {
        String defaultValue = "due-date";
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("charge-accrual-date");
        String value = property.getStringValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    public String getNextPaymentDateConfigForLoan() {
        String defaultValue = "earliest-unpaid-date";
        GlobalConfigurationPropertyData property = this.getGlobalConfigurationPropertyData("next-payment-due-date");
        String value = property.getStringValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    public boolean isImmediateChargeAccrualPostMaturityEnabled() {
        return this.getGlobalConfigurationPropertyData("enable-immediate-charge-accrual-post-maturity").isEnabled();
    }

    public String getAssetOwnerTransferOustandingInterestStrategy() {
        return this.getGlobalConfigurationPropertyData("outstanding-interest-calculation-strategy-for-external-asset-transfer").getStringValue();
    }

    @Generated
    public ConfigurationDomainServiceJpa(PermissionRepository permissionRepository, GlobalConfigurationRepositoryWrapper globalConfigurationRepository, PlatformCacheRepository cacheTypeRepository) {
        this.permissionRepository = permissionRepository;
        this.globalConfigurationRepository = globalConfigurationRepository;
        this.cacheTypeRepository = cacheTypeRepository;
    }
}

