/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.fineract.infrastructure.core.diagnostics.performance.MeasuringUtil;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.SamplingService;

public abstract class AbstractSamplingService
implements SamplingService {
    private final Map<String, AtomicInteger> sampleCounters = new ConcurrentHashMap();
    private final int samplingRate;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public AbstractSamplingService(int samplingRate) {
        if (samplingRate < 1) {
            throw new IllegalArgumentException("samplingRate cannot be less than 1");
        }
        this.samplingRate = samplingRate;
    }

    public void sample(String key, Runnable r) {
        this.sample(key, () -> {
            r.run();
            return null;
        });
    }

    public <T> T sample(String key, Supplier<T> s) {
        boolean shouldTakeSample;
        AtomicInteger sampleCounter = this.sampleCounters.computeIfAbsent(key, k -> new AtomicInteger(0));
        int sampleCount = sampleCounter.getAndAccumulate(1, (index, inc) -> ++index >= this.samplingRate ? 0 : index);
        boolean bl = shouldTakeSample = sampleCount == 0;
        if (shouldTakeSample) {
            return (T)MeasuringUtil.measure(s, duration -> this.takeSample(key, duration));
        }
        return s.get();
    }

    public void reset() {
        this.sampleCounters.clear();
        this.doReset();
    }

    protected void doReset() {
    }

    protected abstract void takeSample(String var1, Duration var2);
}

