/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreditBureauCommandFromApiJsonDeserializer {
    public static final String ALIAS = "alias";
    public static final String IS_ACTIVE = "isActive";
    public static final String CREDIT_BUREAU_ID = "creditBureauId";
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("alias", "isActive", "creditBureauId"));
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public CreditBureauCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json, Long creditBureauId) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("CreditBureau");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        baseDataValidator.reset().value((Object)creditBureauId).notBlank().integerGreaterThanZero();
        String alias = this.fromApiJsonHelper.extractStringNamed(ALIAS, element);
        baseDataValidator.reset().parameter(ALIAS).value((Object)alias).notNull().notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String is_activeParameter = IS_ACTIVE;
        if (this.fromApiJsonHelper.parameterExists(IS_ACTIVE, element)) {
            boolean isActive = this.fromApiJsonHelper.extractBooleanNamed(IS_ACTIVE, element);
            baseDataValidator.reset().parameter(IS_ACTIVE).value((Object)isActive).notNull().notBlank().trueOrFalseRequired((Object)isActive);
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("CreditBureau");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String creditBureauIdParameter = CREDIT_BUREAU_ID;
        if (this.fromApiJsonHelper.parameterExists(CREDIT_BUREAU_ID, element)) {
            Long creditBureauId = this.fromApiJsonHelper.extractLongNamed(CREDIT_BUREAU_ID, element);
            baseDataValidator.reset().parameter(CREDIT_BUREAU_ID).value((Object)creditBureauId).notNull().notBlank().longGreaterThanZero();
        }
        String is_activeParameter = IS_ACTIVE;
        if (this.fromApiJsonHelper.parameterExists(IS_ACTIVE, element)) {
            boolean isActive = this.fromApiJsonHelper.extractBooleanNamed(IS_ACTIVE, element);
            baseDataValidator.reset().parameter(IS_ACTIVE).value((Object)isActive).notNull().notBlank().trueOrFalseRequired((Object)isActive);
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }
}

