/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.service;

import java.util.Map;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.creditbureau.domain.CreditBureauConfiguration;
import org.apache.fineract.infrastructure.creditbureau.domain.CreditBureauConfigurationRepository;
import org.apache.fineract.infrastructure.creditbureau.domain.OrganisationCreditBureau;
import org.apache.fineract.infrastructure.creditbureau.domain.OrganisationCreditBureauRepository;
import org.apache.fineract.infrastructure.creditbureau.exception.CreditReportNotFoundException;
import org.apache.fineract.infrastructure.creditbureau.serialization.CreditBureauConfigurationCommandFromApiJsonDeserializer;
import org.apache.fineract.infrastructure.creditbureau.service.CreditBureauConfigurationWritePlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CreditBureauConfigurationWritePlatformServiceImpl
implements CreditBureauConfigurationWritePlatformService {
    private final PlatformSecurityContext context;
    private final CreditBureauConfigurationCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final CreditBureauConfigurationRepository creditBureauConfigurationRepository;
    private final OrganisationCreditBureauRepository organisationCreditBureauRepository;

    @Autowired
    public CreditBureauConfigurationWritePlatformServiceImpl(PlatformSecurityContext context, CreditBureauConfigurationCommandFromApiJsonDeserializer fromApiJsonDeserializer, CreditBureauConfigurationRepository creditBureauConfigurationRepository, OrganisationCreditBureauRepository organisationCreditBureauRepository) {
        this.context = context;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.creditBureauConfigurationRepository = creditBureauConfigurationRepository;
        this.organisationCreditBureauRepository = organisationCreditBureauRepository;
    }

    @Transactional
    public CommandProcessingResult addCreditBureauConfiguration(Long creditBureauId, JsonCommand command) {
        this.context.authenticatedUser();
        this.fromApiJsonDeserializer.validateForCreate(command.json(), creditBureauId);
        OrganisationCreditBureau orgcb = (OrganisationCreditBureau)this.organisationCreditBureauRepository.getReferenceById((Object)creditBureauId);
        CreditBureauConfiguration cb_config = CreditBureauConfiguration.fromJson((JsonCommand)command, (OrganisationCreditBureau)orgcb);
        this.creditBureauConfigurationRepository.saveAndFlush((Object)cb_config);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)cb_config.getId()).build();
    }

    @Transactional
    public CommandProcessingResult updateCreditBureauConfiguration(Long configurationId, JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForUpdate(command.json());
            CreditBureauConfiguration config = this.retrieveConfigBy(configurationId);
            Map changes = config.update(command);
            if (!changes.isEmpty()) {
                this.creditBureauConfigurationRepository.save((Object)config);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(configurationId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.cund.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + dve.getMostSpecificCause().getMessage()));
        }
    }

    private CreditBureauConfiguration retrieveConfigBy(Long creditBureauId) {
        return (CreditBureauConfiguration)this.creditBureauConfigurationRepository.findById((Object)creditBureauId).orElseThrow(() -> new CreditReportNotFoundException(creditBureauId));
    }
}

