/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.service;

import java.util.Collection;
import org.apache.fineract.infrastructure.creditbureau.data.OrganisationCreditBureauData;
import org.apache.fineract.infrastructure.creditbureau.service.OrganisationCreditBureauReadPlatformService;
import org.apache.fineract.infrastructure.creditbureau.service.OrganisationCreditBureauReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class OrganisationCreditBureauReadPlatformServiceImpl
implements OrganisationCreditBureauReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;

    @Autowired
    public OrganisationCreditBureauReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
    }

    public Collection<OrganisationCreditBureauData> retrieveOrgCreditBureau() {
        this.context.authenticatedUser();
        OrganisationCreditBureauMapper rm = new OrganisationCreditBureauMapper();
        String sql = "select " + rm.schema() + " order by ocb.id";
        return this.jdbcTemplate.query(sql, (RowMapper)rm);
    }

    public OrganisationCreditBureauData retrieveOrgCreditBureauById(long orgCbId) {
        this.context.authenticatedUser();
        OrganisationCreditBureauMapper rm = new OrganisationCreditBureauMapper();
        String sql = "select " + rm.schema() + " and ocb.id=?";
        return (OrganisationCreditBureauData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{orgCbId});
    }
}

