/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.service;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.service.database.DatabaseIndependentQueryService;
import org.apache.fineract.infrastructure.core.service.database.DatabaseType;
import org.apache.fineract.infrastructure.core.service.database.DatabaseTypeResolver;
import org.apache.fineract.infrastructure.core.service.database.IndexDetail;
import org.apache.fineract.infrastructure.core.service.database.JdbcJavaType;
import org.apache.fineract.infrastructure.core.service.database.RoutingDataSource;
import org.apache.fineract.infrastructure.dataqueries.data.GenericResultsetData;
import org.apache.fineract.infrastructure.dataqueries.data.ResultsetColumnHeaderData;
import org.apache.fineract.infrastructure.dataqueries.data.ResultsetColumnValueData;
import org.apache.fineract.infrastructure.dataqueries.data.ResultsetRowData;
import org.apache.fineract.infrastructure.dataqueries.exception.DatatableNotFoundException;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableKeywordGenerator;
import org.apache.fineract.infrastructure.dataqueries.service.GenericDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GenericDataServiceImpl
implements GenericDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericDataServiceImpl.class);
    private final JdbcTemplate jdbcTemplate;
    private final RoutingDataSource dataSource;
    private final DatabaseIndependentQueryService databaseIndependentQueryService;
    private final DatatableKeywordGenerator datatableKeywordGenerator;
    private final DatabaseTypeResolver databaseTypeResolver;

    public GenericResultsetData fillGenericResultSet(String sql) {
        try {
            SqlRowSet rs = this.jdbcTemplate.queryForRowSet(sql);
            ArrayList<ResultsetColumnHeaderData> columnHeaders = new ArrayList<ResultsetColumnHeaderData>();
            SqlRowSetMetaData rsmd = rs.getMetaData();
            for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                String columnName = rsmd.getColumnName(i + 1);
                String columnType = rsmd.getColumnTypeName(i + 1);
                ResultsetColumnHeaderData columnHeader = ResultsetColumnHeaderData.basic((String)columnName, (String)columnType, (DatabaseType)this.databaseTypeResolver.databaseType());
                columnHeaders.add(columnHeader);
            }
            List resultsetDataRows = GenericDataServiceImpl.fillResultsetRowData((SqlRowSet)rs, columnHeaders);
            return new GenericResultsetData(columnHeaders, resultsetDataRows);
        }
        catch (DataAccessException e) {
            log.error("Reporting error: {}", (Object)e.getMessage());
            throw ErrorHandler.getMappable((Throwable)e, (String)"error.msg.report.unknown.data.integrity.issue", (String)((Object)((Object)e)).getClass().getName(), null, (Object[])new Object[]{e});
        }
    }

    public List<ResultsetColumnHeaderData> fillResultsetColumnHeaders(String tableName) {
        SqlRowSet columnDefinitions = this.getTableMetaData(tableName);
        List indexDefinitions = this.getDatatableIndexData(tableName);
        DatabaseType dialect = this.databaseTypeResolver.databaseType();
        ArrayList<ResultsetColumnHeaderData> columnHeaders = new ArrayList<ResultsetColumnHeaderData>();
        columnDefinitions.beforeFirst();
        while (columnDefinitions.next()) {
            String columnName = columnDefinitions.getString(1);
            String isNullable = columnDefinitions.getString(2);
            String isPrimaryKey = columnDefinitions.getString(5);
            String columnType = columnDefinitions.getString(3);
            Long columnLength = columnDefinitions.getLong(4);
            boolean columnNullable = "YES".equalsIgnoreCase(isNullable) || "TRUE".equalsIgnoreCase(isNullable);
            boolean columnIsPrimaryKey = "PRI".equalsIgnoreCase(isPrimaryKey) || "TRUE".equalsIgnoreCase(isPrimaryKey);
            boolean columnIsUnique = columnIsPrimaryKey || this.isExplicitlyUnique(tableName, columnName, indexDefinitions);
            boolean columnIsIndexed = columnIsPrimaryKey || columnIsUnique || this.isExplicitlyIndexed(tableName, columnName, indexDefinitions);
            JdbcJavaType jdbcType = JdbcJavaType.getByTypeName((DatabaseType)dialect, (String)columnType, (boolean)false);
            List columnValues = new ArrayList();
            String codeName = null;
            int codePosition = columnName.indexOf("_cd");
            if (codePosition > 0 && jdbcType != null && (jdbcType.isVarcharType() || jdbcType.isIntegerType())) {
                codeName = columnName.substring(0, codePosition);
                columnValues = this.retrieveCodeValues(codeName);
            }
            columnHeaders.add(ResultsetColumnHeaderData.detailed((String)columnName, (String)columnType, (Long)columnLength, (boolean)columnNullable, (boolean)columnIsPrimaryKey, columnValues, (String)codeName, (boolean)columnIsUnique, (boolean)columnIsIndexed, (DatabaseType)dialect));
        }
        return columnHeaders;
    }

    @NonNull
    public List<ResultsetRowData> fillResultsetRowData(String sql, List<ResultsetColumnHeaderData> columnHeaders) {
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(sql);
        return GenericDataServiceImpl.fillResultsetRowData((SqlRowSet)rs, columnHeaders);
    }

    @NonNull
    private static List<ResultsetRowData> fillResultsetRowData(SqlRowSet rs, List<ResultsetColumnHeaderData> columnHeaders) {
        SqlRowSetMetaData rsmd = rs.getMetaData();
        ArrayList<ResultsetRowData> resultsetDataRows = new ArrayList<ResultsetRowData>();
        while (rs.next()) {
            ArrayList<Object> columnValues = new ArrayList<Object>();
            for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                Object tmpDate;
                String columnName = rsmd.getColumnName(i + 1);
                JdbcJavaType colType = columnHeaders.get(i).getColumnType();
                if (colType == JdbcJavaType.DATE) {
                    tmpDate = (Date)rs.getObject(columnName);
                    columnValues.add(tmpDate == null ? null : ((Date)tmpDate).toLocalDate());
                    continue;
                }
                if (colType == JdbcJavaType.DATETIME || colType == JdbcJavaType.TIMESTAMP) {
                    tmpDate = rs.getObject(columnName);
                    columnValues.add(tmpDate == null ? null : (tmpDate instanceof Timestamp ? ((Timestamp)tmpDate).toLocalDateTime() : tmpDate));
                    continue;
                }
                columnValues.add(rs.getObject(columnName));
            }
            resultsetDataRows.add(ResultsetRowData.create(columnValues));
        }
        return resultsetDataRows;
    }

    public String replace(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuilder result = new StringBuilder();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public String wrapSQL(String sql) {
        return "select x.* from (" + sql + ") x";
    }

    public String generateJsonFromGenericResultsetData(GenericResultsetData grs) {
        StringBuilder writer = new StringBuilder();
        writer.append("[");
        List columnHeaders = grs.getColumnHeaders();
        List data = grs.getData();
        String doubleQuote = "\"";
        String slashDoubleQuote = "\\\"";
        for (int i = 0; i < data.size(); ++i) {
            writer.append("\n{");
            List row = ((ResultsetRowData)data.get(i)).getRow();
            Integer rSize = row.size();
            for (int j = 0; j < rSize; ++j) {
                Object currVal;
                ResultsetColumnHeaderData columnHeader = (ResultsetColumnHeaderData)columnHeaders.get(j);
                writer.append("\"" + columnHeader.getColumnName() + "\": ");
                ResultsetColumnHeaderData.DisplayType colDisplayType = columnHeader.getColumnDisplayType();
                JdbcJavaType colType = columnHeader.getColumnType();
                if (colDisplayType == null) {
                    colDisplayType = ResultsetColumnHeaderData.calcColumnDisplayType((JdbcJavaType)colType);
                }
                if ((currVal = row.get(j)) != null && colDisplayType != null) {
                    if (colDisplayType == ResultsetColumnHeaderData.DisplayType.DATE) {
                        LocalDate localDate = (LocalDate)currVal;
                        writer.append(String.format("[%d,%d,%d]", localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth()));
                    } else if (colDisplayType == ResultsetColumnHeaderData.DisplayType.DATETIME) {
                        LocalDateTime localDateTime = (LocalDateTime)currVal;
                        writer.append(String.format("[%d,%d,%d,%d,%d,%d,%d]", localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano()));
                    } else if (colDisplayType == ResultsetColumnHeaderData.DisplayType.TIME) {
                        LocalTime localTime = (LocalTime)currVal;
                        writer.append(String.format("[%d,%d,%d,%d]", localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNano()));
                    } else if (colDisplayType == ResultsetColumnHeaderData.DisplayType.DECIMAL || colDisplayType == ResultsetColumnHeaderData.DisplayType.INTEGER || colDisplayType == ResultsetColumnHeaderData.DisplayType.CODELOOKUP) {
                        writer.append(currVal);
                    } else {
                        writer.append("\"" + this.replace(String.valueOf(currVal), "\"", "\\\"") + "\"");
                    }
                } else {
                    writer.append("null");
                }
                if (j >= rSize - 1) continue;
                writer.append(",\n");
            }
            if (i < data.size() - 1) {
                writer.append("},");
                continue;
            }
            writer.append("}");
        }
        writer.append("\n]");
        return writer.toString();
    }

    private boolean isExplicitlyUnique(String tableName, String columnName, List<IndexDetail> indexDefinitions) {
        String keyNameToCheck = this.datatableKeywordGenerator.generateUniqueKeyName(tableName, columnName);
        return this.checkKeyPresent(keyNameToCheck, indexDefinitions);
    }

    public boolean isExplicitlyUnique(String tableName, String columnName) {
        return this.isExplicitlyUnique(tableName, columnName, this.getDatatableIndexData(tableName));
    }

    private boolean isExplicitlyIndexed(String tableName, String columnName, List<IndexDetail> indexDefinitions) {
        String keyNameToCheck = this.datatableKeywordGenerator.generateIndexName(tableName, columnName);
        return this.checkKeyPresent(keyNameToCheck, indexDefinitions);
    }

    public boolean isExplicitlyIndexed(String tableName, String columnName) {
        return this.isExplicitlyIndexed(tableName, columnName, this.getDatatableIndexData(tableName));
    }

    private boolean checkKeyPresent(String keyNameToCheck, List<IndexDetail> indexDefinitions) {
        for (IndexDetail indexDetail : indexDefinitions) {
            if (!indexDetail.getIndexName().equals(keyNameToCheck)) continue;
            return true;
        }
        return false;
    }

    private List<IndexDetail> getDatatableIndexData(String tableName) {
        try {
            return this.databaseIndependentQueryService.getTableIndexes((DataSource)this.dataSource, tableName);
        }
        catch (IllegalArgumentException e) {
            throw new DatatableNotFoundException(tableName);
        }
    }

    private List<ResultsetColumnValueData> retrieveCodeValues(String codeName) {
        String sql = "select v.id, v.code_score, v.code_value from m_code m join m_code_value v on v.code_id = m.id where m.code_name = ? order by v.order_position, v.id";
        SqlRowSet rsValues = this.jdbcTemplate.queryForRowSet("select v.id, v.code_score, v.code_value from m_code m join m_code_value v on v.code_id = m.id where m.code_name = ? order by v.order_position, v.id", new Object[]{codeName});
        ArrayList<ResultsetColumnValueData> columnValues = new ArrayList<ResultsetColumnValueData>();
        rsValues.beforeFirst();
        while (rsValues.next()) {
            Integer id = rsValues.getInt("id");
            String codeValue = rsValues.getString("code_value");
            Integer score = rsValues.getInt("code_score");
            columnValues.add(new ResultsetColumnValueData(id.intValue(), codeValue, score.intValue()));
        }
        return columnValues;
    }

    private SqlRowSet getTableMetaData(String tableName) {
        try {
            return this.databaseIndependentQueryService.getTableColumns((DataSource)this.dataSource, tableName);
        }
        catch (IllegalArgumentException e) {
            throw new DatatableNotFoundException(tableName);
        }
    }

    @Generated
    public GenericDataServiceImpl(JdbcTemplate jdbcTemplate, RoutingDataSource dataSource, DatabaseIndependentQueryService databaseIndependentQueryService, DatatableKeywordGenerator datatableKeywordGenerator, DatabaseTypeResolver databaseTypeResolver) {
        this.jdbcTemplate = jdbcTemplate;
        this.dataSource = dataSource;
        this.databaseIndependentQueryService = databaseIndependentQueryService;
        this.datatableKeywordGenerator = datatableKeywordGenerator;
        this.databaseTypeResolver = databaseTypeResolver;
    }
}

