/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.entityaccess.service;

import java.time.LocalDate;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepositoryWrapper;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.configuration.domain.GlobalConfigurationProperty;
import org.apache.fineract.infrastructure.configuration.domain.GlobalConfigurationRepositoryWrapper;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityAccessType;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityRelation;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityRelationRepositoryWrapper;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityToEntityMapping;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityToEntityMappingRepository;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityType;
import org.apache.fineract.infrastructure.entityaccess.service.FineractEntityAccessReadService;
import org.apache.fineract.infrastructure.entityaccess.service.FineractEntityAccessWriteService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FineractEntityAccessUtil {
    private final PlatformSecurityContext context;
    private final GlobalConfigurationRepositoryWrapper globalConfigurationRepository;
    private final CodeValueReadPlatformService codeValueReadPlatformService;
    private final CodeValueRepositoryWrapper codeValueRepository;
    private final FineractEntityAccessWriteService fineractEntityAccessWriteService;
    private final FineractEntityAccessReadService fineractEntityAccessReadService;
    private final FineractEntityRelationRepositoryWrapper fineractEntityRelationRepositoryWrapper;
    private final FineractEntityToEntityMappingRepository fineractEntityToEntityMappingRepository;

    @Autowired
    public FineractEntityAccessUtil(PlatformSecurityContext context, GlobalConfigurationRepositoryWrapper globalConfigurationRepository, FineractEntityAccessWriteService fineractEntityAccessWriteService, CodeValueReadPlatformService codeValueReadPlatformService, CodeValueRepositoryWrapper codeValueRepository, FineractEntityAccessReadService fineractEntityAccessReadService, FineractEntityRelationRepositoryWrapper fineractEntityRelationRepositoryWrapper, FineractEntityToEntityMappingRepository fineractEntityToEntityMappingRepository) {
        this.context = context;
        this.globalConfigurationRepository = globalConfigurationRepository;
        this.fineractEntityAccessWriteService = fineractEntityAccessWriteService;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
        this.codeValueRepository = codeValueRepository;
        this.fineractEntityAccessReadService = fineractEntityAccessReadService;
        this.fineractEntityRelationRepositoryWrapper = fineractEntityRelationRepositoryWrapper;
        this.fineractEntityToEntityMappingRepository = fineractEntityToEntityMappingRepository;
    }

    @Transactional
    public void checkConfigurationAndAddProductResrictionsForUserOffice(FineractEntityAccessType fineractEntityAccessType, Long productOrChargeId) {
        GlobalConfigurationProperty restrictToUserOfficeProperty;
        AppUser thisUser = this.context.authenticatedUser();
        GlobalConfigurationProperty property = this.globalConfigurationRepository.findOneByNameWithNotFoundDetection("office-specific-products-enabled");
        if (property.isEnabled() && (restrictToUserOfficeProperty = this.globalConfigurationRepository.findOneByNameWithNotFoundDetection("restrict-products-to-user-office")).isEnabled()) {
            Long officeId = (Long)thisUser.getOffice().getId();
            LocalDate startDateFormapping = null;
            LocalDate endDateFormapping = null;
            FineractEntityRelation fineractEntityRelation = this.fineractEntityRelationRepositoryWrapper.findOneByCodeName(fineractEntityAccessType.getStr());
            Long relId = (Long)fineractEntityRelation.getId();
            FineractEntityRelation mapId = this.fineractEntityRelationRepositoryWrapper.findOneWithNotFoundDetection(relId);
            FineractEntityToEntityMapping newMap = FineractEntityToEntityMapping.newMap((FineractEntityRelation)mapId, (Long)officeId, (Long)productOrChargeId, startDateFormapping, endDateFormapping);
            this.fineractEntityToEntityMappingRepository.save((Object)newMap);
        }
    }

    public String getSQLWhereClauseForProductIDsForUserOffice_ifGlobalConfigEnabled(FineractEntityType fineractEntityType) {
        String inClause = "";
        GlobalConfigurationProperty property = this.globalConfigurationRepository.findOneByNameWithNotFoundDetection("office-specific-products-enabled");
        if (property.isEnabled()) {
            if (fineractEntityType.equals(FineractEntityType.SAVINGS_PRODUCT)) {
                inClause = this.fineractEntityAccessReadService.getSQLQueryInClauseIDList_ForSavingsProductsForOffice((Long)this.context.authenticatedUser().getOffice().getId(), false);
            } else if (fineractEntityType.equals(FineractEntityType.LOAN_PRODUCT)) {
                inClause = this.fineractEntityAccessReadService.getSQLQueryInClauseIDList_ForLoanProductsForOffice((Long)this.context.authenticatedUser().getOffice().getId(), false);
            } else if (fineractEntityType.equals(FineractEntityType.CHARGE)) {
                inClause = this.fineractEntityAccessReadService.getSQLQueryInClauseIDList_ForChargesForOffice((Long)this.context.authenticatedUser().getOffice().getId(), false);
            }
        }
        return inClause;
    }
}

