/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.service.serialization.serializer.document;

import lombok.Generated;
import org.apache.avro.generic.GenericContainer;
import org.apache.fineract.avro.document.v1.DocumentDataV1;
import org.apache.fineract.avro.generator.ByteBufferSerializable;
import org.apache.fineract.infrastructure.documentmanagement.data.DocumentData;
import org.apache.fineract.infrastructure.documentmanagement.domain.Document;
import org.apache.fineract.infrastructure.documentmanagement.service.DocumentReadPlatformService;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.document.DocumentBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.document.DocumentCreatedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.document.DocumentDeletedBusinessEvent;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.document.DocumentDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.BusinessEventSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DocumentBusinessEventSerializer
implements BusinessEventSerializer {
    private static final Logger log = LoggerFactory.getLogger(DocumentBusinessEventSerializer.class);
    private final DocumentReadPlatformService service;
    private final DocumentDataMapper mapper;

    public <T> boolean canSerialize(BusinessEvent<T> event) {
        return event instanceof DocumentCreatedBusinessEvent || event instanceof DocumentDeletedBusinessEvent;
    }

    public <T> ByteBufferSerializable toAvroDTO(BusinessEvent<T> rawEvent) {
        DocumentBusinessEvent event = (DocumentBusinessEvent)rawEvent;
        Document entity = (Document)event.get();
        DocumentData dto = null;
        if (rawEvent instanceof DocumentCreatedBusinessEvent) {
            try {
                dto = this.service.retrieveDocument(entity.getParentEntityType(), entity.getParentEntityId(), (Long)entity.getId());
            }
            catch (Exception ex) {
                log.debug("DocumentData not found, falling back to entity", (Throwable)ex);
            }
        }
        DocumentDataV1 avro = dto != null ? this.mapper.map(dto) : DocumentDataV1.newBuilder().setId((Long)entity.getId()).setParentEntityType(entity.getParentEntityType()).setParentEntityId(entity.getParentEntityId()).setName(entity.getName()).setFileName(entity.getFileName()).setSize(entity.getSize()).setType(entity.getType()).setDescription(entity.getDescription()).build();
        Integer storageTypeCode = dto != null && dto.getStorageType() != null && dto.storageType() != null ? dto.getStorageType() : (entity.storageType() != null ? entity.storageType().getValue() : null);
        avro.setStorageType(storageTypeCode);
        return avro;
    }

    public Class<? extends GenericContainer> getSupportedSchema() {
        return DocumentDataV1.class;
    }

    @Generated
    public DocumentBusinessEventSerializer(DocumentReadPlatformService service, DocumentDataMapper mapper) {
        this.service = service;
        this.mapper = mapper;
    }
}

